/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.item.extra;

import com.sofodev.armorplus.registry.ModPotions;
import com.sofodev.armorplus.registry.item.extra.Buff;
import com.sofodev.armorplus.registry.item.extra.IBuff;
import com.sofodev.armorplus.utils.ToolTipUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BuffInstance {
    private final boolean instant;
    private final MobEffectInstance effect;
    private IBuff buff;
    private int amplifier;
    private boolean enabled;

    public BuffInstance(boolean enabled, IBuff buff, int amplifier) {
        this(enabled ? buff : Buff.NONE, amplifier, 20, true);
    }

    public BuffInstance(IBuff buff, int amplifier) {
        this(buff, amplifier, 20, true);
    }

    public BuffInstance(boolean enabled, IBuff buff, int amplifier, int duration) {
        this(enabled ? buff : Buff.NONE, amplifier, duration, false);
    }

    public BuffInstance(IBuff buff, int amplifier, int duration) {
        this(buff, amplifier, duration, false);
    }

    public BuffInstance(IBuff buff, int amplifier, int duration, boolean instant) {
        this.buff = buff;
        this.amplifier = amplifier;
        this.instant = instant;
        this.effect = buff.isEffect() && buff.getEffect() != null ? new MobEffectInstance(buff.getEffect(), Utils.convertToSeconds(duration), amplifier, false, false) : new MobEffectInstance((MobEffect)ModPotions.EMPTY.get());
        this.enabled = true;
    }

    public BuffInstance(boolean enabled, IBuff buff) {
        this.buff = enabled ? buff : Buff.NONE;
        this.amplifier = -1;
        this.instant = true;
        this.effect = new MobEffectInstance((MobEffect)ModPotions.EMPTY.get());
        this.enabled = true;
    }

    public BuffInstance(IBuff buff) {
        this.buff = buff;
        this.amplifier = -1;
        this.instant = true;
        this.effect = new MobEffectInstance((MobEffect)ModPotions.EMPTY.get());
        this.enabled = true;
    }

    public static BuffInstance build(IBuff buff, int amplifier, int duration, boolean instant) {
        return new BuffInstance(buff, amplifier, duration, instant);
    }

    public static BuffInstance build(IBuff buff, int amplifier, int duration) {
        return new BuffInstance(buff, amplifier, duration);
    }

    public static BuffInstance build(IBuff buff, int amplifier) {
        return new BuffInstance(buff, amplifier);
    }

    public static BuffInstance build(IBuff buff) {
        return new BuffInstance(buff);
    }

    public void onInventoryTick(ItemStack stack, Level world, Player player) {
        this.buff.onInventoryTick(stack, world, player);
        if (this.buff.isEffect()) {
            MobEffectInstance currentEffect = this.effect;
            if (this.instant || !player.m_21023_(currentEffect.m_19544_())) {
                player.m_7292_(currentEffect);
            }
        }
    }

    public void hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.buff.hitEntity(stack, target, attacker);
        if (this.buff.isEffect()) {
            target.m_7292_(this.effect);
        }
    }

    public MobEffectInstance getEffect() {
        return this.effect;
    }

    public IBuff getBuff() {
        return this.buff;
    }

    public BuffInstance setBuff(IBuff buff) {
        this.buff = buff;
        return this;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public BuffInstance setAmplifier(int amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BuffInstance setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MutableComponent getTranslatedName() {
        String name = this.buff.name().toLowerCase(Locale.ENGLISH);
        return this.buff.isEffect() ? ToolTipUtils.translate(ChatFormatting.DARK_AQUA, "armorplus.effect." + name, new Object[0]) : ToolTipUtils.translate(ChatFormatting.DARK_AQUA, "armorplus.buff." + name, new Object[0]);
    }

    public String toString() {
        return "BuffInstance{buff=%s, amplifier=%d, instant=%s, potion=%s, enabled=%s}".formatted(this.buff, this.amplifier, this.instant, this.effect, this.enabled);
    }
}

