/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.item.armor;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.item.armor.APArmorProperties;
import com.sofodev.armorplus.registry.item.armor.IAPArmor;
import com.sofodev.armorplus.registry.item.extra.Buff;
import com.sofodev.armorplus.registry.item.extra.BuffInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum APArmorMaterial implements IAPArmor
{
    COAL((ArmorMaterial)APArmorProperties.COAL_PROP, ChatFormatting.GRAY, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.NIGHT_VISION, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.coalMaterial;
        }
    }
    ,
    REDSTONE((ArmorMaterial)APArmorProperties.REDSTONE_PROP, ChatFormatting.DARK_RED, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.HASTE, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.redstoneMaterial;
        }
    }
    ,
    LAPIS((ArmorMaterial)APArmorProperties.LAPIS_PROP, ChatFormatting.DARK_BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.WATER_BREATHING, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.lapisMaterial;
        }
    }
    ,
    CHICKEN((ArmorMaterial)APArmorProperties.CHICKEN_PROP, ChatFormatting.WHITE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.SPEED, 3))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.chickenMaterial;
        }
    }
    ,
    SLIME((ArmorMaterial)APArmorProperties.SLIME_PROP, ChatFormatting.GREEN, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.JUMP_BOOST, 3), new BuffInstance(Buff.SLOW_FALLING, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slimeMaterial;
        }
    }
    ,
    EMERALD((ArmorMaterial)APArmorProperties.EMERALD_PROP, ChatFormatting.DARK_GREEN, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.SPEED, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.emeraldMaterial;
        }
    }
    ,
    OBSIDIAN((ArmorMaterial)APArmorProperties.OBSIDIAN_PROP, true, ChatFormatting.DARK_GRAY, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.RESISTANCE, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.obsidianMaterial;
        }
    }
    ,
    INFUSED_LAVA((ArmorMaterial)APArmorProperties.INFUSED_LAVA_PROP, true, ChatFormatting.GOLD, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.FIRE_RESISTANCE, 0), new BuffInstance(Buff.FIRE_EXTINGUISH), new BuffInstance(Buff.WATER_WEAKNESS))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.infusedLavaMaterial;
        }
    }
    ,
    GUARDIAN((ArmorMaterial)APArmorProperties.GUARDIAN_PROP, true, ChatFormatting.BLUE, (Supplier)APArmorMaterial.fromConfig(() -> ArmorPlusConfig.guardianMaterial)){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.guardianMaterial;
        }
    }
    ,
    SUPER_STAR((ArmorMaterial)APArmorProperties.SUPER_STAR_PROP, true, ChatFormatting.WHITE, (Supplier)APArmorMaterial.fromConfig(() -> ArmorPlusConfig.superStarMaterial)){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.superStarMaterial;
        }
    }
    ,
    ENDER_DRAGON((ArmorMaterial)APArmorProperties.ENDER_DRAGON_PROP, true, ChatFormatting.DARK_PURPLE, (Supplier)APArmorMaterial.fromConfig(() -> ArmorPlusConfig.enderDragonMaterial)){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.enderDragonMaterial;
        }
    }
    ,
    ARDITE(APArmorProperties.ARDITE_PROP, ChatFormatting.RED),
    COBALT(APArmorProperties.COBALT_PROP, ChatFormatting.BLUE),
    KNIGHT_SLIME(APArmorProperties.KNIGHT_SLIME_PROP, ChatFormatting.LIGHT_PURPLE),
    PIG_IRON(APArmorProperties.PIG_IRON_PROP, ChatFormatting.LIGHT_PURPLE),
    MANYULLYN(APArmorProperties.MANYULLYN_PROP, ChatFormatting.DARK_PURPLE),
    SLAYER((ArmorMaterial)APArmorProperties.SLAYER_PROP, true, ChatFormatting.DARK_PURPLE, (Supplier)APArmorMaterial.fromConfig(() -> ArmorPlusConfig.slayerMaterial)){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slayerMaterial;
        }
    }
    ,
    CHAINMAIL(APArmorProperties.ENHANCED_CHAINMAIL_PROP, ChatFormatting.GRAY),
    GOLDEN(APArmorProperties.ENHANCED_GOLD_PROP, ChatFormatting.GRAY),
    IRON(APArmorProperties.ENHANCED_IRON_PROP, ChatFormatting.GRAY),
    DIAMOND(APArmorProperties.ENHANCED_DIAMOND_PROP, ChatFormatting.GRAY),
    NETHERITE(APArmorProperties.ENHANCED_NETHERITE_PROP, true, ChatFormatting.GRAY, Collections::emptyList),
    FROST((ArmorMaterial)APArmorProperties.FROST_PROP, false, ChatFormatting.BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.FIRE_WEAKNESS))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.frostMaterial;
        }
    }
    ,
    FROST_LAVA((ArmorMaterial)APArmorProperties.FROST_LAVA_PROP, true, ChatFormatting.YELLOW, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.NATURAL_IMMUNITY))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.frostLavaMaterial;
        }
    };

    private final ArmorMaterial armor;
    private final boolean isImmuneToFire;
    private final Supplier<List<BuffInstance>> buffs;
    private final ChatFormatting formatting;

    private APArmorMaterial() {
        this((ArmorMaterial)ArmorMaterials.IRON, false, ChatFormatting.RESET, Collections::emptyList);
    }

    private APArmorMaterial(ArmorMaterial armor) {
        this(armor, false, ChatFormatting.RESET, Collections::emptyList);
    }

    private APArmorMaterial(ArmorMaterial armor, ChatFormatting formatting) {
        this(armor, false, formatting, Collections::emptyList);
    }

    private APArmorMaterial(ArmorMaterial armor, ChatFormatting formatting, Supplier<List<BuffInstance>> buffs) {
        this(armor, false, formatting, buffs);
    }

    private APArmorMaterial(ArmorMaterial armor, boolean isImmuneToFire, ChatFormatting formatting, Supplier<List<BuffInstance>> buffs) {
        this.armor = armor;
        this.isImmuneToFire = isImmuneToFire;
        this.buffs = buffs;
        this.formatting = formatting;
    }

    private static Supplier<List<BuffInstance>> fromConfig(Supplier<ArmorPlusConfig.AdvancedMaterialConfig> configSupplier) {
        return () -> {
            ArmorPlusConfig.AdvancedMaterialConfig config = (ArmorPlusConfig.AdvancedMaterialConfig)configSupplier.get();
            if (config == null) {
                return List.of();
            }
            return Arrays.asList(new BuffInstance(config.enableNIGHT_VISION.get(), Buff.NIGHT_VISION, (int)config.amplifierNIGHT_VISION.get()), new BuffInstance(config.enableWATER_BREATHING.get(), Buff.WATER_BREATHING, (int)config.amplifierWATER_BREATHING.get()), new BuffInstance(config.enableSTRENGTH.get(), Buff.STRENGTH, (int)config.amplifierSTRENGTH.get()), new BuffInstance(config.enableSPEED.get(), Buff.SPEED, (int)config.amplifierSPEED.get()), new BuffInstance(config.enableHASTE.get(), Buff.HASTE, (int)config.amplifierHASTE.get()), new BuffInstance(config.enableJUMP_BOOST.get(), Buff.JUMP_BOOST, (int)config.amplifierJUMP_BOOST.get()), new BuffInstance(config.enableREGENERATION.get(), Buff.REGENERATION, (int)config.amplifierREGENERATION.get(), 200), new BuffInstance(config.enableRESISTANCE.get(), Buff.RESISTANCE, (int)config.amplifierRESISTANCE.get()), new BuffInstance(config.enableFIRE_RESISTANCE.get(), Buff.FIRE_RESISTANCE, (int)config.amplifierFIRE_RESISTANCE.get()), new BuffInstance(config.enableSATURATION.get(), Buff.SATURATION, (int)config.amplifierSATURATION.get()), new BuffInstance(config.enableINVISIBILITY.get(), Buff.INVISIBILITY, (int)config.amplifierINVISIBILITY.get()), new BuffInstance(config.enableHEALTH_BOOST.get(), Buff.HEALTH_BOOST, (int)config.amplifierHEALTH_BOOST.get(), 200), new BuffInstance(config.enableABSORPTION.get(), Buff.ABSORPTION, (int)config.amplifierABSORPTION.get(), 200), new BuffInstance(config.enableSLOW_FALLING.get(), Buff.SLOW_FALLING, (int)config.amplifierSLOW_FALLING.get()), new BuffInstance(config.enableFLIGHT.get(), Buff.FLIGHT), new BuffInstance(config.enableWITHER_IMMUNITY.get(), Buff.WITHER_IMMUNITY), new BuffInstance(config.enableNATURAL_IMMUNITY.get(), Buff.NATURAL_IMMUNITY), new BuffInstance(config.enableFIRE_EXTINGUISH.get(), Buff.FIRE_EXTINGUISH));
        };
    }

    private static List<BuffInstance> withBuffs(BuffInstance ... buffs) {
        return Arrays.asList(buffs);
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public ArmorMaterial get() {
        return this.armor;
    }

    @Override
    public Item.Properties getProperties() {
        return new Item.Properties().m_41497_(Rarity.create((String)this.getName(), (ChatFormatting)this.getFormatting()));
    }

    @Override
    public boolean isImmuneToFire() {
        return this.isImmuneToFire;
    }

    @Override
    public ChatFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public Supplier<List<BuffInstance>> getBuffInstances() {
        return this.buffs;
    }

    @Override
    public ArmorPlusConfig.MaterialConfig config() {
        return IAPArmor.super.config();
    }

    public String toString() {
        return "APArmorMaterial{armor=" + String.valueOf(this.armor) + ", isImmuneToFire=" + this.isImmuneToFire + ", buffs=" + String.valueOf(this.buffs) + ", formatting=" + String.valueOf(this.formatting) + "}";
    }
}

