/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.item.armor;

import com.sofodev.armorplus.registry.item.armor.IAPArmor;
import com.sofodev.armorplus.registry.item.extra.Buff;
import com.sofodev.armorplus.registry.item.extra.BuffInstance;
import com.sofodev.armorplus.utils.ItemArmorUtility;
import com.sofodev.armorplus.utils.RomanNumeralUtil;
import com.sofodev.armorplus.utils.ToolTipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class APArmorItem
extends ArmorItem {
    private IAPArmor mat;

    public APArmorItem(IAPArmor mat, ArmorItem.Type slot) {
        super(mat.get(), slot, mat.isImmuneToFire() ? mat.getProperties().m_41499_(mat.get().m_266425_(slot)).m_41486_() : mat.getProperties().m_41499_(mat.get().m_266425_(slot)));
        this.mat = mat;
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        List<BuffInstance> buffs;
        if (level.m_5776_() || !this.mat.config().enableArmorEffects.get().booleanValue()) {
            return;
        }
        List<BuffInstance> list = buffs = this.mat.getBuffInstances() != null ? this.mat.getBuffInstances().get() : List.of();
        if (buffs.isEmpty()) {
            return;
        }
        for (BuffInstance instance : buffs) {
            if (!(instance.getBuff() instanceof Buff) || !instance.isEnabled() || instance.getBuff().requiresFullSet() && !ItemArmorUtility.areExactMatch(this.mat, player)) continue;
            if (instance.getBuff().isEffect()) {
                if (player.m_21023_(instance.getEffect().m_19544_())) continue;
                instance.onInventoryTick(stack, level, player);
                continue;
            }
            instance.onInventoryTick(stack, level, player);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        List<BuffInstance> buffs = this.mat.getBuffInstances().get();
        if (!buffs.isEmpty()) {
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.YELLOW, "tooltip.armorplus.condition", this.mat.config().enableArmorEffects.get() != false ? "" : "(DISABLED)"));
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.GOLD, "tooltip.armorplus.condition.full_set", new Object[0]));
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.GREEN, "tooltip.armorplus.provides", new Object[0]));
            for (BuffInstance buff : buffs) {
                if (buff.getBuff() == Buff.NONE) continue;
                int lvl = buff.getAmplifier() + 1;
                String roman = lvl > 0 ? " " + RomanNumeralUtil.generate(lvl) : "";
                tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.DARK_AQUA, "tooltip.armorplus.buff", buff.getTranslatedName(), roman));
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public ArmorMaterial m_40401_() {
        return this.mat.get();
    }

    public IAPArmor getMat() {
        return this.mat;
    }
}

