/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entity.arrow;

import com.sofodev.armorplus.registry.entity.arrow.ArrowProperty;
import com.sofodev.armorplus.utils.Utils;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class APArrowEntity
extends AbstractArrow {
    private EntityType<? extends APArrowEntity> type;
    private ArrowProperty prop;

    public APArrowEntity(EntityType<? extends APArrowEntity> type, Level world) {
        super(type, world);
        this.type = type;
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, Level world, ArrowProperty property) {
        super(type, world);
        this.type = type;
        this.setProp(property);
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, double x, double y, double z, Level world, ArrowProperty property) {
        super(type, x, y, z, world);
        this.type = type;
        this.setProp(property);
        this.m_6034_(x, y, z);
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, LivingEntity shooter, Level world, ArrowProperty property) {
        super(type, shooter, world);
        this.type = type;
        this.setProp(property);
        this.m_5602_((Entity)shooter);
        if (shooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, PlayMessages.SpawnEntity packet, Level world, ArrowProperty property) {
        this(type, packet.getPosX(), packet.getPosY(), packet.getPosZ(), world, property);
        this.type = type;
        this.m_19915_(packet.getHeadYaw(), packet.getPitch());
        this.m_20084_(packet.getUuid());
        this.m_20234_(packet.getEntityId());
        this.m_20334_(packet.getVelX(), packet.getVelY(), packet.getVelZ());
    }

    public ArrowProperty getProp() {
        return this.prop;
    }

    public void setProp(ArrowProperty prop) {
        this.prop = prop;
    }

    public double m_36789_() {
        return super.m_36789_();
    }

    public void m_36781_(double damageIn) {
        if (this.prop != null) {
            super.m_36781_(this.prop.getDmg());
        }
        super.m_36781_(damageIn);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getProp());
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected ItemStack m_7941_() {
        if (this.prop != null) {
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(Utils.setRL(this.prop.getName() + "_arrow")));
            return stack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : stack;
        }
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public EntityType<?> m_6095_() {
        return this.type == null ? EntityType.f_20548_ : this.type;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? this.m_19879_() : entity.m_19879_());
    }

    protected void m_7761_(LivingEntity target) {
        super.m_7761_(target);
        if (!this.m_9236_().f_46443_) {
            this.prop.hit(target);
        }
    }
}

