/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.registry.entity.arrow.APArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.ArrowType;
import com.sofodev.armorplus.registry.entity.arrow.impl.CoalArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.EmeraldArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.EnderDragonArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.GuardianArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.InfusedLavaArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.LapisArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.ObsidianArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.RedstoneArrowEntity;
import com.sofodev.armorplus.registry.entity.arrow.impl.SuperStarArrowEntity;
import com.sofodev.armorplus.utils.Utils;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"armorplus");
    public static final RegistryObject<EntityType<APArrowEntity>> COAL_ARROW = ModEntities.register("coal_arrow", () -> ModEntities.buildArrow(CoalArrowEntity::new, ArrowType.COAL));
    public static final RegistryObject<EntityType<APArrowEntity>> LAPIS_ARROW = ModEntities.register("lapis_arrow", () -> ModEntities.buildArrow(LapisArrowEntity::new, ArrowType.LAPIS));
    public static final RegistryObject<EntityType<APArrowEntity>> REDSTONE_ARROW = ModEntities.register("redstone_arrow", () -> ModEntities.buildArrow(RedstoneArrowEntity::new, ArrowType.REDSTONE));
    public static final RegistryObject<EntityType<APArrowEntity>> EMERALD_ARROW = ModEntities.register("emerald_arrow", () -> ModEntities.buildArrow(EmeraldArrowEntity::new, ArrowType.EMERALD));
    public static final RegistryObject<EntityType<APArrowEntity>> OBSIDIAN_ARROW = ModEntities.register("obsidian_arrow", () -> ModEntities.buildArrow(ObsidianArrowEntity::new, ArrowType.OBSIDIAN));
    public static final RegistryObject<EntityType<APArrowEntity>> INFUSED_LAVA_ARROW = ModEntities.register("infused_lava_arrow", () -> ModEntities.buildArrow(InfusedLavaArrowEntity::new, ArrowType.INFUSED_LAVA));
    public static final RegistryObject<EntityType<APArrowEntity>> GUARDIAN_ARROW = ModEntities.register("guardian_arrow", () -> ModEntities.buildArrow(GuardianArrowEntity::new, ArrowType.GUARDIAN));
    public static final RegistryObject<EntityType<APArrowEntity>> SUPER_STAR_ARROW = ModEntities.register("super_star_arrow", () -> ModEntities.buildArrow(SuperStarArrowEntity::new, ArrowType.SUPER_STAR));
    public static final RegistryObject<EntityType<APArrowEntity>> ENDER_DRAGON_ARROW = ModEntities.register("ender_dragon_arrow", () -> ModEntities.buildArrow(EnderDragonArrowEntity::new, ArrowType.ENDER_DRAGON));

    public static <ENTITY extends Entity> RegistryObject<EntityType<ENTITY>> register(String name, Supplier<EntityType<ENTITY>> sup) {
        return ENTITY_TYPES.register(name, sup);
    }

    private static <ENTITY extends AbstractArrow> EntityType<ENTITY> buildArrow(EntityType.EntityFactory<ENTITY> factoryIn, ArrowType data) {
        return ModEntities.build(data.getItemArrowName(), EntityType.Builder.m_20704_(factoryIn, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    }

    private static <ENTITY extends Entity> EntityType<ENTITY> build(String id, EntityType.Builder<ENTITY> builder) {
        ResourceLocation rl = Utils.setRL(id);
        return builder.m_20712_(rl.toString());
    }
}

