/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.registry.block.castle.BrickColor;
import com.sofodev.armorplus.utils.Utils;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="armorplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"armorplus");
    public static final RegistryObject<CreativeModeTab> AP_CORE_GROUP = ModCreativeTabs.register("core", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)Utils.getAPItem("infused_lava_chestplate"))).m_257941_((Component)Component.m_237115_((String)"tabs.armorplus.core")).withLabelColor(0xFFFFFF).withSearchBar(40).withBackgroundLocation(ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)"textures/gui/container/creative_inventory/tab_armorplus_small_search.png")).m_257501_((featureFlags, output) -> {
        ModCreativeTabs.addEquipmentToOutput(output, "coal");
        ModCreativeTabs.addEquipmentToOutput(output, "redstone");
        ModCreativeTabs.addEquipmentToOutput(output, "lapis");
        ModCreativeTabs.addEquipmentToOutput(output, "emerald");
        ModCreativeTabs.addEquipmentToOutput(output, "obsidian");
        ModCreativeTabs.addEquipmentToOutput(output, "infused_lava");
        ModCreativeTabs.addEquipmentToOutput(output, "guardian");
        ModCreativeTabs.addEquipmentToOutput(output, "super_star");
        ModCreativeTabs.addEquipmentToOutput(output, "ender_dragon");
        ModCreativeTabs.addEquipmentToOutput(output, "slayer");
    }).m_257652_());
    public static final RegistryObject<CreativeModeTab> AP_EXTRA_GROUP = ModCreativeTabs.register("extra", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)Utils.getAPItem("cobalt_chestplate"))).m_257941_((Component)Component.m_237115_((String)"tabs.armorplus.extra")).withLabelColor(0xFFFFFF).withBackgroundLocation(ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)"textures/gui/container/creative_inventory/tab_armorplus_small_search.png")).withSearchBar(40).m_257501_((featureFlags, output) -> {
        ModCreativeTabs.addSetToOutput(output, "chainmail");
        output.m_246326_((ItemLike)ModItems.ENHANCED_CHAINMAIL.get());
        ModCreativeTabs.addSetToOutput(output, "chicken");
        ModCreativeTabs.addSetToOutput(output, "golden");
        output.m_246326_((ItemLike)ModItems.ENHANCED_GOLD.get());
        ModCreativeTabs.addSetToOutput(output, "slime");
        ModCreativeTabs.addSetToOutput(output, "iron");
        output.m_246326_((ItemLike)ModItems.ENHANCED_IRON.get());
        ModCreativeTabs.addSetToOutput(output, "ardite");
        ModCreativeTabs.addSetToOutput(output, "diamond");
        output.m_246326_((ItemLike)ModItems.ENHANCED_DIAMOND.get());
        ModCreativeTabs.addSetToOutput(output, "cobalt");
        ModCreativeTabs.addSetToOutput(output, "netherite");
        output.m_246326_((ItemLike)ModItems.ENHANCED_NETHERITE.get());
        ModCreativeTabs.addSetToOutput(output, "knight_slime");
        ModCreativeTabs.addSetToOutput(output, "frost");
        output.m_246326_((ItemLike)ModItems.FROST_SHARD.get());
        ModCreativeTabs.addSetToOutput(output, "pig_iron");
        ModCreativeTabs.addSetToOutput(output, "frost_lava");
        output.m_246326_((ItemLike)ModItems.LAVA_SHARD.get());
        ModCreativeTabs.addSetToOutput(output, "manyullyn");
    }).m_257652_());
    public static final RegistryObject<CreativeModeTab> AP_ITEM_GROUP = ModCreativeTabs.register("items", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get())).m_257941_((Component)Component.m_237115_((String)"tabs.armorplus.items")).withBackgroundLocation(ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)"textures/gui/container/creative_inventory/tab_armorplus.png")).withSearchBar().withLabelColor(0xFFFFFF).m_257501_((featureFlags, output) -> {
        output.m_246326_((ItemLike)ModItems.LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModItems.FROST_CRYSTAL.get());
        output.m_246326_((ItemLike)ModItems.INFUSED_FROST_CRYSTAL.get());
        output.m_246326_((ItemLike)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModItems.GUARDIAN_SCALE.get());
        output.m_246326_((ItemLike)ModItems.WITHER_BONE.get());
        output.m_246326_((ItemLike)ModItems.ENDER_DRAGON_SCALE.get());
        output.m_246326_((ItemLike)ModItems.THE_ULTIMATE_MATERIAL.get());
        output.m_246326_((ItemLike)ModItems.ITEM_COAL_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_REDSTONE_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_LAPIS_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_EMERALD_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_OBSIDIAN_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_INFUSED_LAVA_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_GUARDIAN_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_SUPER_STAR_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ITEM_ENDER_DRAGON_ARROW.get());
        output.m_246326_((ItemLike)ModItems.ELDER_GUARDIAN_SOUL.get());
        ModCreativeTabs.addBasesToOutput(output, "guardian");
        output.m_246326_((ItemLike)ModItems.WITHER_BOSS_SOUL.get());
        ModCreativeTabs.addBasesToOutput(output, "super_star");
        output.m_246326_((ItemLike)ModItems.ENDER_DRAGON_SOUL.get());
        ModCreativeTabs.addBasesToOutput(output, "ender_dragon");
        output.m_246326_((ItemLike)ModItems.SLAYER_SOUL.get());
        ModCreativeTabs.addBasesToOutput(output, "slayer");
        output.m_246326_((ItemLike)ModItems.WITHER_SKELETON_SOUL.get());
        output.m_246326_((ItemLike)ModItems.GUARDIAN_SOUL.get());
        output.m_246326_((ItemLike)ModItems.ENDERMAN_SOUL.get());
        output.m_246326_((ItemLike)ModItems.BLAZE_SOUL.get());
        output.m_246326_((ItemLike)ModItems.ENHANCED_CHAINMAIL.get());
        output.m_246326_((ItemLike)ModItems.ENHANCED_IRON.get());
        output.m_246326_((ItemLike)ModItems.ENHANCED_GOLD.get());
        output.m_246326_((ItemLike)ModItems.ENHANCED_DIAMOND.get());
        output.m_246326_((ItemLike)ModItems.ENHANCED_NETHERITE.get());
        output.m_246326_((ItemLike)ModItems.CHAINMAIL.get());
        output.m_246326_((ItemLike)ModItems.OBSIDIAN_STICK.get());
        output.m_246326_((ItemLike)ModItems.WOODEN_ROD.get());
        output.m_246326_((ItemLike)ModItems.LAVA_SHARD.get());
        output.m_246326_((ItemLike)ModItems.FROST_SHARD.get());
        output.m_246326_((ItemLike)ModItems.THANK_YOU.get());
    }).m_257652_());
    public static final RegistryObject<CreativeModeTab> AP_BLOCK_GROUP = ModCreativeTabs.register("blocks", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ModBlocks.INFUSED_LAVA_CRYSTAL.get())).m_257941_((Component)Component.m_237115_((String)"tabs.armorplus.blocks")).withBackgroundLocation(ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)"textures/gui/container/creative_inventory/tab_armorplus.png")).withLabelColor(0xFFFFFF).withSearchBar().m_257501_((featureFlags, output) -> {
        output.m_246326_((ItemLike)ModBlocks.ORE_LAVA_CRYSTAL_STONE.get());
        output.m_246326_((ItemLike)ModBlocks.ORE_LAVA_CRYSTAL_OBSIDIAN.get());
        output.m_246326_((ItemLike)ModBlocks.ORE_LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.INFUSED_LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.COMPRESSED_LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.COMPRESSED_INFUSED_LAVA_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.LAVA_INFUSED_OBSIDIAN.get());
        output.m_246326_((ItemLike)ModBlocks.COMPRESSED_OBSIDIAN.get());
        output.m_246326_((ItemLike)ModBlocks.ORE_FROST_CRYSTAL_STONE.get());
        output.m_246326_((ItemLike)ModBlocks.ORE_FROST_CRYSTAL_OBSIDIAN.get());
        output.m_246326_((ItemLike)ModBlocks.ORE_FROST_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.FROST_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.INFUSED_FROST_CRYSTAL.get());
        output.m_246326_((ItemLike)ModBlocks.SNOW_BRICK.get());
        output.m_246326_((ItemLike)ModBlocks.SNOW_BRICK_STAIRS.get());
        output.m_246326_((ItemLike)ModBlocks.SNOW_BRICK_SLAB.get());
        output.m_246326_((ItemLike)ModBlocks.PETRIFIED_SOULS.get());
        output.m_246326_((ItemLike)ModBlocks.SOUL_BOX.get());
        IntStream.range(0, ArmorPlus.AP_STONE_BRICKS_LENGTH).forEach(index -> {
            String color = BrickColor.values()[index].getName();
            output.m_246326_((ItemLike)ModBlocks.STONE_BRICKS[index].get());
            output.m_246326_((ItemLike)ModBlocks.STONE_BRICK_CORNERS[index].get());
            output.m_246326_((ItemLike)ModBlocks.STONE_BRICK_TOWERS[index].get());
            output.m_246326_((ItemLike)ModBlocks.STONE_BRICK_WALLS[index].get());
            output.m_246326_((ItemLike)ModBlocks.STONE_BRICK_STAIRS[index].get());
            output.m_246326_((ItemLike)ModBlocks.STONE_BRICK_SLABS[index].get());
            output.m_246326_((ItemLike)ModBlocks.CASTLE_BLOCKS[index].get());
            output.m_246326_((ItemLike)ModBlocks.CASTLE_BLOCK_CORNERS[index].get());
            output.m_246326_((ItemLike)ModBlocks.CASTLE_BLOCK_TOWERS[index].get());
            output.m_246326_((ItemLike)ModBlocks.CASTLE_BLOCK_WALLS[index].get());
            output.m_246326_((ItemLike)ModBlocks.CASTLE_BLOCK_STAIRS[index].get());
            output.m_246326_((ItemLike)ModBlocks.CASTLE_BLOCK_SLABS[index].get());
        });
    }).m_257652_());

    private static void addBasesToOutput(CreativeModeTab.Output output, String material) {
        Set set = ItemStackLinkedSet.m_261170_();
        set.add(Utils.getAPItemStack(material + "_helmet_base"));
        set.add(Utils.getAPItemStack(material + "_chestplate_base"));
        set.add(Utils.getAPItemStack(material + "_leggings_base"));
        set.add(Utils.getAPItemStack(material + "_boots_base"));
        set.add(Utils.getAPItemStack(material + "_sword_base"));
        set.add(Utils.getAPItemStack(material + "_battle_axe_base"));
        set.add(Utils.getAPItemStack(material + "_pickaxe_base"));
        set.add(Utils.getAPItemStack(material + "_bow_base"));
        output.m_246601_((Collection)set);
    }

    private static void addEquipmentToOutput(CreativeModeTab.Output output, String material) {
        Set set = ItemStackLinkedSet.m_261170_();
        ModCreativeTabs.addSetToOutput(output, material);
        set.add(Utils.getAPItemStack(material + "_sword"));
        set.add(Utils.getAPItemStack(material + "_battle_axe"));
        set.add(Utils.getAPItemStack(material + "_pickaxe"));
        set.add(Utils.getAPItemStack(material + "_mace"));
        set.add(Utils.getAPItemStack(material + "_bow"));
        output.m_246601_((Collection)set);
    }

    private static void addSetToOutput(CreativeModeTab.Output output, String material) {
        Set set = ItemStackLinkedSet.m_261170_();
        set.add(Utils.getAPItemStack(material + "_helmet"));
        set.add(Utils.getAPItemStack(material + "_chestplate"));
        set.add(Utils.getAPItemStack(material + "_leggings"));
        set.add(Utils.getAPItemStack(material + "_boots"));
        output.m_246601_((Collection)set);
    }

    public static RegistryObject<CreativeModeTab> register(String name, Supplier<? extends CreativeModeTab> sup) {
        return CREATIVE_MODE_TABS.register(name, sup);
    }
}

