/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.registry.block.APBlock;
import com.sofodev.armorplus.registry.block.APBlockItem;
import com.sofodev.armorplus.registry.block.APFrostBlock;
import com.sofodev.armorplus.registry.block.APLavaBlock;
import com.sofodev.armorplus.registry.block.castle.BrickColor;
import com.sofodev.armorplus.registry.block.castle.CastleBlock;
import com.sofodev.armorplus.registry.block.castle.StoneBrickBlock;
import com.sofodev.armorplus.registry.block.castle.StoneBrickCornerBlock;
import com.sofodev.armorplus.registry.block.castle.StoneBrickSlabBlock;
import com.sofodev.armorplus.registry.block.castle.StoneBrickStairsBlock;
import com.sofodev.armorplus.registry.block.castle.StoneBrickTowerBlock;
import com.sofodev.armorplus.registry.block.castle.StoneBrickWallBlock;
import com.sofodev.armorplus.registry.block.ore.CrystalOreBlock;
import com.sofodev.armorplus.registry.block.ore.Variant;
import com.sofodev.armorplus.registry.block.special.SoulBox;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"armorplus");
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"armorplus");
    public static final RegistryObject<Block>[] STONE_BRICKS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_TOWERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_CORNERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_WALLS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_STAIRS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_SLABS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCKS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_TOWERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_CORNERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_WALLS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_STAIRS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_SLABS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block> COMPRESSED_OBSIDIAN = ModBlocks.registerBlockWithItem("compressed_obsidian", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50080_)));
    public static final RegistryObject<Block> ORE_LAVA_CRYSTAL = ModBlocks.registerBlockWithItem("ore_lava_crystal", () -> new CrystalOreBlock(Variant.ORIGINAL));
    public static final RegistryObject<Block> ORE_LAVA_CRYSTAL_STONE = ModBlocks.registerBlockWithItem("ore_lava_crystal_stone", () -> new CrystalOreBlock(Variant.STONE));
    public static final RegistryObject<Block> ORE_LAVA_CRYSTAL_OBSIDIAN = ModBlocks.registerBlockWithItem("ore_lava_crystal_obsidian", () -> new CrystalOreBlock(Variant.OBSIDIAN));
    public static final RegistryObject<Block> LAVA_CRYSTAL = ModBlocks.registerBlockWithItem("block_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> INFUSED_LAVA_CRYSTAL = ModBlocks.registerBlockWithItem("block_infused_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> COMPRESSED_LAVA_CRYSTAL = ModBlocks.registerBlockWithItem("compressed_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> COMPRESSED_INFUSED_LAVA_CRYSTAL = ModBlocks.registerBlockWithItem("compressed_infused_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> LAVA_INFUSED_OBSIDIAN = ModBlocks.registerBlockWithItem("lava_infused_obsidian", () -> new APLavaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283889_).m_60913_(25.0f, 2000.0f)));
    public static final RegistryObject<Block> ORE_FROST_CRYSTAL = ModBlocks.registerBlockWithItem("ore_frost_crystal", () -> new CrystalOreBlock(Variant.ORIGINAL));
    public static final RegistryObject<Block> ORE_FROST_CRYSTAL_STONE = ModBlocks.registerBlockWithItem("ore_frost_crystal_stone", () -> new CrystalOreBlock(Variant.STONE));
    public static final RegistryObject<Block> ORE_FROST_CRYSTAL_OBSIDIAN = ModBlocks.registerBlockWithItem("ore_frost_crystal_obsidian", () -> new CrystalOreBlock(Variant.OBSIDIAN));
    public static final RegistryObject<Block> FROST_CRYSTAL = ModBlocks.registerBlockWithItem("block_frost_crystal", APFrostBlock::new);
    public static final RegistryObject<Block> INFUSED_FROST_CRYSTAL = ModBlocks.registerBlockWithItem("block_infused_frost_crystal", APFrostBlock::new);
    public static final RegistryObject<Block> SNOW_BRICK = ModBlocks.registerBlockWithItem("snow_brick", () -> new APBlock(Blocks.f_50125_, 2.0f, 20.0f));
    public static final RegistryObject<Block> SNOW_BRICK_STAIRS = ModBlocks.registerBlockWithItem("snow_brick_stairs", () -> new StoneBrickStairsBlock(() -> ((Block)SNOW_BRICK.get()).m_49966_(), (Block)SNOW_BRICK.get()));
    public static final RegistryObject<Block> SNOW_BRICK_SLAB = ModBlocks.registerBlockWithItem("snow_brick_slab", () -> new StoneBrickSlabBlock((Block)SNOW_BRICK.get()));
    public static final RegistryObject<Block> PETRIFIED_SOULS = ModBlocks.registerBlockWithItem("petrified_souls", () -> new APBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_)));
    public static final RegistryObject<Block> SOUL_BOX = ModBlocks.registerBlockWithItem("soul_box", SoulBox::new);

    public static <BLOCK extends Block> RegistryObject<BLOCK> registerBlockWithItem(String name, DeferredRegister<Block> blocks, DeferredRegister<Item> items, Supplier<BLOCK> blockSupplier, Function<BLOCK, Item> itemFactory) {
        RegistryObject block = blocks.register(name, blockSupplier);
        items.register(name, () -> (Item)itemFactory.apply((Block)block.get()));
        return block;
    }

    public static <BLOCK extends Block> RegistryObject<BLOCK> registerBlockWithItem(String name, Supplier<BLOCK> blockSupplier, Function<BLOCK, Item> itemFactory) {
        return ModBlocks.registerBlockWithItem(name, BLOCKS, ModItems.ITEMS, blockSupplier, itemFactory);
    }

    public static <BLOCK extends Block> RegistryObject<BLOCK> registerBlockWithItem(String name, Supplier<BLOCK> blockSupplier) {
        return ModBlocks.registerBlockWithItem(name, BLOCKS, ModItems.ITEMS, blockSupplier, APBlockItem::new);
    }

    private static <T extends BlockEntity> BlockEntityType<T> build(BlockEntityType.Builder<T> builder) {
        return builder.m_58966_(null);
    }

    public static void registerBlocks() {
        IntStream.range(0, ArmorPlus.AP_STONE_BRICKS_LENGTH).forEach(index -> {
            String color = BrickColor.values()[index].getName();
            ModBlocks.STONE_BRICKS[index] = ModBlocks.registerBlockWithItem(color + "_stone_brick", () -> new StoneBrickBlock(BrickColor.values()[index]));
            ModBlocks.STONE_BRICK_CORNERS[index] = ModBlocks.registerBlockWithItem(color + "_stone_brick_corner", () -> new StoneBrickCornerBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.STONE_BRICK_TOWERS[index] = ModBlocks.registerBlockWithItem(color + "_stone_brick_tower", () -> new StoneBrickTowerBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.STONE_BRICK_WALLS[index] = ModBlocks.registerBlockWithItem(color + "_stone_brick_wall", () -> new StoneBrickWallBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.STONE_BRICK_STAIRS[index] = ModBlocks.registerBlockWithItem(color + "_stone_brick_stairs", () -> new StoneBrickStairsBlock(() -> ((Block)((Block)STONE_BRICKS[index].get())).m_49966_(), (Block)STONE_BRICKS[index].get()));
            ModBlocks.STONE_BRICK_SLABS[index] = ModBlocks.registerBlockWithItem(color + "_stone_brick_slab", () -> new StoneBrickSlabBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.CASTLE_BLOCKS[index] = ModBlocks.registerBlockWithItem(color + "_castle_block", () -> new CastleBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.CASTLE_BLOCK_CORNERS[index] = ModBlocks.registerBlockWithItem(color + "_castle_block_corner", () -> new StoneBrickCornerBlock((Block)CASTLE_BLOCKS[index].get()));
            ModBlocks.CASTLE_BLOCK_TOWERS[index] = ModBlocks.registerBlockWithItem(color + "_castle_block_tower", () -> new StoneBrickTowerBlock((Block)CASTLE_BLOCKS[index].get()));
            ModBlocks.CASTLE_BLOCK_WALLS[index] = ModBlocks.registerBlockWithItem(color + "_castle_block_wall", () -> new StoneBrickWallBlock((Block)CASTLE_BLOCKS[index].get()));
            ModBlocks.CASTLE_BLOCK_STAIRS[index] = ModBlocks.registerBlockWithItem(color + "_castle_block_stairs", () -> new StoneBrickStairsBlock(() -> ((Block)((Block)CASTLE_BLOCKS[index].get())).m_49966_(), (Block)CASTLE_BLOCKS[index].get()));
            ModBlocks.CASTLE_BLOCK_SLABS[index] = ModBlocks.registerBlockWithItem(color + "_castle_block_slab", () -> new StoneBrickSlabBlock((Block)CASTLE_BLOCKS[index].get()));
        });
    }

    static {
        ModBlocks.registerBlocks();
    }
}

