/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.events;

import com.sofodev.armorplus.registry.item.armor.APArmorItem;
import com.sofodev.armorplus.registry.item.armor.IAPArmor;
import com.sofodev.armorplus.registry.item.extra.Buff;
import com.sofodev.armorplus.registry.item.extra.BuffInstance;
import com.sofodev.armorplus.registry.item.extra.DeBuff;
import com.sofodev.armorplus.registry.item.extra.IBuff;
import com.sofodev.armorplus.registry.item.material.FrostCrystalItem;
import com.sofodev.armorplus.registry.item.tool.APMaceItem;
import com.sofodev.armorplus.registry.item.tool.properties.mace.APMaceType;
import com.sofodev.armorplus.utils.ItemArmorUtility;
import com.sofodev.armorplus.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoItem;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModGlobalEvents {
    public static final Random RAND = new Random();
    public static int thunderingTicks = 0;
    private static final String ARMORPLUS_FLIGHT_TAG = "ArmorPlusFlight";
    private static final String ARMORPLUS_PREV_MAYFLY = "ArmorPlusPrevMayfly";

    private static boolean hasEnchant(ItemStack stack, String name) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        return !enchantments.isEmpty() && enchantments.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL(name)));
    }

    private static boolean isFullArmorWithBuff(Player player, IBuff buff) {
        for (ItemStack stack : player.m_6168_()) {
            APArmorItem armor;
            IAPArmor mat;
            Item item = stack.m_41720_();
            if (!(item instanceof APArmorItem) || !ItemArmorUtility.areExactMatch(mat = (armor = (APArmorItem)item).getMat(), player) || !mat.config().enableArmorEffects.get().booleanValue()) continue;
            return mat.getBuffInstances().get().stream().map(BuffInstance::getBuff).anyMatch(b -> b.equals(buff));
        }
        return false;
    }

    private static void grantFlight(Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (!player.getPersistentData().m_128441_(ARMORPLUS_PREV_MAYFLY)) {
            player.getPersistentData().m_128379_(ARMORPLUS_PREV_MAYFLY, player.m_150110_().f_35936_);
        }
        player.m_150110_().f_35936_ = true;
        player.getPersistentData().m_128379_(ARMORPLUS_FLIGHT_TAG, true);
        player.m_6885_();
    }

    private static void revokeFlight(Player player) {
        boolean prevMayfly;
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        boolean hadAPFlight = player.getPersistentData().m_128471_(ARMORPLUS_FLIGHT_TAG);
        if (!hadAPFlight) {
            return;
        }
        player.getPersistentData().m_128473_(ARMORPLUS_FLIGHT_TAG);
        player.m_150110_().f_35936_ = prevMayfly = player.getPersistentData().m_128471_(ARMORPLUS_PREV_MAYFLY);
        if (player.m_150110_().f_35935_) {
            player.m_150110_().f_35935_ = false;
        }
        player.getPersistentData().m_128473_(ARMORPLUS_PREV_MAYFLY);
        player.m_6885_();
    }

    private static void checkAndApplyFlight(Player player) {
        boolean hasOurFlight = ModGlobalEvents.isFullArmorWithBuff(player, Buff.FLIGHT);
        if (hasOurFlight) {
            ModGlobalEvents.grantFlight(player);
        } else {
            ModGlobalEvents.revokeFlight(player);
        }
    }

    private static void checkAndApplyBuffs(Player player) {
        ModGlobalEvents.checkAndApplyFlight(player);
        if (ModGlobalEvents.isFullArmorWithBuff(player, Buff.WATER_WEAKNESS) && player.m_20071_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0, false, false, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent e) {
        Player player = e.player;
        Level world = player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        ModGlobalEvents.checkAndApplyBuffs(player);
        if (!world.m_46470_()) {
            return;
        }
        if ((++thunderingTicks + 1) % 20 != 0 || RAND.nextInt(100) + 1 != 100) {
            return;
        }
        for (ItemStack item : player.m_6168_()) {
            LightningBolt bolt;
            BlockPos pos;
            ArmorMaterial material;
            Item item2 = item.m_41720_();
            if (!(item2 instanceof ArmorItem)) continue;
            ArmorItem armor = (ArmorItem)item2;
            if (!ModGlobalEvents.hasEnchant(item, "unknown") || armor.m_40402_() != EquipmentSlot.HEAD || (material = armor.m_40401_()) != ArmorMaterials.IRON && material != ArmorMaterials.CHAIN && material != ArmorMaterials.GOLD || !world.m_45527_(pos = player.m_20183_()) || (bolt = (LightningBolt)EntityType.f_20465_.m_20615_(world)) == null) continue;
            bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
            bolt.m_20879_((ServerPlayer)player);
            bolt.setDamage(0.0f);
            world.m_7967_((Entity)bolt);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent e) {
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_()) {
            ModGlobalEvents.checkAndApplyBuffs(player);
        }
    }

    @SubscribeEvent
    public static void onArrowLooseEvent(ArrowLooseEvent e) {
        Level world = e.getLevel();
        if (world.m_5776_()) {
            return;
        }
        ItemStack bow = e.getBow();
        if (!ModGlobalEvents.hasEnchant(bow, "unknown")) {
            return;
        }
        int charge = e.getCharge();
        Player shooter = e.getEntity();
        BlockPos pos = shooter.m_20183_();
        Direction dir = shooter.m_6350_();
        IntStream.range(5 + charge / (charge / 2), charge).forEach(arg_0 -> ModGlobalEvents.lambda$onArrowLooseEvent$2(world, dir, pos, bow, (LivingEntity)shooter, arg_0));
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent e) {
        Item item;
        Player player = e.getEntity();
        Level world = player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        Entity target = e.getTarget();
        if (mainHand.m_41720_() instanceof TridentItem && ModGlobalEvents.hasEnchant(mainHand, "unknown")) {
            ModGlobalEvents.spawnLightningCross(world, target.m_20183_());
            player.m_7292_(new MobEffectInstance(DeBuff.SLOWNESS.getEffect(), Utils.convertToSeconds(4)));
            player.m_7292_(new MobEffectInstance(DeBuff.MINING_FATIGUE.getEffect(), Utils.convertToSeconds(4)));
        }
        if (player.m_20096_() && (item = mainHand.m_41720_()) instanceof APMaceItem) {
            APMaceItem mace = (APMaceItem)item;
            double movedDistance = player.f_19787_ - player.f_19867_;
            if (movedDistance < (double)player.m_6113_()) {
                ModGlobalEvents.performMaceSweep(world, player, target, mace);
            }
        }
    }

    private static void spawnLightningCross(Level world, BlockPos pos) {
        List<BlockPos> positions = List.of(pos, pos.m_122013_(2), pos.m_122020_(2), pos.m_122030_(2), pos.m_122025_(2));
        for (BlockPos p : positions) {
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            if (bolt == null) continue;
            bolt.m_20219_(Vec3.m_82539_((Vec3i)p));
            world.m_7967_((Entity)bolt);
        }
    }

    private static void performMaceSweep(Level world, Player player, Entity target, APMaceItem mace) {
        float baseDmg = (float)player.m_21133_(Attributes.f_22281_);
        float sweepDmg = 1.0f + APMaceType.getMaceSweepingRatio(mace.mat.getType()) * baseDmg;
        for (LivingEntity entity : world.m_45976_(LivingEntity.class, target.m_20191_().m_82377_(1.0, 0.25, 1.0))) {
            ArmorStand stand;
            if (entity == player || entity == target || player.m_7307_((Entity)entity) || entity instanceof ArmorStand && (stand = (ArmorStand)entity).m_31677_() || player.m_20280_((Entity)entity) >= 15.0) continue;
            double x = Mth.m_14177_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double z = -x;
            entity.m_147240_((double)0.4f, x, z);
            entity.m_6469_(player.m_269291_().m_269075_(player), sweepDmg);
        }
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            ItemStack stack = mace.setTag(player.m_21205_());
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128403_("key")) {
                mace.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)server), mace.controllerName, "animation.mace.swipe_attack");
            }
        }
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        player.m_36346_();
    }

    @SubscribeEvent
    public static void onStructByLightningEvent(EntityStruckByLightningEvent event) {
        boolean infused;
        ItemEntity entity;
        Item item;
        Entity entity2;
        if (!event.getEntity().m_9236_().f_46443_ && (entity2 = event.getEntity()) instanceof ItemEntity && (item = (entity = (ItemEntity)entity2).m_32055_().m_41720_()) instanceof FrostCrystalItem && !(infused = ((FrostCrystalItem)item).isInfused())) {
            FrostCrystalItem infusedCrystal = (FrostCrystalItem)Utils.getAPItem("infused_frost_crystal");
            entity.m_5552_(new ItemStack((ItemLike)infusedCrystal, entity.m_32055_().m_41613_()), 1.0f);
            entity.m_32055_().m_41764_(0);
            event.getLightning().m_20874_(true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        for (ItemStack stack : entity.m_6168_()) {
            Map enchantments;
            if (!stack.m_41763_() || !(stack.m_41720_() instanceof ArmorItem) || (enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).isEmpty() || !enchantments.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_harden")))) continue;
            int max = stack.m_41776_();
            int current = max - stack.m_41773_();
            if (current == max) {
                stack.m_41721_(0);
                continue;
            }
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        for (ItemStack stack : entity.m_6168_()) {
            Map enchantments;
            if (!stack.m_41763_() || !(stack.m_41720_() instanceof ArmorItem) || (enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).isEmpty() || !enchantments.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_harden")))) continue;
            int max = stack.m_41776_();
            int incoming = stack.m_41773_();
            int current = max - incoming;
            int half = Math.min(max / 2, Math.floorDiv(max, 2));
            if (current == max) {
                stack.m_41721_(half);
                continue;
            }
            if (incoming >= half) {
                stack.m_41721_(half);
                continue;
            }
            stack.m_41721_(max);
            stack.m_41764_(0);
        }
    }

    private static /* synthetic */ void lambda$onArrowLooseEvent$2(Level world, Direction dir, BlockPos pos, ItemStack bow, LivingEntity shooter, int i) {
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
        if (bolt == null) {
            return;
        }
        switch (dir) {
            case NORTH: {
                bolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_122013_(i)));
                break;
            }
            case SOUTH: {
                bolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_122020_(i)));
                break;
            }
            case WEST: {
                bolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_122025_(i)));
                break;
            }
            case EAST: {
                bolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_122030_(i)));
            }
        }
        world.m_7967_((Entity)bolt);
        bow.m_41622_(10, shooter, ev -> ev.m_21190_(shooter.m_7655_()));
    }
}

