/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.events;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.events.ModGlobalEvents;
import com.sofodev.armorplus.utils.Utils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.SpawnData;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModDropsEvents {
    @SubscribeEvent
    public static void onMobDeathEvent(LivingDropsEvent event) {
        Map<Class<Blaze>, MobDropConfig> dropMap;
        MobDropConfig cfg;
        LivingEntity entity = event.getEntity();
        Entity killer = event.getSource().m_7639_();
        boolean hasSoulStealer = false;
        if (killer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)killer;
            ItemStack held = player.m_21205_();
            boolean bl = hasSoulStealer = !held.m_41619_() && EnchantmentHelper.m_44831_((ItemStack)held).containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_stealer")));
        }
        record MobDropConfig(Supplier<Boolean> trophyEnabled, Supplier<Boolean> regularEnabled, Supplier<Boolean> soulEnabled, String regularItem, int regularAmountMin, int regularAmountMax, String soulItem, float trophyScale) {
        }
        if ((cfg = (MobDropConfig)(dropMap = Map.of(WitherBoss.class, new MobDropConfig(() -> ArmorPlusConfig.witherBossDrops.enableTrophyDrops.get(), () -> ArmorPlusConfig.witherBossDrops.enableRegularDrops.get(), () -> ArmorPlusConfig.witherBossDrops.enableSoulDrops.get(), "wither_bone", 4, 6, "soul_wither_boss", 0.2f), EnderDragon.class, new MobDropConfig(() -> ArmorPlusConfig.enderDragonDrops.enableTrophyDrops.get(), () -> ArmorPlusConfig.enderDragonDrops.enableRegularDrops.get(), () -> ArmorPlusConfig.enderDragonDrops.enableSoulDrops.get(), "ender_dragon_scale", 4, 6, "soul_ender_dragon", 0.1f), ElderGuardian.class, new MobDropConfig(() -> ArmorPlusConfig.elderGuardianDrops.enableTrophyDrops.get(), () -> ArmorPlusConfig.elderGuardianDrops.enableRegularDrops.get(), () -> ArmorPlusConfig.elderGuardianDrops.enableSoulDrops.get(), "guardian_scale", 4, 6, "soul_elder_guardian", 0.2f), WitherSkeleton.class, new MobDropConfig(() -> false, () -> ArmorPlusConfig.witherSkeletonDrops.enableRegularDrops.get(), () -> ArmorPlusConfig.witherSkeletonDrops.enableSoulDrops.get(), "wither_bone", 0, 3, "soul_wither_skeleton", 0.0f), Guardian.class, new MobDropConfig(() -> false, () -> ArmorPlusConfig.guardianDrops.enableRegularDrops.get(), () -> ArmorPlusConfig.guardianDrops.enableSoulDrops.get(), "guardian_scale", 0, 3, "soul_guardian", 0.0f), EnderMan.class, new MobDropConfig(() -> false, () -> false, () -> ArmorPlusConfig.endermanDrops.enableSoulDrops.get(), null, 0, 0, "soul_enderman", 0.0f), Blaze.class, new MobDropConfig(() -> false, () -> false, () -> ArmorPlusConfig.blazeDrops.enableSoulDrops.get(), null, 0, 0, "soul_blaze", 0.0f))).entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(entity)).map(Map.Entry::getValue).findFirst().orElse(null)) == null) {
            return;
        }
        if (cfg.trophyEnabled.get().booleanValue()) {
            ModDropsEvents.dropTrophyItem(entity, entity.m_6095_(), cfg.trophyScale);
        }
        if (cfg.regularEnabled.get().booleanValue() && cfg.regularItem != null) {
            int amount = ModGlobalEvents.RAND.nextInt(cfg.regularAmountMax - cfg.regularAmountMin + 1) + cfg.regularAmountMin;
            ModDropsEvents.dropItem((Entity)entity, cfg.regularItem, amount);
        }
        if (hasSoulStealer && cfg.soulEnabled.get().booleanValue() && cfg.soulItem != null) {
            boolean drop;
            boolean bl = drop = !(entity instanceof WitherSkeleton) && !(entity instanceof Guardian) && !(entity instanceof EnderMan) && !(entity instanceof Blaze) || ModGlobalEvents.RAND.nextInt(4) == 0;
            if (drop) {
                ModDropsEvents.dropItem((Entity)entity, cfg.soulItem, 1);
            }
        }
    }

    private static void dropTrophyItem(LivingEntity entity, EntityType<?> type, float scale) {
        ItemStack trophy = new ItemStack((ItemLike)Utils.getAPItem("trophy"));
        CompoundTag tag = new CompoundTag();
        SpawnData trophyEntity = new SpawnData();
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(type);
        if (key == null) {
            key = ResourceLocation.parse((String)"minecraft:pig");
        }
        trophyEntity.m_186567_().m_128359_("id", key.toString());
        tag.m_128365_("DisplayEntity", (Tag)trophyEntity.m_186567_().m_6426_());
        tag.m_128350_("EntityScale", scale);
        trophy.m_41751_(tag);
        entity.m_19983_(trophy);
    }

    private static void dropItem(Entity entity, String item, int amount) {
        entity.m_19983_(new ItemStack((ItemLike)Utils.getAPItem(item), amount));
    }
}

