/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.datagen;

import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.registry.item.armor.APArmorItem;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemTagProvider
extends ItemTagsProvider {
    public ModItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "armorplus", existingFileHelper);
    }

    protected void m_6577_(HolderLookup.Provider lookup) {
        TagKey<Item> ARMORPLUS_SWORDS = this.modTag("swords");
        TagKey<Item> ARMORPLUS_BATTLE_AXES = this.modTag("battle_axes");
        TagKey<Item> ARMORPLUS_PICKAXES = this.modTag("pickaxes");
        TagKey<Item> ARMORPLUS_BOWS = this.modTag("bows");
        TagKey<Item> ARMORPLUS_MACES = this.modTag("maces");
        this.addAllItems(ARMORPLUS_SWORDS, ModItems.SWORDS);
        this.addAllItems(ARMORPLUS_BATTLE_AXES, ModItems.BATTLE_AXES);
        this.addAllItems(ARMORPLUS_PICKAXES, ModItems.PICKAXES);
        this.addAllItems(ARMORPLUS_BOWS, ModItems.BOWS);
        this.addAllItems(ARMORPLUS_MACES, ModItems.MACES);
        this.mirrorMinecraftTag("enchantable/weapon", ARMORPLUS_SWORDS, ARMORPLUS_BATTLE_AXES, ARMORPLUS_MACES);
        this.mirrorMinecraftTag("enchantable/sword", ARMORPLUS_SWORDS);
        this.mirrorMinecraftTag("enchantable/bow", ARMORPLUS_BOWS);
        this.mirrorMinecraftTag("enchantable/mining", ARMORPLUS_PICKAXES, ARMORPLUS_BATTLE_AXES);
        this.mirrorMinecraftTag("enchantable/mining_loot", ARMORPLUS_PICKAXES, ARMORPLUS_BATTLE_AXES);
        this.mirrorMinecraftTag("enchantable/sharp_weapon", ARMORPLUS_SWORDS, ARMORPLUS_BATTLE_AXES);
        TagKey<Item> ARMORPLUS_HELMETS = this.modTag("helmets");
        TagKey<Item> ARMORPLUS_CHESTPLATES = this.modTag("chestplates");
        TagKey<Item> ARMORPLUS_LEGGINGS = this.modTag("leggings");
        TagKey<Item> ARMORPLUS_BOOTS = this.modTag("boots");
        this.addAllItems(ARMORPLUS_HELMETS, ModItems.HELMETS);
        this.addAllItems(ARMORPLUS_CHESTPLATES, ModItems.CHESTPLATES);
        this.addAllItems(ARMORPLUS_LEGGINGS, ModItems.LEGGINGS);
        this.addAllItems(ARMORPLUS_BOOTS, ModItems.BOOTS);
        this.mirrorMinecraftTag("enchantable/head_armor", ARMORPLUS_HELMETS);
        this.mirrorMinecraftTag("enchantable/chest_armor", ARMORPLUS_CHESTPLATES);
        this.mirrorMinecraftTag("enchantable/leg_armor", ARMORPLUS_LEGGINGS);
        this.mirrorMinecraftTag("enchantable/foot_armor", ARMORPLUS_BOOTS);
        this.mirrorMinecraftTag("enchantable/armor", ARMORPLUS_HELMETS, ARMORPLUS_CHESTPLATES, ARMORPLUS_LEGGINGS, ARMORPLUS_BOOTS);
        this.mirrorMinecraftTag("enchantable/equippable", ARMORPLUS_HELMETS, ARMORPLUS_CHESTPLATES, ARMORPLUS_LEGGINGS, ARMORPLUS_BOOTS);
        this.mirrorMinecraftTag("trimmable_armor", ARMORPLUS_HELMETS, ARMORPLUS_CHESTPLATES, ARMORPLUS_LEGGINGS, ARMORPLUS_BOOTS);
        this.mirrorMinecraftTag("enchantable/durability", ARMORPLUS_HELMETS, ARMORPLUS_CHESTPLATES, ARMORPLUS_LEGGINGS, ARMORPLUS_BOOTS, ARMORPLUS_SWORDS, ARMORPLUS_BATTLE_AXES, ARMORPLUS_PICKAXES, ARMORPLUS_BOWS, ARMORPLUS_MACES);
        this.mirrorMinecraftTag("enchantables", "enchantable/weapon", "enchantable/sword", "enchantable/bow", "enchantable/mining", "enchantable/mining_loot", "enchantable/sharp_weapon", "enchantable/head_armor", "enchantable/chest_armor", "enchantable/leg_armor", "enchantable/foot_armor", "enchantable/armor", "enchantable/durability");
        TagKey<Item> ARMORPLUS_ARROWS = this.modTag("arrows");
        this.addAllItems(ARMORPLUS_ARROWS, ModItems.ITEM_COAL_ARROW, ModItems.ITEM_LAPIS_ARROW, ModItems.ITEM_REDSTONE_ARROW, ModItems.ITEM_EMERALD_ARROW, ModItems.ITEM_OBSIDIAN_ARROW, ModItems.ITEM_INFUSED_LAVA_ARROW, ModItems.ITEM_GUARDIAN_ARROW, ModItems.ITEM_SUPER_STAR_ARROW, ModItems.ITEM_ENDER_DRAGON_ARROW);
        this.mirrorMinecraftTag("arrows", ARMORPLUS_ARROWS);
    }

    private TagKey<Item> modTag(String path) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)path));
    }

    private TagKey<Item> mirrorMinecraftTag(String path, TagKey<Item> ... mirrors) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)path));
        if (mirrors != null) {
            for (TagKey<Item> mirror : mirrors) {
                this.m_206424_(tagKey).m_206428_(mirror);
            }
        }
        return tagKey;
    }

    private TagKey<Item> mirrorMinecraftTag(String path, String ... mirrors) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)path));
        if (mirrors != null) {
            for (String mirror : mirrors) {
                ResourceLocation loc = mirror.contains(":") ? ResourceLocation.parse((String)mirror) : ResourceLocation.withDefaultNamespace((String)mirror);
                this.m_206424_(tagKey).m_206428_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)loc));
            }
        }
        return tagKey;
    }

    @SafeVarargs
    private void addAllItems(TagsProvider.TagAppender<Item> tag, RegistryObject<? extends Item> ... items) {
        for (RegistryObject<? extends Item> obj : items) {
            tag.m_255204_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)obj.getId()));
        }
    }

    private void addAllItems(TagsProvider.TagAppender<Item> tag, Set<RegistryObject<? extends APArmorItem>> items) {
        for (RegistryObject<? extends APArmorItem> obj : items) {
            tag.m_255204_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)obj.getId()));
        }
    }

    @SafeVarargs
    private void addAllItems(TagKey<Item> tagKey, RegistryObject<? extends Item> ... items) {
        for (RegistryObject<? extends Item> obj : items) {
            this.m_206424_(tagKey).m_255204_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)obj.getId()));
        }
    }

    private void addAllItems(TagKey<Item> tagKey, Set<RegistryObject<? extends APArmorItem>> items) {
        for (RegistryObject<? extends APArmorItem> obj : items) {
            this.m_206424_(tagKey).m_255204_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)obj.getId()));
        }
    }
}

