/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.datagen;

import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.registry.item.armor.APArmorItem;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "armorplus", existingFileHelper);
    }

    protected void registerModels() {
        this.generateItemModel(ModItems.THANK_YOU);
        this.generateItemModel(ModItems.CHAINMAIL, ModItems.ENHANCED_CHAINMAIL, ModItems.ENHANCED_IRON, ModItems.ENHANCED_GOLD, ModItems.ENHANCED_DIAMOND, ModItems.ENHANCED_NETHERITE, ModItems.ENHANCED_CHAINMAIL);
        this.generateItemModel(ModItems.GUARDIAN_SOUL, ModItems.ELDER_GUARDIAN_SOUL, ModItems.GUARDIAN_SCALE, ModItems.GUARDIAN_BOW_BASE, ModItems.GUARDIAN_SWORD_BASE, ModItems.GUARDIAN_PICKAXE_BASE, ModItems.GUARDIAN_BATTLE_AXE_BASE);
        this.generateItemModel(ModItems.WITHER_BOSS_SOUL, ModItems.WITHER_SKELETON_SOUL, ModItems.WITHER_BONE, ModItems.SUPER_STAR_BOW_BASE, ModItems.SUPER_STAR_SWORD_BASE, ModItems.SUPER_STAR_PICKAXE_BASE, ModItems.SUPER_STAR_BATTLE_AXE_BASE);
        this.generateItemModel(ModItems.ENDER_DRAGON_SOUL, ModItems.ENDERMAN_SOUL, ModItems.ENDER_DRAGON_SCALE, ModItems.ENDER_DRAGON_BOW_BASE, ModItems.ENDER_DRAGON_SWORD_BASE, ModItems.ENDER_DRAGON_PICKAXE_BASE, ModItems.ENDER_DRAGON_BATTLE_AXE_BASE);
        this.generateItemModel(ModItems.LAVA_SHARD, ModItems.LAVA_CRYSTAL, ModItems.INFUSED_LAVA_CRYSTAL);
        this.generateItemModel(ModItems.FROST_SHARD, ModItems.FROST_CRYSTAL, ModItems.INFUSED_FROST_CRYSTAL);
        this.generateItemModel(ModItems.INFUSED_FROST_LAVA_CRYSTAL, ModItems.THE_ULTIMATE_MATERIAL);
        this.generateItemModel(ModItems.SLAYER_SOUL, ModItems.SLAYER_BOW_BASE, ModItems.SLAYER_SWORD_BASE, ModItems.SLAYER_PICKAXE_BASE, ModItems.SLAYER_BATTLE_AXE_BASE);
        this.generateArmorModels(ModItems.HELMETS);
        this.generateArmorModels(ModItems.CHESTPLATES);
        this.generateArmorModels(ModItems.LEGGINGS);
        this.generateArmorModels(ModItems.BOOTS);
        this.generateSwordModel(ModItems.SWORDS);
        this.generateBattleAxeModel(ModItems.BATTLE_AXES);
        this.generateItemModel(ModItems.PICKAXES);
        this.generateItemModel(ModItems.GUARDIAN_BASES);
        this.generateItemModel(ModItems.SUPER_STAR_BASES);
        this.generateItemModel(ModItems.ENDER_DRAGON_BASES);
        this.generateItemModel(ModItems.SLAYER_BASES);
        this.generateBlockItemModel(ModBlocks.SOUL_BOX);
    }

    private void generateItemModel(RegistryObject<Item> item) {
        ResourceLocation itemId = item.getId();
        String path = itemId.m_135815_();
        ResourceLocation textureID = itemId;
        if (path.contains("enhanced") || path.contains("en_")) {
            Object enhanced = path.replace("enhanced_", "").replace("en_", "");
            if (!path.contains("chainmail")) {
                if (path.contains("iron") || path.contains("gold") || path.contains("netherite")) {
                    enhanced = (String)enhanced + "_ingot";
                }
                textureID = ResourceLocation.m_135820_((String)enhanced);
            } else {
                textureID = ResourceLocation.m_214293_((String)"armorplus", (String)enhanced);
            }
        }
        if (textureID != null) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemId.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", textureID.m_246208_("item/"));
        }
    }

    @SafeVarargs
    private void generateItemModel(RegistryObject<Item> ... items) {
        for (RegistryObject<Item> item : items) {
            this.generateItemModel(item);
        }
    }

    private void generateItemModel(Set<RegistryObject<Item>> items) {
        for (RegistryObject<Item> item : items) {
            this.generateItemModel(item);
        }
    }

    private void generateSwordModel(RegistryObject<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), this.modLoc("handheld_sword"))).texture("layer0", this.modLoc("item/" + item.getId().m_135815_()));
    }

    @SafeVarargs
    private void generateSwordModel(RegistryObject<Item> ... items) {
        for (RegistryObject<Item> item : items) {
            this.generateSwordModel(item);
        }
    }

    private void generateBattleAxeModel(RegistryObject<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), this.modLoc("handheld_battle_axe"))).texture("layer0", this.modLoc("item/" + item.getId().m_135815_()));
    }

    @SafeVarargs
    private void generateBattleAxeModel(RegistryObject<Item> ... items) {
        for (RegistryObject<Item> item : items) {
            this.generateBattleAxeModel(item);
        }
    }

    private void generateArmorModels(Set<RegistryObject<? extends APArmorItem>> items) {
        for (RegistryObject<? extends APArmorItem> obj : items) {
            this.generateTrimmableItemModel(obj);
        }
    }

    private void generateTrimmableItemModel(RegistryObject<? extends APArmorItem> itemRegistryObject) {
        String layer0;
        ArmorItem armorItem = (ArmorItem)itemRegistryObject.get();
        String itemName = itemRegistryObject.getId().m_135815_();
        ResourceLocation modTextureCheck = this.modLoc("textures/item/" + itemName + ".png");
        if (this.existingFileHelper.exists(modTextureCheck, PackType.CLIENT_RESOURCES)) {
            layer0 = this.modLoc("item/" + itemName).toString();
        } else {
            ResourceLocation mcTextureCheck = this.mcLoc("textures/item/" + itemName + ".png");
            if (this.existingFileHelper.exists(mcTextureCheck, PackType.CLIENT_RESOURCES)) {
                layer0 = this.mcLoc("item/" + itemName).toString();
            } else {
                System.out.println("Warning: No texture found for " + itemName + ", skipping model generation.");
                return;
            }
        }
        trimMaterials.forEach((trimMaterial, trimValue) -> {
            String armorType = switch (armorItem.m_40402_()) {
                case EquipmentSlot.HEAD -> "helmet";
                case EquipmentSlot.CHEST -> "chestplate";
                case EquipmentSlot.LEGS -> "leggings";
                case EquipmentSlot.FEET -> "boots";
                default -> "";
            };
            String currentTrimName = itemName + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
            ResourceLocation trimResLoc = ResourceLocation.withDefaultNamespace((String)("trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_()));
            ResourceLocation trimNameResLoc = ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)currentTrimName);
            this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", layer0)).texture("layer1", trimResLoc);
            ((ItemModelBuilder)this.withExistingParent(itemName, this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.m_135827_() + ":item/" + trimNameResLoc.m_135815_())).predicate(this.mcLoc("trim_type"), trimValue.floatValue()).end().texture("layer0", layer0);
        });
    }

    private ItemModelBuilder generateBlockItemModel(RegistryObject<? extends Block> item) {
        return (ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)("block/" + item.getId().m_135815_())));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

