/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.datagen;

import com.sofodev.armorplus.utils.Utils;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class ModAdvancementProvider
implements ForgeAdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider registries, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement root = this.createAdvancement("root", null, (ItemLike)Utils.getAPItem("redstone_chestplate"), "textures/item/compressed_obsidian.png", FrameType.TASK, false, false, RequirementsStrategy.f_15979_, "minecraft:crafting_table");
        saver.accept(root);
        Advancement coalArmor = this.createAdvancement("coal_armor", root, (ItemLike)Utils.getAPItem("coal_chestplate"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:coal_helmet", "armorplus:coal_chestplate", "armorplus:coal_leggings", "armorplus:coal_boots");
        saver.accept(coalArmor);
        Advancement coalWeaponry = this.createAdvancement("coal_weaponry", coalArmor, (ItemLike)Utils.getAPItem("coal_sword"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:coal_sword", "armorplus:coal_battle_axe", "armorplus:coal_mace");
        saver.accept(coalWeaponry);
        Advancement lapisArmor = this.createAdvancement("lapis_armor", root, (ItemLike)Utils.getAPItem("lapis_chestplate"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:lapis_helmet", "armorplus:lapis_chestplate", "armorplus:lapis_leggings", "armorplus:lapis_boots");
        saver.accept(lapisArmor);
        Advancement lapisWeaponry = this.createAdvancement("lapis_weaponry", lapisArmor, (ItemLike)Utils.getAPItem("lapis_sword"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:lapis_sword", "armorplus:lapis_battle_axe", "armorplus:lapis_mace");
        saver.accept(lapisWeaponry);
        Advancement redstoneArmor = this.createAdvancement("redstone_armor", root, (ItemLike)Utils.getAPItem("redstone_chestplate"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:redstone_helmet", "armorplus:redstone_chestplate", "armorplus:redstone_leggings", "armorplus:redstone_boots");
        saver.accept(redstoneArmor);
        Advancement redstoneWeaponry = this.createAdvancement("redstone_weaponry", redstoneArmor, (ItemLike)Utils.getAPItem("redstone_sword"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:redstone_sword", "armorplus:redstone_battle_axe", "armorplus:redstone_mace");
        saver.accept(redstoneWeaponry);
        Advancement emeraldArmor = this.createAdvancement("emerald_armor", root, (ItemLike)Utils.getAPItem("emerald_chestplate"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:emerald_helmet", "armorplus:emerald_chestplate", "armorplus:emerald_leggings", "armorplus:emerald_boots");
        saver.accept(emeraldArmor);
        Advancement emeraldWeaponry = this.createAdvancement("emerald_weaponry", emeraldArmor, (ItemLike)Utils.getAPItem("emerald_sword"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:emerald_sword", "armorplus:emerald_battle_axe", "armorplus:emerald_mace");
        saver.accept(emeraldWeaponry);
        Advancement obsidianArmor = this.createAdvancement("obsidian_armor", root, (ItemLike)Utils.getAPItem("obsidian_chestplate"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:obsidian_helmet", "armorplus:obsidian_chestplate", "armorplus:obsidian_leggings", "armorplus:obsidian_boots");
        saver.accept(obsidianArmor);
        Advancement obsidianWeaponry = this.createAdvancement("obsidian_weaponry", obsidianArmor, (ItemLike)Utils.getAPItem("obsidian_sword"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:obsidian_sword", "armorplus:obsidian_battle_axe", "armorplus:obsidian_mace");
        saver.accept(obsidianWeaponry);
        Advancement lavaCrystal = this.createAdvancement("obtained_lava_crystal", root, (ItemLike)Utils.getAPItem("infused_lava_crystal"), null, FrameType.GOAL, true, true, RequirementsStrategy.f_15979_, "armorplus:infused_lava_crystal");
        saver.accept(lavaCrystal);
        Advancement soulBox = this.createAdvancement("craft_soul_box", root, (ItemLike)Utils.getAPItem("soul_box"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15979_, "armorplus:soul_box");
        saver.accept(soulBox);
        Advancement lavaArmor = this.createAdvancement("infused_lava_armor", lavaCrystal, (ItemLike)Utils.getAPItem("infused_lava_chestplate"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:infused_lava_helmet", "armorplus:infused_lava_chestplate", "armorplus:infused_lava_leggings", "armorplus:infused_lava_boots");
        saver.accept(lavaArmor);
        Advancement lavaWeaponry = this.createAdvancement("infused_lava_weaponry", lavaArmor, (ItemLike)Utils.getAPItem("infused_lava_sword"), null, FrameType.TASK, true, true, RequirementsStrategy.f_15978_, "armorplus:infused_lava_sword", "armorplus:infused_lava_battle_axe", "armorplus:infused_lava_mace");
        saver.accept(lavaWeaponry);
        Advancement guardianSoulObtained = this.createAdvancement("obtained_guardian_soul", lavaCrystal, (ItemLike)Utils.getAPItem("soul_elder_guardian"), null, FrameType.GOAL, true, true, RequirementsStrategy.f_15979_, "armorplus:soul_guardian", "armorplus:soul_elder_guardian");
        saver.accept(guardianSoulObtained);
        Advancement witherSoulObtained = this.createAdvancement("obtained_wither_soul", guardianSoulObtained, (ItemLike)Utils.getAPItem("soul_wither_boss"), null, FrameType.GOAL, true, true, RequirementsStrategy.f_15979_, "armorplus:soul_wither_boss", "armorplus:soul_wither_skeleton");
        saver.accept(witherSoulObtained);
        Advancement dragonSoulObtained = this.createAdvancement("obtained_ender_dragon_soul", witherSoulObtained, (ItemLike)Utils.getAPItem("soul_ender_dragon"), null, FrameType.GOAL, true, true, RequirementsStrategy.f_15979_, "armorplus:soul_ender_dragon", "armorplus:soul_enderman");
        saver.accept(dragonSoulObtained);
        Advancement guardianArmor = this.createAdvancement("guardian_armor", guardianSoulObtained, (ItemLike)Utils.getAPItem("guardian_chestplate"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:guardian_helmet", "armorplus:guardian_chestplate", "armorplus:guardian_leggings", "armorplus:guardian_boots");
        saver.accept(guardianArmor);
        Advancement guardianWeaponry = this.createAdvancement("guardian_weaponry", guardianArmor, (ItemLike)Utils.getAPItem("guardian_sword"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:guardian_sword", "armorplus:guardian_battle_axe", "armorplus:guardian_mace");
        saver.accept(guardianWeaponry);
        Advancement superArmor = this.createAdvancement("super_star_armor", witherSoulObtained, (ItemLike)Utils.getAPItem("super_star_chestplate"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:super_star_helmet", "armorplus:super_star_chestplate", "armorplus:super_star_leggings", "armorplus:super_star_boots");
        saver.accept(superArmor);
        Advancement superWeaponry = this.createAdvancement("super_star_weaponry", superArmor, (ItemLike)Utils.getAPItem("super_star_sword"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:super_star_sword", "armorplus:super_star_battle_axe", "armorplus:super_star_mace");
        saver.accept(superWeaponry);
        Advancement enderArmor = this.createAdvancement("ender_dragon_armor", dragonSoulObtained, (ItemLike)Utils.getAPItem("ender_dragon_chestplate"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:ender_dragon_helmet", "armorplus:ender_dragon_chestplate", "armorplus:ender_dragon_leggings", "armorplus:ender_dragon_boots");
        saver.accept(enderArmor);
        Advancement enderWeaponry = this.createAdvancement("ender_dragon_weaponry", enderArmor, (ItemLike)Utils.getAPItem("ender_dragon_sword"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:ender_dragon_sword", "armorplus:ender_dragon_battle_axe", "armorplus:ender_dragon_mace");
        saver.accept(enderWeaponry);
        Advancement slayerSoulCrafted = this.createAdvancement("obtained_slayer_soul", dragonSoulObtained, (ItemLike)Utils.getAPItem("soul_slayer"), null, FrameType.GOAL, true, true, RequirementsStrategy.f_15979_, "armorplus:soul_slayer");
        saver.accept(slayerSoulCrafted);
        Advancement slayerArmor = this.createAdvancement("slayer_armor", slayerSoulCrafted, (ItemLike)Utils.getAPItem("slayer_chestplate"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:slayer_helmet", "armorplus:slayer_chestplate", "armorplus:slayer_leggings", "armorplus:slayer_boots");
        saver.accept(slayerArmor);
        Advancement slayerWeaponry = this.createAdvancement("slayer_weaponry", slayerArmor, (ItemLike)Utils.getAPItem("slayer_sword"), null, FrameType.CHALLENGE, true, true, RequirementsStrategy.f_15978_, "armorplus:slayer_sword", "armorplus:slayer_battle_axe", "armorplus:slayer_mace");
        saver.accept(slayerWeaponry);
        Advancement thankYou = this.createAdvancement("thank_you", root, (ItemLike)Utils.getAPItem("thank_you"), null, FrameType.TASK, true, false, RequirementsStrategy.f_15979_, "armorplus:redstone_chestplate");
        saver.accept(thankYou);
    }

    private Advancement createAdvancement(String id, Advancement parent, ItemLike iconItem, String backgroundPath, FrameType frame, boolean showToast, boolean announceToChat, RequirementsStrategy strategy, String ... criterionItems) {
        String titleKey = "advancements.armorplus.story." + id + ".title";
        String descKey = "advancements.armorplus.story." + id + ".description";
        DisplayInfo display = new DisplayInfo(new ItemStack(iconItem), (Component)Component.m_237115_((String)titleKey), (Component)Component.m_237115_((String)descKey), backgroundPath != null ? ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)backgroundPath) : null, frame, showToast, announceToChat, false);
        int experience = 10;
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138358_(display).m_138356_(AdvancementRewards.Builder.m_10005_((int)experience).m_10004_());
        builder.m_138360_(strategy);
        for (String item : criterionItems) {
            builder.m_138386_(item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Utils.getItemByName(item)}));
        }
        if (parent != null) {
            builder.m_138398_(parent);
        }
        return builder.m_138403_(ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)("story/" + id)));
    }
}

