/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.datagen;

import com.sofodev.armorplus.datagen.ModAdvancementProvider;
import com.sofodev.armorplus.datagen.ModBlockLootTableProvider;
import com.sofodev.armorplus.datagen.ModBlockTagProvider;
import com.sofodev.armorplus.datagen.ModItemModelProvider;
import com.sofodev.armorplus.datagen.ModItemTagProvider;
import com.sofodev.armorplus.datagen.ModPOITagProvider;
import com.sofodev.armorplus.datagen.Recipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="armorplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModBlockTagProvider blockTags = new ModBlockTagProvider(packOutput, provider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, provider, blockTags.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.f_81421_))));
        ModPOITagProvider poiTags = new ModPOITagProvider(packOutput, provider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)poiTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, provider, existingFileHelper, List.of(new ModAdvancementProvider())));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
    }
}

