/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigHelper {
    static final Logger LOGGER = LogManager.getLogger();

    public static <T> T register(ModConfig.Type configType, BiFunction<ForgeConfigSpec.Builder, Subscriber, T> configBuilder) {
        return ConfigHelper.register(ModLoadingContext.get(), FMLJavaModLoadingContext.get(), configType, configBuilder);
    }

    public static <T> T register(ModLoadingContext modContext, FMLJavaModLoadingContext fmlContext, ModConfig.Type configType, BiFunction<ForgeConfigSpec.Builder, Subscriber, T> configBuilder) {
        ArrayList subscriptionList = new ArrayList();
        org.apache.commons.lang3.tuple.Pair entry = new ForgeConfigSpec.Builder().configure(thisBuilder -> configBuilder.apply((ForgeConfigSpec.Builder)thisBuilder, ConfigHelper.getSubscriber(subscriptionList)));
        Object config = entry.getLeft();
        ForgeConfigSpec spec = (ForgeConfigSpec)entry.getRight();
        modContext.registerConfig(configType, (IConfigSpec)spec);
        Consumer<ModConfigEvent> configUpdate = event -> {
            if (event.getConfig().getSpec() == spec) {
                for (ConfigValueListener value : subscriptionList) {
                    value.update();
                }
            }
        };
        fmlContext.getModEventBus().addListener(configUpdate);
        return (T)config;
    }

    private static Subscriber getSubscriber(List<ConfigValueListener<?>> list) {
        return new Subscriber(list);
    }

    public static class Subscriber {
        final List<ConfigValueListener<?>> list;

        Subscriber(List<ConfigValueListener<?>> list) {
            this.list = list;
        }

        public <T> ConfigValueListener<T> subscribe(ForgeConfigSpec.ConfigValue<T> value) {
            return ConfigValueListener.of(value, this.list);
        }

        public <T> ConfigObjectListener<T> subscribeObject(ForgeConfigSpec.Builder builder, String name, Codec<T> codec, T defaultObject) {
            DataResult encodeResult = codec.encodeStart((DynamicOps)TomlConfigOps.INSTANCE, defaultObject);
            Object encodedObject = encodeResult.getOrThrow(false, s -> LOGGER.error("Unable to encode default value: ", s));
            ConfigValueListener<Object> listener = this.subscribe(builder.define(name, encodedObject));
            return new ConfigObjectListener<T>(listener, codec, defaultObject, encodedObject);
        }
    }

    public static class ConfigValueListener<T>
    implements Supplier<T> {
        private final ForgeConfigSpec.ConfigValue<T> configValue;
        private T value = null;

        private ConfigValueListener(ForgeConfigSpec.ConfigValue<T> configValue) {
            this.configValue = configValue;
        }

        protected static <T> ConfigValueListener<T> of(ForgeConfigSpec.ConfigValue<T> configValue, List<ConfigValueListener<?>> valueList) {
            ConfigValueListener<T> value = new ConfigValueListener<T>(configValue);
            valueList.add(value);
            return value;
        }

        protected void update() {
            this.value = this.configValue.get();
        }

        @Override
        public T get() {
            if (this.value == null) {
                this.update();
            }
            return this.value;
        }
    }

    public static class TomlConfigOps
    implements DynamicOps<Object> {
        public static final TomlConfigOps INSTANCE = new TomlConfigOps();

        public Object empty() {
            return NullObject.NULL_OBJECT;
        }

        public <U> U convertTo(DynamicOps<U> outOps, Object input) {
            if (input instanceof Config) {
                return (U)this.convertMap(outOps, input);
            }
            if (input instanceof Collection) {
                return (U)this.convertList(outOps, input);
            }
            if (input == null || input instanceof NullObject) {
                return (U)outOps.empty();
            }
            if (input instanceof Enum) {
                return (U)outOps.createString(((Enum)input).name());
            }
            if (input instanceof Temporal) {
                return (U)outOps.createString(input.toString());
            }
            if (input instanceof String) {
                return (U)outOps.createString((String)input);
            }
            if (input instanceof Boolean) {
                return (U)outOps.createBoolean(((Boolean)input).booleanValue());
            }
            if (input instanceof Number) {
                return (U)outOps.createNumeric((Number)input);
            }
            throw new UnsupportedOperationException("TomlConfigOps was unable to convert toml value: " + String.valueOf(input));
        }

        public DataResult<Number> getNumberValue(Object input) {
            return input instanceof Number ? DataResult.success((Object)((Number)input)) : DataResult.error(() -> "Not a number: " + String.valueOf(input));
        }

        public boolean compressMaps() {
            return false;
        }

        public Object createNumeric(Number i) {
            return i;
        }

        public DataResult<String> getStringValue(Object input) {
            if (input instanceof Config || input instanceof Collection) {
                return DataResult.error(() -> "Not a string: " + String.valueOf(input));
            }
            return DataResult.success((Object)String.valueOf(input));
        }

        public Object createString(String value) {
            return value;
        }

        public DataResult<Object> mergeToList(Object list, Object value) {
            if (!(list instanceof Collection) && list != this.empty()) {
                return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            if (list != this.empty()) {
                Collection listAsCollection = (Collection)list;
                result.addAll(listAsCollection);
            }
            result.add(value);
            return DataResult.success(result);
        }

        public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
            if (!(map instanceof Config) && map != this.empty()) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
            }
            DataResult<String> stringResult = this.getStringValue(key);
            Optional badResult = stringResult.error();
            if (badResult.isPresent()) {
                return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
            }
            Optional result = stringResult.result();
            return stringResult.flatMap(s -> {
                CommentedConfig output = TomlFormat.newConfig();
                if (map != this.empty()) {
                    Config oldConfig = (Config)map;
                    output.addAll((UnmodifiableConfig)oldConfig);
                }
                output.add(s, value);
                return DataResult.success((Object)output);
            });
        }

        public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
            if (!(input instanceof Config)) {
                return DataResult.error(() -> "Not a Config: " + String.valueOf(input));
            }
            Config config = (Config)input;
            return DataResult.success(config.entrySet().stream().map(entry -> Pair.of((Object)entry.getKey(), (Object)entry.getValue())));
        }

        public Object createMap(Stream<Pair<Object, Object>> map) {
            CommentedConfig result = TomlFormat.newConfig();
            map.forEach(arg_0 -> this.lambda$createMap$9((Config)result, arg_0));
            return result;
        }

        public DataResult<Stream<Object>> getStream(Object input) {
            if (input instanceof Collection) {
                Collection collection = (Collection)input;
                return DataResult.success(collection.stream());
            }
            return DataResult.error(() -> "Not a collection: " + String.valueOf(input));
        }

        public Object createList(Stream<Object> input) {
            return input.collect(Collectors.toList());
        }

        public Object remove(Object input, String key) {
            if (input instanceof Config) {
                CommentedConfig result = TomlFormat.newConfig();
                Config oldConfig = (Config)input;
                oldConfig.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(arg_0 -> TomlConfigOps.lambda$remove$12((Config)result, arg_0));
                return result;
            }
            return input;
        }

        public String toString() {
            return "TOML";
        }

        public RecordBuilder<Object> mapBuilder() {
            return super.mapBuilder();
        }

        private static /* synthetic */ void lambda$remove$12(Config result, Config.Entry entry) {
            result.add(entry.getKey(), entry.getValue());
        }

        private /* synthetic */ void lambda$createMap$9(Config result, Pair p) {
            result.add((String)this.getStringValue(p.getFirst()).getOrThrow(false, s -> {}), p.getSecond());
        }

        class TomlRecordBuilder
        extends RecordBuilder.AbstractStringBuilder<Object, Config> {
            protected TomlRecordBuilder() {
                super((DynamicOps)TomlConfigOps.this);
            }

            protected Config initBuilder() {
                return TomlFormat.newConfig();
            }

            protected Config append(String key, Object value, Config builder) {
                builder.add(key, value);
                return builder;
            }

            protected DataResult<Object> build(Config builder, Object prefix) {
                if (prefix == null || prefix instanceof NullObject) {
                    return DataResult.success((Object)builder);
                }
                if (prefix instanceof Config) {
                    CommentedConfig result = TomlFormat.newConfig();
                    Config oldConfig = (Config)prefix;
                    for (Config.Entry entry : oldConfig.entrySet()) {
                        result.add(entry.getKey(), entry.getValue());
                    }
                    for (Config.Entry entry : builder.entrySet()) {
                        result.add(entry.getKey(), entry.getValue());
                    }
                    return DataResult.success((Object)result);
                }
                return DataResult.error(() -> "mergeToMap called with not a Config: " + String.valueOf(prefix), (Object)prefix);
            }
        }
    }

    public static class ConfigObjectListener<T>
    implements Supplier<T> {
        final ConfigValueListener<Object> listener;
        final Codec<T> codec;
        Object cachedObject;
        T parsedObject;
        T defaultObject;

        private ConfigObjectListener(ConfigValueListener<Object> listener, Codec<T> codec, T defaultObject, Object encodedDefaultObject) {
            this.listener = listener;
            this.codec = codec;
            this.defaultObject = defaultObject;
            this.parsedObject = defaultObject;
            this.cachedObject = encodedDefaultObject;
        }

        @Override
        public T get() {
            Object freshObject = this.listener.get();
            if (!Objects.equals(this.cachedObject, freshObject)) {
                this.cachedObject = freshObject;
                this.parsedObject = this.getReparsedObject(freshObject);
            }
            return this.parsedObject;
        }

        private T getReparsedObject(Object obj) {
            DataResult parseResult = this.codec.parse((DynamicOps)TomlConfigOps.INSTANCE, obj);
            return (T)parseResult.get().map(result -> result, failure -> {
                LOGGER.error("Config failure: Using default config value due to parsing error", (Object)failure.message());
                return this.defaultObject;
            });
        }
    }
}

