/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.config;

import com.sofodev.armorplus.config.ConfigHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class ArmorPlusConfig {
    public static MaterialConfig coalMaterial;
    public static MaterialConfig lapisMaterial;
    public static MaterialConfig redstoneMaterial;
    public static MaterialConfig chickenMaterial;
    public static MaterialConfig slimeMaterial;
    public static MaterialConfig emeraldMaterial;
    public static MaterialConfig obsidianMaterial;
    public static MaterialConfig infusedLavaMaterial;
    public static MaterialConfig frostMaterial;
    public static MaterialConfig frostLavaMaterial;
    public static AdvancedMaterialConfig guardianMaterial;
    public static AdvancedMaterialConfig superStarMaterial;
    public static AdvancedMaterialConfig enderDragonMaterial;
    public static AdvancedMaterialConfig slayerMaterial;
    public static MaterialConfig enhancedMaterial;
    public static ConfigHelper.ConfigValueListener<Boolean> enableThankYouAdvancement;
    public static ConfigHelper.ConfigValueListener<List<? extends String>> autoSmeltingInput;
    public static ConfigHelper.ConfigValueListener<List<? extends String>> autoSmeltingOutput;
    public static ConfigHelper.ConfigValueListener<List<? extends String>> enchantsThatWontWorkWithSoulHarden;
    public static BossDropConfig witherBossDrops;
    public static BossDropConfig enderDragonDrops;
    public static BossDropConfig elderGuardianDrops;
    public static DropConfig witherSkeletonDrops;
    public static DropConfig guardianDrops;
    public static DropConfig endermanDrops;
    public static DropConfig blazeDrops;

    public ArmorPlusConfig(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
        builder.comment("Configure advancements").push("advancements");
        enableThankYouAdvancement = subscriber.subscribe(builder.comment("Enable/Disable the Thank You 6M advancement").define("enableThankYou6M", true));
        builder.pop();
        builder.comment("Configure Items").push("items");
        coalMaterial = new MaterialConfig(builder, subscriber, "coal");
        lapisMaterial = new MaterialConfig(builder, subscriber, "lapis");
        redstoneMaterial = new MaterialConfig(builder, subscriber, "redstone");
        chickenMaterial = new MaterialConfig(builder, subscriber, "chicken");
        slimeMaterial = new MaterialConfig(builder, subscriber, "slime");
        emeraldMaterial = new MaterialConfig(builder, subscriber, "emerald");
        obsidianMaterial = new MaterialConfig(builder, subscriber, "obsidian");
        infusedLavaMaterial = new MaterialConfig(builder, subscriber, "infused_lava");
        builder.comment("Infused Lava Extra ").push("infused_lava.extra");
        autoSmeltingInput = subscriber.subscribe(builder.comment("Infused Lava Tools: Smelting Recipe Input (Blocks)").defineList("smeltingInput", Arrays.asList("minecraft:iron_ore", "minecraft:gold_ore", "minecraft:sand", "minecraft:sandstone", "minecraft:wet_sponge", "minecraft:clay", "minecraft:stone_bricks", "minecraft:cobblestone", "minecraft:stone", "minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:netherrack", "minecraft:ancient_debris", "minecraft:stone_bricks", "armorplus:ore_lava_crystal", "armorplus:ore_frost_crystal"), s -> ResourceLocation.m_135820_((String)((String)s)) != null));
        autoSmeltingOutput = subscriber.subscribe(builder.comment("Infused Lava Tools: Smelting Recipe Output (Items)").defineList("smeltingOutput", Arrays.asList("minecraft:iron_ingot", "minecraft:gold_ingot", "minecraft:glass", "minecraft:smooth_sandstone", "minecraft:sponge", "minecraft:terracotta", "minecraft:cracked_stone_bricks", "minecraft:stone", "minecraft:stone", "minecraft:charcoal", "minecraft:charcoal", "minecraft:charcoal", "minecraft:charcoal", "minecraft:charcoal", "minecraft:charcoal", "minecraft:nether_brick", "minecraft:netherite_scrap", "minecraft:cracked_stone_bricks", "armorplus:infused_lava_crystal", "armorplus:infused_frost_crystal"), s -> ResourceLocation.m_135820_((String)((String)s)) != null));
        builder.pop(2);
        frostMaterial = new MaterialConfig(builder, subscriber, "frost");
        frostLavaMaterial = new MaterialConfig(builder, subscriber, "frost_lava");
        guardianMaterial = new AdvancedMaterialConfig(builder, subscriber, "guardian", true, 0, true, 0, false, 0, false, 0, false, 0, true, 1, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, false, false, true);
        superStarMaterial = new AdvancedMaterialConfig(builder, subscriber, "super_star", false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, true, 0, false, 0, true, 0, false, 0, false, 0, false, 0, true, 0, false, 0, false, true, false, true);
        enderDragonMaterial = new AdvancedMaterialConfig(builder, subscriber, "ender_dragon", false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, true, 0, false, 0, false, 0, false, 0, false, 0, true, 0, true, true, false, true);
        slayerMaterial = new AdvancedMaterialConfig(builder, subscriber, "slayer", false, 0, true, 0, false, 0, false, 0, false, 0, true, 1, true, 0, false, 0, true, 0, false, 0, false, 0, false, 0, true, 0, true, 0, true, true, true, true);
        enhancedMaterial = new MaterialConfig(builder, subscriber, "enhanced");
        builder.pop();
        builder.comment("[REMOVED] - WORLD GEN - Is now handled by DATA PACKS!").push("world_gen");
        builder.pop();
        builder.comment("Enchantment Configuration").push("enchantments");
        enchantsThatWontWorkWithSoulHarden = subscriber.subscribe(builder.comment("is a list of registry names that will not work with the enchantment \"Soul Harden\"").defineList("disallowWithSoulHardenList", Arrays.asList("minecraft:mending", "minecraft:unbreaking", "minecraft:vanishing_curse"), s -> ResourceLocation.m_135820_((String)((String)s)) != null));
        builder.pop();
        builder.comment("Mob Drops Configuration").push("drops");
        witherBossDrops = new BossDropConfig(builder, subscriber, "wither_boss");
        enderDragonDrops = new BossDropConfig(builder, subscriber, "ender_dragon");
        elderGuardianDrops = new BossDropConfig(builder, subscriber, "elder_guardian");
        witherSkeletonDrops = new DropConfig(builder, subscriber, "wither_skeleton");
        guardianDrops = new DropConfig(builder, subscriber, "guardian");
        endermanDrops = new DropConfig(builder, subscriber, "enderman");
        blazeDrops = new DropConfig(builder, subscriber, "blaze");
        builder.pop();
    }

    public static class MaterialConfig {
        public ConfigHelper.ConfigValueListener<Boolean> enableArmorEffects;
        public ConfigHelper.ConfigValueListener<Boolean> enableWeaponEffects;

        public MaterialConfig(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber, String name) {
            builder.comment(name + " equipment Configuration").push(name);
            this.enableArmorEffects = subscriber.subscribe(builder.comment(name + " armor: enable/disable full set effects").define("enableArmorEffects", true));
            this.enableWeaponEffects = subscriber.subscribe(builder.comment(name + " weapons: enable/disable on hit effects").define("enableWeaponEffects", true));
            builder.pop();
        }
    }

    public static class AdvancedMaterialConfig
    extends MaterialConfig {
        public ConfigHelper.ConfigValueListener<Boolean> enableNIGHT_VISION;
        public ConfigHelper.ConfigValueListener<Integer> amplifierNIGHT_VISION;
        public ConfigHelper.ConfigValueListener<Boolean> enableWATER_BREATHING;
        public ConfigHelper.ConfigValueListener<Integer> amplifierWATER_BREATHING;
        public ConfigHelper.ConfigValueListener<Boolean> enableSTRENGTH;
        public ConfigHelper.ConfigValueListener<Integer> amplifierSTRENGTH;
        public ConfigHelper.ConfigValueListener<Boolean> enableSPEED;
        public ConfigHelper.ConfigValueListener<Integer> amplifierSPEED;
        public ConfigHelper.ConfigValueListener<Boolean> enableHASTE;
        public ConfigHelper.ConfigValueListener<Integer> amplifierHASTE;
        public ConfigHelper.ConfigValueListener<Boolean> enableJUMP_BOOST;
        public ConfigHelper.ConfigValueListener<Integer> amplifierJUMP_BOOST;
        public ConfigHelper.ConfigValueListener<Boolean> enableREGENERATION;
        public ConfigHelper.ConfigValueListener<Integer> amplifierREGENERATION;
        public ConfigHelper.ConfigValueListener<Boolean> enableRESISTANCE;
        public ConfigHelper.ConfigValueListener<Integer> amplifierRESISTANCE;
        public ConfigHelper.ConfigValueListener<Boolean> enableFIRE_RESISTANCE;
        public ConfigHelper.ConfigValueListener<Integer> amplifierFIRE_RESISTANCE;
        public ConfigHelper.ConfigValueListener<Boolean> enableSATURATION;
        public ConfigHelper.ConfigValueListener<Integer> amplifierSATURATION;
        public ConfigHelper.ConfigValueListener<Boolean> enableINVISIBILITY;
        public ConfigHelper.ConfigValueListener<Integer> amplifierINVISIBILITY;
        public ConfigHelper.ConfigValueListener<Boolean> enableHEALTH_BOOST;
        public ConfigHelper.ConfigValueListener<Integer> amplifierHEALTH_BOOST;
        public ConfigHelper.ConfigValueListener<Boolean> enableABSORPTION;
        public ConfigHelper.ConfigValueListener<Integer> amplifierABSORPTION;
        public ConfigHelper.ConfigValueListener<Boolean> enableSLOW_FALLING;
        public ConfigHelper.ConfigValueListener<Integer> amplifierSLOW_FALLING;
        public ConfigHelper.ConfigValueListener<Boolean> enableFLIGHT;
        public ConfigHelper.ConfigValueListener<Boolean> enableWITHER_IMMUNITY;
        public ConfigHelper.ConfigValueListener<Boolean> enableNATURAL_IMMUNITY;
        public ConfigHelper.ConfigValueListener<Boolean> enableFIRE_EXTINGUISH;

        public AdvancedMaterialConfig(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber, String name, boolean enableNightVision, int amplifierNightVision, boolean enableWaterBreathing, int amplifierWaterBreathing, boolean enableStrength, int amplifierStrength, boolean enableSpeed, int amplifierSpeed, boolean enableHaste, int amplifierHaste, boolean enableJumpBoost, int amplifierJumpBoost, boolean enableRegeneration, int amplifierRegeneration, boolean enableResistance, int amplifierResistance, boolean enableFireResistance, int amplifierFireResistance, boolean enableSaturation, int amplifierSaturation, boolean enableInvisibility, int amplifierInvisibility, boolean enableHealthBoost, int amplifierHealthBoost, boolean enableAbsorption, int amplifierAbsorption, boolean enableSlowFalling, int amplifierSlowFalling, boolean enableFlight, boolean enableWitherImmunity, boolean enableNaturalImmunity, boolean enableFireExtinguish) {
            super(builder, subscriber, name);
            builder.comment(name + " extended equipment Configuration").push(name).push("effects");
            this.enableNIGHT_VISION = subscriber.subscribe(builder.comment(name + " armor: enable/disable night vision").define("enableNIGHT_VISION", enableNightVision));
            this.amplifierNIGHT_VISION = subscriber.subscribe(builder.comment(name + " armor: night vision amplifier").define("amplifierNIGHT_VISION", (Object)amplifierNightVision));
            this.enableWATER_BREATHING = subscriber.subscribe(builder.comment(name + " armor: enable/disable water breathing").define("enableWATER_BREATHING", enableWaterBreathing));
            this.amplifierWATER_BREATHING = subscriber.subscribe(builder.comment(name + " armor: water breathing amplifier").define("amplifierWATER_BREATHING", (Object)amplifierWaterBreathing));
            this.enableSTRENGTH = subscriber.subscribe(builder.comment(name + " armor: enable/disable strength").define("enableSTRENGTH", enableStrength));
            this.amplifierSTRENGTH = subscriber.subscribe(builder.comment(name + " armor: strength amplifier").define("amplifierSTRENGTH", (Object)amplifierStrength));
            this.enableSPEED = subscriber.subscribe(builder.comment(name + " armor: enable/disable speed").define("enableSPEED", enableSpeed));
            this.amplifierSPEED = subscriber.subscribe(builder.comment(name + " armor: speed amplifier").define("amplifierSPEED", (Object)amplifierSpeed));
            this.enableHASTE = subscriber.subscribe(builder.comment(name + " armor: enable/disable haste").define("enableHASTE", enableHaste));
            this.amplifierHASTE = subscriber.subscribe(builder.comment(name + " armor: haste amplifier").define("amplifierHASTE", (Object)amplifierHaste));
            this.enableJUMP_BOOST = subscriber.subscribe(builder.comment(name + " armor: enable/disable jump boost").define("enableJUMP_BOOST", enableJumpBoost));
            this.amplifierJUMP_BOOST = subscriber.subscribe(builder.comment(name + " armor: jump boost amplifier").define("amplifierJUMP_BOOST", (Object)amplifierJumpBoost));
            this.enableREGENERATION = subscriber.subscribe(builder.comment(name + " armor: enable/disable regeneration").define("enableREGENERATION", enableRegeneration));
            this.amplifierREGENERATION = subscriber.subscribe(builder.comment(name + " armor: regeneration amplifier").define("amplifierREGENERATION", (Object)amplifierRegeneration));
            this.enableRESISTANCE = subscriber.subscribe(builder.comment(name + " armor: enable/disable resistance").define("enableRESISTANCE", enableResistance));
            this.amplifierRESISTANCE = subscriber.subscribe(builder.comment(name + " armor: resistance amplifier").define("amplifierRESISTANCE", (Object)amplifierResistance));
            this.enableFIRE_RESISTANCE = subscriber.subscribe(builder.comment(name + " armor: enable/disable fire resistance").define("enableFIRE_RESISTANCE", enableFireResistance));
            this.amplifierFIRE_RESISTANCE = subscriber.subscribe(builder.comment(name + " armor: fire resistance amplifier").define("amplifierFIRE_RESISTANCE", (Object)amplifierFireResistance));
            this.enableSATURATION = subscriber.subscribe(builder.comment(name + " armor: enable/disable saturation").define("enableSATURATION", enableSaturation));
            this.amplifierSATURATION = subscriber.subscribe(builder.comment(name + " armor: saturation amplifier").define("amplifierSATURATION", (Object)amplifierSaturation));
            this.enableINVISIBILITY = subscriber.subscribe(builder.comment(name + " armor: enable/disable invisibility").define("enableINVISIBILITY", enableInvisibility));
            this.amplifierINVISIBILITY = subscriber.subscribe(builder.comment(name + " armor: invisibility amplifier").define("amplifierINVISIBILITY", (Object)amplifierInvisibility));
            this.enableHEALTH_BOOST = subscriber.subscribe(builder.comment(name + " armor: enable/disable health boost").define("enableHEALTH_BOOST", enableHealthBoost));
            this.amplifierHEALTH_BOOST = subscriber.subscribe(builder.comment(name + " armor: health boost amplifier").define("amplifierHEALTH_BOOST", (Object)amplifierHealthBoost));
            this.enableABSORPTION = subscriber.subscribe(builder.comment(name + " armor: enable/disable absorption").define("enableABSORPTION", enableAbsorption));
            this.amplifierABSORPTION = subscriber.subscribe(builder.comment(name + " armor: absorption amplifier").define("amplifierABSORPTION", (Object)amplifierAbsorption));
            this.enableSLOW_FALLING = subscriber.subscribe(builder.comment(name + " armor: enable/disable slow falling").define("enableSLOW_FALLING", enableSlowFalling));
            this.amplifierSLOW_FALLING = subscriber.subscribe(builder.comment(name + " armor: slow falling amplifier").define("amplifierSLOW_FALLING", (Object)amplifierSlowFalling));
            this.enableFLIGHT = subscriber.subscribe(builder.comment(name + " armor: enable/disable flight").define("enableFLIGHT", enableFlight));
            this.enableWITHER_IMMUNITY = subscriber.subscribe(builder.comment(name + " armor: enable/disable wither immunity").define("enableWITHER_IMMUNITY", enableWitherImmunity));
            this.enableNATURAL_IMMUNITY = subscriber.subscribe(builder.comment(name + " armor: enable/disable natural immunity").define("enableNATURAL_IMMUNITY", enableNaturalImmunity));
            this.enableFIRE_EXTINGUISH = subscriber.subscribe(builder.comment(name + " armor: enable/disable fire extinguish").define("enableFIRE_EXTINGUISH", enableFireExtinguish));
            builder.pop().pop();
        }
    }

    public static class BossDropConfig {
        public ConfigHelper.ConfigValueListener<Boolean> enableTrophyDrops;
        public ConfigHelper.ConfigValueListener<Boolean> enableRegularDrops;
        public ConfigHelper.ConfigValueListener<Boolean> enableSoulDrops;

        public BossDropConfig(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber, String name) {
            builder.comment(name + " drop configuration").push(name);
            this.enableTrophyDrops = subscriber.subscribe(builder.comment("ArmorPlus's " + name + " trophy drops: enable/disable  (CURRENTLY DISABLED BY THE MOD)").define("enableTrophyDrops", false));
            this.enableRegularDrops = subscriber.subscribe(builder.comment("ArmorPlus's " + name + " regular drops: enable/disable").define("enableBossRegularDrops", true));
            this.enableSoulDrops = subscriber.subscribe(builder.comment("ArmorPlus's " + name + " soul drops: enable/disable").define("enableBossSoulDrops", true));
            builder.pop();
        }
    }

    public static class DropConfig {
        public ConfigHelper.ConfigValueListener<Boolean> enableRegularDrops;
        public ConfigHelper.ConfigValueListener<Boolean> enableSoulDrops;

        public DropConfig(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber, String name) {
            builder.comment(name + " drop configuration").push(name);
            this.enableRegularDrops = subscriber.subscribe(builder.comment("ArmorPlus's " + name + " regular drops: enable/disable").define("enableRegularDrops", true));
            this.enableSoulDrops = subscriber.subscribe(builder.comment("ArmorPlus's " + name + " soul drops: enable/disable").define("enableSoulDrops", true));
            builder.pop();
        }
    }
}

