/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.platform;

import io.github.flemmli97.tenshilib.TenshiLib;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class InitUtil {
    public static <T> T getPlatformInstance(Class<T> abstractClss, String ... impls) {
        if (impls == null || impls.length == 0) {
            throw new IllegalStateException("Couldn't create an instance of " + abstractClss + ". No implementations provided!");
        }
        Class<?> clss = null;
        for (int i = 0; clss == null && i < impls.length; ++i) {
            try {
                clss = Class.forName(impls[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clss == null) {
            TenshiLib.LOGGER.fatal("No Implementation of " + abstractClss + " found with given paths " + Arrays.toString(impls));
        } else if (abstractClss.isAssignableFrom(clss)) {
            try {
                Constructor<?> constructor = clss.getDeclaredConstructor(new Class[0]);
                return (T)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                TenshiLib.LOGGER.fatal("Implementation of " + clss + " needs to provide an no arg constructor");
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalStateException("Couldn't create an instance of " + abstractClss);
    }
}

