/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.tenshilib.client.model.IItemArmModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ItemLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;

    public ItemLayer(RenderLayerParent<T, M> renderer, ItemInHandRenderer itemInHandRenderer) {
        super(renderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag = entity.m_5737_() == HumanoidArm.RIGHT;
        ItemStack leftStack = this.heldItemLeft(entity, flag);
        ItemStack rightStack = this.heldItemRight(entity, flag);
        if (!leftStack.m_41619_() || !rightStack.m_41619_()) {
            stack.m_85836_();
            if (this.m_117386_().f_102610_) {
                ((IItemArmModel)this.m_117386_()).childTransform(stack);
            }
            this.renderItem(entity, rightStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, stack, buffer, light);
            this.renderItem(entity, leftStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, stack, buffer, light);
            stack.m_85849_();
        }
    }

    protected ItemStack heldItemLeft(T entity, boolean rightHanded) {
        return rightHanded ? entity.m_21206_() : entity.m_21205_();
    }

    protected ItemStack heldItemRight(T entity, boolean rightHanded) {
        return rightHanded ? entity.m_21205_() : entity.m_21206_();
    }

    protected void renderItem(T entity, ItemStack stack, ItemDisplayContext displayContext, HumanoidArm hand, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        if (!stack.m_41619_()) {
            matrixStack.m_85836_();
            ((IItemArmModel)this.m_117386_()).transform(hand, matrixStack);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            boolean flag = hand == HumanoidArm.LEFT;
            ((IItemArmModel)this.m_117386_()).postTransform(flag, matrixStack);
            this.itemInHandRenderer.m_269530_(entity, stack, displayContext, flag, matrixStack, buffer, light);
            matrixStack.m_85849_();
        }
    }
}

