/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.client.model.AnimationValue;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.SimpleAnimationExpression;
import io.github.flemmli97.tenshilib.common.utils.ArrayUtils;
import io.github.flemmli97.tenshilib.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.Mth;

public class BlockBenchAnimations {
    private final Map<String, Animation> animations = new HashMap<String, Animation>();

    public void reload(JsonObject obj) {
        this.animations.clear();
        if (obj.has("animations")) {
            for (Map.Entry anims : obj.getAsJsonObject("animations").entrySet()) {
                if (!(anims.getValue() instanceof JsonObject)) continue;
                this.animations.put((String)anims.getKey(), new Animation((JsonObject)anims.getValue()));
            }
        }
    }

    public void doAnimation(ExtendedModel model, String name, int ticker, float partialTicks) {
        this.doAnimation(model, name, ticker, partialTicks, 1.0f);
    }

    public void doAnimation(ExtendedModel model, String name, int ticker, float partialTicks, float interpolation) {
        this.doAnimation(model, name, ticker, partialTicks, interpolation, false);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks) {
        return this.doAnimation(model, handler, partialTicks, 3.0f, false);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks, float adjustTime, boolean mirror) {
        AnimatedAction current = handler.getAnimation();
        AnimatedAction last = handler.getLastAnim();
        float interpolation = handler.getInterpolatedAnimationVal(partialTicks, adjustTime);
        float interpolationRev = 1.0f - interpolation;
        boolean changed = false;
        if (last != null && interpolationRev > 0.0f) {
            changed = this.doAnimation(model, last.getAnimationClient(), last.getTick(), partialTicks, current != null ? 1.0f : interpolationRev, mirror, InterpolationCheck.END, false);
        }
        if (current != null) {
            changed = this.doAnimation(model, current.getAnimationClient(), current.getTick(), partialTicks, interpolation, mirror, InterpolationCheck.START, changed);
        }
        return changed;
    }

    public boolean doAnimation(ExtendedModel model, String name, int ticker, float partialTicks, float interpolation, boolean mirror) {
        return this.doAnimation(model, name, ticker, partialTicks, interpolation, mirror, InterpolationCheck.NONE, false);
    }

    public boolean doAnimation(ExtendedModel model, String name, int ticker, float partialTicks, float interpolation, boolean mirror, InterpolationCheck check, boolean interpolateFromCurrent) {
        Animation animation = this.animations.get(name);
        if (animation != null && interpolation != 0.0f) {
            if (check == InterpolationCheck.END && animation.endsDefault) {
                return false;
            }
            if (check == InterpolationCheck.START && animation.startsDefault) {
                interpolation = 1.0f;
            }
            animation.animate(model, ticker, partialTicks, Mth.m_14036_((float)interpolation, (float)0.0f, (float)1.0f), mirror, interpolateFromCurrent);
            return true;
        }
        return false;
    }

    public float animationLength(String name) {
        Animation animation = this.animations.get(name);
        return animation != null ? animation.length : 0.0f;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Animation: ");
        this.animations.forEach((key, anim) -> builder.append(String.format("\n%s = %s", key, anim)));
        return builder.toString();
    }

    public static class Animation {
        public final float length;
        public final boolean loop;
        private boolean startsDefault = true;
        private boolean endsDefault = true;
        private final List<AnimationComponent> components = new ArrayList<AnimationComponent>();

        public Animation(JsonObject json) {
            this.length = (float)(JsonUtils.get(json, "animation_length", 0.0) * 20.0);
            this.loop = JsonUtils.get(json, "loop", false);
            JsonObject components = JsonUtils.getObj(json, "bones");
            components.entrySet().forEach(e -> {
                AnimationComponent component = new AnimationComponent((String)e.getKey(), this.length, ((JsonElement)e.getValue()).getAsJsonObject());
                this.components.add(component);
                if (this.startsDefault) {
                    this.startsDefault = component.isDefaultPose(true, 0.0f);
                }
                if (this.endsDefault) {
                    this.endsDefault = component.isDefaultPose(false, this.length);
                }
            });
        }

        public void animate(ExtendedModel model, int ticker, float partialTicks, float interpolation, boolean mirror, boolean interpolateFromCurrent) {
            float actualTick = Math.max((float)(ticker - 1) + partialTicks, 0.0f);
            if (this.loop) {
                actualTick %= this.length;
            }
            for (AnimationComponent comp : this.components) {
                comp.animate(model, actualTick, interpolation, mirror, interpolateFromCurrent);
            }
        }

        public String toString() {
            return String.format("\nloop: %b, length: %s, components: %s", this.loop, Float.valueOf(this.length), this.components);
        }
    }

    public static enum InterpolationCheck {
        NONE,
        START,
        END;

    }

    public static class AnimationComponent {
        private final String name;
        private final String mirroredName;
        private AnimationValue[] rotations;
        private AnimationValue[] positions;
        private AnimationValue[] scales;

        public AnimationComponent(String name, float length, JsonObject obj) {
            JsonArray arr2;
            Object v;
            this.name = name;
            this.mirroredName = name.toLowerCase(Locale.ROOT).contains("right") ? name.replace("Right", "Left").replace("right", "left") : name.replace("Left", "Right").replace("left", "right");
            int i = 0;
            if (obj.has("position")) {
                JsonObject position = this.tryGet(obj, "position");
                this.positions = new AnimationValue[position.size()];
                for (Map.Entry e : position.entrySet()) {
                    v = e.getValue();
                    if (!(v instanceof JsonArray)) continue;
                    arr2 = (JsonArray)v;
                    this.positions[i] = new AnimationValue(Float.parseFloat((String)e.getKey()) * 20.0f, SimpleAnimationExpression.of(arr2.get(0).getAsString()), SimpleAnimationExpression.of(arr2.get(1).getAsString()), SimpleAnimationExpression.of(arr2.get(2).getAsString()));
                    ++i;
                }
                Arrays.sort(this.positions, Comparator.comparingDouble(arr -> arr.startTick));
            }
            if (obj.has("rotation")) {
                JsonObject rotation = this.tryGet(obj, "rotation");
                this.rotations = new AnimationValue[rotation.size()];
                i = 0;
                for (Map.Entry e : rotation.entrySet()) {
                    v = e.getValue();
                    if (!(v instanceof JsonArray)) continue;
                    arr2 = (JsonArray)v;
                    this.rotations[i] = new AnimationValue(Float.parseFloat((String)e.getKey()) * 20.0f, SimpleAnimationExpression.of(arr2.get(0).getAsString()), SimpleAnimationExpression.of(arr2.get(1).getAsString()), SimpleAnimationExpression.of(arr2.get(2).getAsString()));
                    ++i;
                }
                Arrays.sort(this.rotations, Comparator.comparingDouble(arr -> arr.startTick));
            }
            if (obj.has("scale")) {
                JsonObject scale = this.tryGet(obj, "scale");
                this.scales = new AnimationValue[scale.size()];
                i = 0;
                for (Map.Entry e : scale.entrySet()) {
                    v = e.getValue();
                    if (!(v instanceof JsonArray)) continue;
                    arr2 = (JsonArray)v;
                    this.scales[i] = new AnimationValue(Float.parseFloat((String)e.getKey()) * 20.0f, SimpleAnimationExpression.of(arr2.get(0).getAsString()), SimpleAnimationExpression.of(arr2.get(1).getAsString()), SimpleAnimationExpression.of(arr2.get(2).getAsString()));
                    ++i;
                }
                Arrays.sort(this.scales, Comparator.comparingDouble(arr -> arr.startTick));
            }
        }

        private boolean isDefaultPose(boolean start, float time) {
            if (!start) {
                return !(this.positions != null && this.positions.length != 0 && !this.isZero(this.positions[this.positions.length - 1], time) || this.rotations != null && this.rotations.length != 0 && !this.isZero(this.rotations[this.rotations.length - 1], time) || this.scales != null && this.scales.length != 0 && !this.isZero(this.scales[this.scales.length - 1], time));
            }
            return !(this.positions != null && this.positions.length != 0 && !this.isZero(this.positions[0], time) || this.rotations != null && this.rotations.length != 0 && !this.isZero(this.rotations[0], time) || this.scales != null && this.scales.length != 0 && !this.isZero(this.scales[0], time));
        }

        private boolean isZero(AnimationValue value, float time) {
            return value.getXVal(time) == 0.0f && value.getYVal(time) == 0.0f && value.getZVal(time) == 0.0f;
        }

        private JsonObject tryGet(JsonObject obj, String name) {
            JsonElement el = obj.get(name);
            if (el.isJsonObject()) {
                return (JsonObject)el;
            }
            if (el.isJsonArray()) {
                JsonObject val = new JsonObject();
                val.add("0", el);
                return val;
            }
            if (el.isJsonPrimitive()) {
                JsonObject val = new JsonObject();
                JsonArray arr = new JsonArray();
                arr.add((Number)el.getAsDouble());
                arr.add((Number)el.getAsDouble());
                arr.add((Number)el.getAsDouble());
                val.add("0", (JsonElement)arr);
                return val;
            }
            return null;
        }

        public void animate(ExtendedModel model, float actualTick, float interpolation, boolean mirror, boolean interpolateFromCurrent) {
            float z;
            float y;
            float x;
            float prog;
            int id;
            ModelPartHandler.ModelPartExtended mirrored;
            ModelPartHandler.ModelPartExtended modelPart = model.getHandler().getPartNullable(this.name);
            if (mirror && (mirrored = model.getHandler().getPartNullable(this.mirroredName)) != null) {
                modelPart = mirrored;
            }
            if (modelPart == null) {
                return;
            }
            float secTime = actualTick * 0.05f;
            float mirrorMult = mirror ? -1 : 1;
            if (this.positions != null) {
                if (this.positions.length == 1) {
                    modelPart.x += this.positions[0].getXVal(secTime) * interpolation * mirrorMult;
                    modelPart.y -= this.positions[0].getYVal(secTime) * interpolation;
                    modelPart.z += this.positions[0].getZVal(secTime) * interpolation;
                } else {
                    id = 1;
                    AnimationValue pos = this.positions[id];
                    while (pos.startTick < actualTick && ++id < this.positions.length) {
                        pos = this.positions[id];
                    }
                    AnimationValue posPrev = this.positions[id - 1];
                    prog = Mth.m_14036_((float)((actualTick - posPrev.startTick) / (pos.startTick - posPrev.startTick)), (float)0.0f, (float)1.0f);
                    modelPart.x += this.interpolate(posPrev.getXVal(secTime), pos.getXVal(secTime), prog) * interpolation * mirrorMult;
                    modelPart.y -= this.interpolate(posPrev.getYVal(secTime), pos.getYVal(secTime), prog) * interpolation;
                    modelPart.z += this.interpolate(posPrev.getZVal(secTime), pos.getZVal(secTime), prog) * interpolation;
                }
            }
            if (this.rotations != null) {
                if (this.rotations.length == 1) {
                    modelPart.xRot += (float)Math.PI / 180 * (this.rotations[0].getXVal(secTime) % 360.0f) * interpolation;
                    modelPart.yRot += (float)Math.PI / 180 * (this.rotations[0].getYVal(secTime) % 360.0f) * interpolation * mirrorMult;
                    modelPart.zRot += (float)Math.PI / 180 * (this.rotations[0].getZVal(secTime) % 360.0f) * interpolation * mirrorMult;
                } else {
                    id = 1;
                    AnimationValue rot = this.rotations[id];
                    while (rot.startTick < actualTick && ++id < this.rotations.length) {
                        rot = this.rotations[id];
                    }
                    AnimationValue rotPrev = this.rotations[id - 1];
                    prog = Mth.m_14036_((float)((actualTick - rotPrev.startTick) / (rot.startTick - rotPrev.startTick)), (float)0.0f, (float)1.0f);
                    x = this.interpolate(rotPrev.getXVal(secTime), rot.getXVal(secTime), prog) % 360.0f;
                    y = this.interpolate(rotPrev.getYVal(secTime), rot.getYVal(secTime), prog) % 360.0f * mirrorMult;
                    z = this.interpolate(rotPrev.getZVal(secTime), rot.getZVal(secTime), prog) % 360.0f * mirrorMult;
                    if (interpolateFromCurrent) {
                        modelPart.xRot += (float)Math.PI / 180 * this.smallestDegDiff(x, modelPart.xRot) * interpolation;
                        modelPart.yRot += (float)Math.PI / 180 * this.smallestDegDiff(y, modelPart.yRot) * interpolation;
                        modelPart.zRot += (float)Math.PI / 180 * this.smallestDegDiff(z, modelPart.zRot) * interpolation;
                    } else {
                        modelPart.xRot += (float)Math.PI / 180 * x * interpolation;
                        modelPart.yRot += (float)Math.PI / 180 * y * interpolation;
                        modelPart.zRot += (float)Math.PI / 180 * z * interpolation;
                    }
                }
            }
            if (this.scales != null) {
                if (this.scales.length == 1) {
                    float x2 = this.scales[0].getXVal(secTime) - 1.0f;
                    float y2 = this.scales[0].getYVal(secTime) - 1.0f;
                    float z2 = this.scales[0].getZVal(secTime) - 1.0f;
                    if (interpolateFromCurrent) {
                        modelPart.xScale += (x2 - modelPart.xScale) * interpolation;
                        modelPart.yScale += (y2 - modelPart.yScale) * interpolation;
                        modelPart.zScale += (z2 - modelPart.zScale) * interpolation;
                    } else {
                        modelPart.xScale += x2 * interpolation;
                        modelPart.yScale += y2 * interpolation;
                        modelPart.zScale += z2 * interpolation;
                    }
                } else {
                    id = 1;
                    AnimationValue scale = this.scales[id];
                    while (scale.startTick < actualTick && ++id < this.scales.length) {
                        scale = this.scales[id];
                    }
                    AnimationValue scalePrev = this.scales[id - 1];
                    prog = Mth.m_14036_((float)((actualTick - scalePrev.startTick) / (scale.startTick - scalePrev.startTick)), (float)0.0f, (float)1.0f);
                    x = this.interpolate(scalePrev.getXVal(secTime) - 1.0f, scale.getXVal(secTime) - 1.0f, prog);
                    y = this.interpolate(scalePrev.getYVal(secTime) - 1.0f, scale.getYVal(secTime) - 1.0f, prog);
                    z = this.interpolate(scalePrev.getZVal(secTime) - 1.0f, scale.getZVal(secTime) - 1.0f, prog);
                    if (interpolateFromCurrent) {
                        modelPart.xScale += (x - modelPart.xScale) * interpolation;
                        modelPart.yScale += (y - modelPart.yScale) * interpolation;
                        modelPart.zScale += (z - modelPart.zScale) * interpolation;
                    } else {
                        modelPart.xScale += x * interpolation;
                        modelPart.yScale += y * interpolation;
                        modelPart.zScale += z * interpolation;
                    }
                }
            }
        }

        private float smallestDegDiff(float first, float sec) {
            sec = 57.295776f * sec % 360.0f;
            float diff1 = first - sec;
            float diff2 = sec - first;
            return Math.abs(diff1) > Math.abs(diff2) ? diff2 : diff1;
        }

        private float interpolate(float start, float end, float progress) {
            return start + (end - start) * progress;
        }

        public String toString() {
            return String.format("%s rot: {%s}; pos: {%s}; scale: {%s}", this.name, ArrayUtils.arrayToString(this.rotations), ArrayUtils.arrayToString(this.positions), ArrayUtils.arrayToString(this.scales));
        }
    }
}

