/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.api.config.IItemConfig;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemWrapper
implements IItemConfig<ItemWrapper> {
    protected Item item;
    protected String reg;

    public ItemWrapper(String s) {
        this.reg = s;
    }

    @Override
    public Item getItem() {
        if (this.item == null) {
            if (this.reg == null || this.reg.isEmpty()) {
                this.item = Items.f_41852_;
                return this.item;
            }
            this.item = PlatformUtils.INSTANCE.items().getFromId(new ResourceLocation(this.reg));
            if (this.item == Items.f_41852_ && (this.reg.isEmpty() || !this.reg.equals("minecraft:air"))) {
                TenshiLib.LOGGER.error("Faulty item registry name {}", (Object)this.reg);
            }
        }
        return this.item;
    }

    @Override
    public ItemStack getStack() {
        return this.getItem() == Items.f_41852_ ? ItemStack.f_41583_ : new ItemStack((ItemLike)this.getItem());
    }

    @Override
    public List<Item> getItemList() {
        return null;
    }

    @Override
    public boolean hasList() {
        return false;
    }

    @Override
    public boolean match(ItemStack stack) {
        return stack.m_41720_() == this.getItem();
    }

    @Override
    public ItemWrapper readFromString(String s) {
        this.reg = s;
        this.item = null;
        return this;
    }

    @Override
    public String writeToString() {
        return this.reg;
    }

    public static String usage() {
        return "Valid values are all item registry names. Empty or minecraft:air for nothing";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemWrapper) {
            ItemWrapper prop = (ItemWrapper)obj;
            return prop.writeToString().equals(this.writeToString());
        }
        return false;
    }

    public int hashCode() {
        return this.writeToString().hashCode();
    }

    public String toString() {
        return this.writeToString();
    }

    public static class Serializer
    implements JsonDeserializer<ItemWrapper>,
    JsonSerializer<ItemWrapper> {
        public JsonElement serialize(ItemWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            return obj;
        }

        public ItemWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new ItemWrapper(json.getAsJsonObject().get("item").getAsString());
        }
    }
}

