/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StorageStabilizerBlock
extends Block {
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.EAST, (Object)Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 0.3, 1.0, 1.0))).put((Object)Direction.WEST, (Object)Shapes.m_83064_((AABB)new AABB(0.7, 0.0, 0.0, 1.0, 1.0, 1.0))).put((Object)Direction.NORTH, (Object)Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.7, 1.0, 1.0, 1.0))).put((Object)Direction.SOUTH, (Object)Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.3))).put((Object)Direction.UP, (Object)Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0))).put((Object)Direction.DOWN, (Object)Shapes.m_83064_((AABB)new AABB(0.0, 0.7, 0.0, 1.0, 1.0, 1.0))).build());

    public StorageStabilizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return super.m_7357_(pState, pLevel, pPos, pType);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState) {
            this.notifyStorageControllers(level, pos, state);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)BlockStateProperties.f_61372_));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_());
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.notifyStorageControllers(level, pos, state);
        super.m_6402_(level, pos, state, placer, stack);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
        super.m_7926_(builder);
    }

    public void notifyStorageControllers(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        BlockPos min = facing != Direction.DOWN && facing != Direction.UP ? pos.m_7495_() : pos;
        List<BlockPos> blocks = Math3DUtil.simpleTrace(min, facing, 5);
        for (BlockPos block : blocks) {
            BlockEntity blockEntity = level.m_7702_(block);
            if (!(blockEntity instanceof StorageControllerBlockEntity)) continue;
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)blockEntity;
            controller.updateStabilizers();
        }
    }
}

