/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block.otherworld;

import com.klikli_dev.occultism.api.common.data.OtherworldBlockTier;
import com.klikli_dev.occultism.api.common.item.IOtherworldTool;
import com.klikli_dev.occultism.registry.OccultismEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface IOtherworldBlock {
    public static final Property<Boolean> UNCOVERED = BooleanProperty.m_61465_((String)"uncovered");

    public Block getUncoveredBlock();

    public Block getCoveredBlock();

    public OtherworldBlockTier getTier();

    default public OtherworldBlockTier getPlayerHarvestTier(Player player, ItemStack tool) {
        OtherworldBlockTier effectTier;
        OtherworldBlockTier toolTier = OtherworldBlockTier.NONE;
        OtherworldBlockTier otherworldBlockTier = effectTier = player.m_21023_((MobEffect)OccultismEffects.THIRD_EYE.get()) ? OtherworldBlockTier.ONE : OtherworldBlockTier.NONE;
        if (tool.m_41720_() instanceof IOtherworldTool) {
            toolTier = ((IOtherworldTool)tool.m_41720_()).getHarvestTier(tool);
        }
        if (tool.m_41782_() && tool.m_41783_().m_128441_("occultism:otherworldToolTier")) {
            toolTier = OtherworldBlockTier.get(tool.m_41783_().m_128451_("occultism:otherworldToolTier"));
        }
        return OtherworldBlockTier.max(toolTier, effectTier);
    }

    default public BlockState getHarvestState(Player player, BlockState state, ItemStack tool) {
        return this.getPlayerHarvestTier(player, tool).getLevel() >= this.getTier().getLevel() ? (BlockState)state.m_61124_(UNCOVERED, (Comparable)Boolean.valueOf(true)) : state;
    }

    default public ItemStack getItem(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)((Boolean)state.m_61143_(UNCOVERED) != false ? this.getUncoveredBlock() : this.getCoveredBlock()), 1);
    }
}

