/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.puffish.castlemod.generator.CastleLayer;
import net.puffish.castlemod.generator.CastleLayerMetrics;
import net.puffish.castlemod.generator.CastleMetrics;
import net.puffish.castlemod.generator.CastleNode;
import net.puffish.castlemod.generator.CastleNodeType;
import net.puffish.castlemod.generator.CastleRoom;
import net.puffish.castlemod.generator.CastleRoomDoors;
import net.puffish.castlemod.generator.CastleRoomTemplate;
import net.puffish.castlemod.generator.CastleTemplate;
import net.puffish.castlemod.generator.ConnectionState;
import net.puffish.castlemod.generator.RoomCandidate;
import net.puffish.castlemod.generator.RoomCounter;
import net.puffish.castlemod.generator.RoomDoor;
import net.puffish.castlemod.generator.RoomPlacement;
import net.puffish.castlemod.util.Direction4XZ;
import net.puffish.castlemod.util.Direction8XZ;
import net.puffish.castlemod.util.GridXZ;
import net.puffish.castlemod.util.MirrorXZ;
import net.puffish.castlemod.util.PositionXYZ;
import net.puffish.castlemod.util.PositionXZ;
import net.puffish.castlemod.util.Rotation4XZ;
import net.puffish.castlemod.util.Util;

public class Castle {
    private final CastleMetrics metrics;
    private final List<CastleLayer> layers = new ArrayList<CastleLayer>();
    private final List<CastleRoom> rooms = new ArrayList<CastleRoom>();
    private final GridXZ<Boolean> towers;

    public Castle(int sizeX, int sizeZ) {
        this.metrics = new CastleMetrics(sizeX, sizeZ);
        this.towers = new GridXZ<Boolean>(sizeX, sizeZ, () -> false);
    }

    public static Optional<Castle> generate(CastleTemplate template, Random random) {
        if (template.sizeX() < 1 || template.sizeZ() < 1) {
            return Optional.empty();
        }
        Castle castle = new Castle(template.sizeX(), template.sizeZ());
        castle.generate(template.castleRoomTemplates(), random);
        return Optional.of(castle);
    }

    private void generate(List<? extends CastleRoomTemplate> castleRoomTemplates, Random random) {
        this.generateLayers(random);
        this.placeRequiredTower(random);
        this.placeTowersRandomly(random);
        for (int i = 1; i < this.layers.size(); ++i) {
            this.layers.get(i).placeMissingStairs(this.layers.get(i - 1), random);
        }
        for (CastleLayer layer : this.layers) {
            layer.fixOutside();
        }
        this.layers.get(0).placeEntrance(random);
        for (CastleLayer layer : this.layers) {
            layer.fixConnections();
        }
        for (int i = 1; i < this.layers.size(); ++i) {
            this.layers.get(i).generateWalkEntrances(this.layers.get(i - 1), random);
        }
        this.placeRoomsRandomly(castleRoomTemplates, random);
        for (CastleLayer layer : this.layers) {
            layer.generateMaze(random);
        }
        for (CastleRoom room : this.rooms) {
            this.placeDoors(new RoomPlacement(room.getPosition(), room.getMirror(), room.getRotation(), room.getRoomTemplate()));
        }
    }

    private void generateLayers(Random random) {
        boolean stop;
        CastleLayer belowLayer = new CastleLayer(this.metrics);
        belowLayer.fillHallway();
        this.layers.add(belowLayer);
        do {
            CastleLayer layer = belowLayer.nextFloor();
            layer.fillHallway();
            stop = false;
            if (this.layers.size() >= 3) {
                int count = Math.max(1, (int)Math.floor(Math.sqrt(layer.getMetrics().getCutSizeX() * layer.getMetrics().getCutSizeZ()) / 2.0));
                for (int i = 0; i < count; ++i) {
                    if (layer.tryCut(random)) continue;
                    stop = true;
                    break;
                }
            }
            if (stop && this.layers.size() == 3) {
                this.forcePlaceTower(layer, random);
            }
            this.layers.add(layer);
            belowLayer = layer;
        } while (!stop);
        belowLayer.fillWalk();
    }

    private Stream<PositionXZ> streamPossibleTowerPositions() {
        return this.layers.stream().filter(layer -> !layer.getMetrics().isSmall()).flatMap(CastleLayer::streamPossibleTowerPositions);
    }

    private void placeRequiredTower(Random random) {
        CastleLayer layer = this.layers.get(this.layers.size() - 1);
        CastleLayerMetrics layerMetrics = layer.getMetrics();
        List<PositionXZ> candidates = this.streamPossibleTowerPositions().filter(layerMetrics::isAdjacentToCutBoundsEdges).toList();
        if (candidates.isEmpty()) {
            this.forcePlaceTower(layer, random);
        } else {
            this.buildTower(candidates.get(random.nextInt(candidates.size())));
        }
    }

    private void placeTowersRandomly(Random random) {
        List candidates = this.streamPossibleTowerPositions().collect(Collectors.toList());
        Collections.shuffle(candidates, random);
        for (PositionXZ pos : candidates) {
            if (!this.canPlaceTower(pos)) continue;
            this.buildTower(pos);
        }
    }

    private boolean canPlaceTower(PositionXZ pos) {
        return Arrays.stream(Direction8XZ.values()).map(dir -> dir.toPos().add(pos)).filter(Predicate.not(this.metrics::isOutsideBounds)).noneMatch(this.towers::get);
    }

    private void forcePlaceTower(CastleLayer layer, Random random) {
        PositionXZ pos = Util.pickRandom(layer.getMetrics().streamPositionsInCutBounds().toList(), random).orElseThrow();
        layer.placeTower(pos);
        this.buildTower(pos);
    }

    private void buildTower(PositionXZ pos) {
        CastleNodeType nodeType;
        int y;
        this.towers.set(pos, true);
        for (y = 0; y < this.layers.size() && (nodeType = this.layers.get(y).getNode(pos).getType()) == CastleNodeType.HALLWAY; ++y) {
        }
        while (true) {
            if (y >= this.layers.size()) {
                this.layers.add(this.layers.get(this.layers.size() - 1).nextFloor());
            }
            CastleLayer layer = this.layers.get(y);
            ++y;
            if (layer.tryPlaceRoof(pos)) break;
            layer.placeTower(pos);
        }
    }

    private void placeRoomsRandomly(List<? extends CastleRoomTemplate> roomTemplates, Random random) {
        RoomPlacement placement;
        ArrayList<RoomCandidate> candidates = new ArrayList<RoomCandidate>();
        List<RoomCounter> roomCounters = roomTemplates.stream().map(RoomCounter::new).toList();
        this.metrics.streamPositionsInBounds().forEach(pos -> {
            for (int y = 0; y < this.layers.size(); ++y) {
                for (Rotation4XZ rotation : Rotation4XZ.values()) {
                    for (MirrorXZ mirror : List.of(MirrorXZ.NONE, MirrorXZ.ALONG_X)) {
                        for (RoomCounter roomCounter : roomCounters) {
                            RoomPlacement roomPlacement = new RoomPlacement(pos.withY(y), mirror, rotation, roomCounter.getRoomTemplate());
                            if (!this.verifyPlacement(roomPlacement)) continue;
                            candidates.add(new RoomCandidate(roomPlacement, roomCounter, Math.pow(random.nextDouble(), 1.0 / (double)roomCounter.getRoomTemplate().getWeight())));
                        }
                    }
                }
            }
        });
        Collections.shuffle(candidates, random);
        candidates.sort(Comparator.comparingDouble(RoomCandidate::weight).reversed());
        for (RoomCandidate candidate : candidates) {
            placement = candidate.placement();
            if (candidate.counter().getCount() >= placement.roomTemplate().getMinCount() || !this.tryPlaceRoom(placement)) continue;
            candidate.counter().increment();
            this.rooms.add(new CastleRoom(placement.position(), placement.mirror(), placement.rotation(), placement.roomTemplate()));
        }
        for (RoomCandidate candidate : candidates) {
            placement = candidate.placement();
            if (candidate.counter().getCount() >= placement.roomTemplate().getMaxCount() || !this.tryPlaceRoom(placement)) continue;
            candidate.counter().increment();
            this.rooms.add(new CastleRoom(placement.position(), placement.mirror(), placement.rotation(), placement.roomTemplate()));
        }
    }

    private boolean verifyPlacement(RoomPlacement placement) {
        CastleRoomTemplate roomTemplate = placement.roomTemplate();
        int roomSizeX = placement.getRotatedSizeX();
        int roomSizeZ = placement.getRotatedSizeZ();
        if (placement.position().getX() + roomSizeX > this.metrics.getSizeX()) {
            return false;
        }
        if (placement.position().getY() + roomTemplate.getSizeY() > this.layers.size()) {
            return false;
        }
        if (placement.position().getZ() + roomSizeZ > this.metrics.getSizeZ()) {
            return false;
        }
        if (placement.position().getY() >= 1) {
            CastleLayer belowLayer = this.layers.get(placement.position().getY() - 1);
            boolean collision = this.metrics.streamPositionsInCustomBounds(placement.position().getX(), placement.position().getX() + roomSizeX, placement.position().getZ(), placement.position().getZ() + roomSizeZ).anyMatch(pos -> {
                CastleNode belowNode = belowLayer.getNode((PositionXZ)pos);
                return belowNode.hasStairs();
            });
            if (collision) {
                return false;
            }
        }
        for (int y = placement.position().getY(); y < placement.position().getY() + placement.roomTemplate().getSizeY(); ++y) {
            CastleLayer layer = this.layers.get(y);
            boolean collision = this.metrics.streamPositionsInCustomBounds(placement.position().getX(), placement.position().getX() + roomSizeX, placement.position().getZ(), placement.position().getZ() + roomSizeZ).anyMatch(pos -> {
                CastleNode node = layer.getNode((PositionXZ)pos);
                return node.getType() != CastleNodeType.HALLWAY || node.hasStairs() || node.hasEntrance();
            });
            if (!collision) continue;
            return false;
        }
        return true;
    }

    private boolean tryPlaceRoom(RoomPlacement placement) {
        CastleRoomTemplate roomTemplate = placement.roomTemplate();
        int roomSizeX = placement.getRotatedSizeX();
        int roomSizeZ = placement.getRotatedSizeZ();
        for (int y = placement.position().getY(); y < placement.position().getY() + placement.roomTemplate().getSizeY(); ++y) {
            CastleLayer layer = this.layers.get(y);
            boolean collision = this.metrics.streamPositionsInCustomBounds(placement.position().getX(), placement.position().getX() + roomSizeX, placement.position().getZ(), placement.position().getZ() + roomSizeZ).anyMatch(pos -> {
                CastleNode node = layer.getNode((PositionXZ)pos);
                return node.getType() == CastleNodeType.ROOM;
            });
            if (!collision) continue;
            return false;
        }
        CastleRoomDoors createdDoors = new CastleRoomDoors(roomTemplate.getSizeX(), roomTemplate.getSizeY(), roomTemplate.getSizeZ());
        if (!this.placeTemporaryDoors(placement, createdDoors)) {
            this.undoTemporaryDoors(placement, createdDoors);
            return false;
        }
        for (int y = placement.position().getY(); y < placement.position().getY() + placement.roomTemplate().getSizeY(); ++y) {
            CastleLayer layer = this.layers.get(y);
            if (layer.testConnectivity()) continue;
            this.undoTemporaryDoors(placement, createdDoors);
            return false;
        }
        this.fillRoom(placement);
        return true;
    }

    private Stream<RoomDoor> streamDoors(RoomPlacement placement) {
        int roomSizeX = placement.getRotatedSizeX();
        int roomSizeZ = placement.getRotatedSizeZ();
        PositionXZ roomMin = placement.position().toXZ();
        PositionXZ roomMax = roomMin.copy().add(new PositionXZ(roomSizeX - 1, roomSizeZ - 1));
        return IntStream.range(placement.position().getY(), placement.position().getY() + placement.roomTemplate().getSizeY()).mapToObj(y -> {
            CastleLayer layer = this.layers.get(y);
            return Stream.concat(IntStream.range(placement.position().getX(), placement.position().getX() + roomSizeX).mapToObj(x -> Stream.of(new RoomDoor(layer, new PositionXYZ(x, y, roomMin.getZ()), Direction4XZ.NEGATIVE_Z), new RoomDoor(layer, new PositionXYZ(x, y, roomMax.getZ()), Direction4XZ.POSITIVE_Z))).flatMap(Function.identity()), IntStream.range(placement.position().getZ(), placement.position().getZ() + roomSizeZ).mapToObj(z -> Stream.of(new RoomDoor(layer, new PositionXYZ(roomMin.getX(), y, z), Direction4XZ.NEGATIVE_X), new RoomDoor(layer, new PositionXYZ(roomMax.getX(), y, z), Direction4XZ.POSITIVE_X))).flatMap(Function.identity()));
        }).flatMap(Function.identity());
    }

    private boolean placeTemporaryDoors(RoomPlacement placement, CastleRoomDoors createdDoors) {
        return this.streamDoors(placement).allMatch(door -> {
            CastleLayer layer = door.layer();
            PositionXZ pos = door.pos().toXZ();
            Direction4XZ dir = door.dir();
            int y = door.pos().getY() - placement.position().getY();
            Direction4XZ doorSide = placement.getDoorSide(dir);
            int doorIndex = placement.getDoorIndex(pos, dir);
            ConnectionState connection = layer.getConnection(pos, dir);
            if (!placement.roomTemplate().getDoors().getLayer(y).getSide(doorSide, doorIndex)) {
                if (connection == ConnectionState.MUST_EXIST) {
                    return false;
                }
                if (connection == ConnectionState.MAY_EXIST) {
                    createdDoors.getLayer(y).setSide(doorSide, doorIndex, true);
                    layer.setConnection(pos, dir, ConnectionState.CANNOT_EXISTS);
                }
            }
            return true;
        });
    }

    private void undoTemporaryDoors(RoomPlacement placement, CastleRoomDoors createdDoors) {
        this.streamDoors(placement).forEach(door -> {
            CastleLayer layer = door.layer();
            PositionXZ pos = door.pos().toXZ();
            Direction4XZ dir = door.dir();
            int y = door.pos().getY() - placement.position().getY();
            Direction4XZ doorSide = placement.getDoorSide(dir);
            int doorIndex = placement.getDoorIndex(pos, dir);
            if (createdDoors.getLayer(y).getSide(doorSide, doorIndex)) {
                layer.setConnection(pos, dir, ConnectionState.MAY_EXIST);
            }
        });
    }

    private void placeDoors(RoomPlacement placement) {
        this.streamDoors(placement).forEach(door -> {
            Direction4XZ dir;
            PositionXZ pos;
            CastleLayer layer = door.layer();
            if (layer.getConnection(pos = door.pos().toXZ(), dir = door.dir()) == ConnectionState.MUST_EXIST) {
                layer.setDoors(pos, dir, true);
            }
        });
    }

    private void fillRoom(RoomPlacement placement) {
        int roomSizeX = placement.getRotatedSizeX();
        int roomSizeZ = placement.getRotatedSizeZ();
        for (int y = placement.position().getY(); y < placement.position().getY() + placement.roomTemplate().getSizeY(); ++y) {
            CastleLayer layer = this.layers.get(y);
            this.metrics.streamPositionsInCustomBounds(placement.position().getX(), placement.position().getX() + roomSizeX, placement.position().getZ(), placement.position().getZ() + roomSizeZ).forEach(pos -> layer.getNode((PositionXZ)pos).setType(CastleNodeType.ROOM));
            this.metrics.streamPositionsInCustomBounds(placement.position().getX(), placement.position().getX() + roomSizeX - 1, placement.position().getZ(), placement.position().getZ() + roomSizeZ).forEach(pos -> layer.setConnection((PositionXZ)pos, Direction4XZ.POSITIVE_X, ConnectionState.MUST_EXIST));
            this.metrics.streamPositionsInCustomBounds(placement.position().getX(), placement.position().getX() + roomSizeX, placement.position().getZ(), placement.position().getZ() + roomSizeZ - 1).forEach(pos -> layer.setConnection((PositionXZ)pos, Direction4XZ.POSITIVE_Z, ConnectionState.MUST_EXIST));
        }
    }

    public List<CastleLayer> getLayers() {
        return this.layers;
    }

    public List<CastleRoom> getRooms() {
        return this.rooms;
    }

    public GridXZ<Boolean> getTowers() {
        return this.towers;
    }

    public CastleMetrics getMetrics() {
        return this.metrics;
    }
}

