/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FluidGeneratorRecipe
implements Recipe<NoInventoryRecipe> {
    private final ResourceLocation id;
    private final String fluid;
    private final int fluidAmount;

    public FluidGeneratorRecipe(ResourceLocation id, String fluid, int fluidAmount) {
        this.id = id;
        this.fluid = fluid;
        this.fluidAmount = fluidAmount;
    }

    public String getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public boolean matches(@NotNull NoInventoryRecipe inv, @NotNull Level pLevel) {
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull NoInventoryRecipe inv, RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FluidGeneratorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("opolisutilities", "fluid_generator");

        public FluidGeneratorRecipe fromJson(ResourceLocation id, JsonObject json) {
            String fluid = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
            int fluidAmount = GsonHelper.m_13824_((JsonObject)json, (String)"fluidAmount", (int)100);
            return new FluidGeneratorRecipe(id, fluid, fluidAmount);
        }

        public FluidGeneratorRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String fluid = buf.m_130277_();
            int fluidAmount = buf.readInt();
            return new FluidGeneratorRecipe(id, fluid, fluidAmount);
        }

        public void toNetwork(FriendlyByteBuf buf, FluidGeneratorRecipe recipe) {
            buf.m_130072_(recipe.getFluid(), Short.MAX_VALUE);
            buf.writeInt(recipe.getFluidAmount());
        }
    }

    public static class Type
    implements RecipeType<FluidGeneratorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fluid_generator";

        private Type() {
        }
    }
}

