/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.networking.packets;

import com.benbenlaw.opolisutilities.capabillties.CapabillitySyncronizer;
import com.benbenlaw.opolisutilities.capabillties.ICapabilitySync;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.network.NetworkEvent;

public class PacketCapabilitySyncToClient {
    private final ICapabilitySync capabilitySync;
    private final ResourceLocation ID;
    private final Capability<?> capability;
    private CompoundTag data;
    private Object rawData;

    public <T> PacketCapabilitySyncToClient(ICapabilitySync capabilitySync, Capability<?> capability, ResourceLocation ID, Object data) {
        this.ID = ID;
        this.capability = capability;
        this.capabilitySync = capabilitySync;
        this.rawData = data;
    }

    public PacketCapabilitySyncToClient(FriendlyByteBuf buf) {
        this.capabilitySync = null;
        this.ID = buf.m_130281_();
        this.capability = CapabillitySyncronizer.get(buf.m_130281_());
        this.data = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.ID);
        buf.m_130085_(CapabillitySyncronizer.get(this.capability));
        CompoundTag tag = new CompoundTag();
        CapabillitySyncronizer.getDataHandler(this.ID).ifPresent(e -> e.server().handle(tag, this.rawData));
        this.capabilitySync.toNetwork(tag);
        buf.m_130079_(tag);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> CapabillitySyncronizer.getDataHandler(this.ID).ifPresent(e -> e.client().handle(this.data, null)));
        return true;
    }
}

