/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.util.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalletItem
extends Item {
    public static final ResourceLocation WALLET_CAP = new ResourceLocation("opolisutilities", "wallet");
    private final Supplier<Item> currencyItem;

    public WalletItem(Item.Properties properties) {
        this(properties, (Supplier<Item>)ModItems.B_BUCKS);
    }

    public WalletItem(Item.Properties properties, Supplier<Item> currencyItem) {
        super(properties);
        this.currencyItem = currencyItem;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        LazyOptional handlerLO = player.m_21206_().getCapability(ForgeCapabilities.ITEM_HANDLER);
        handlerLO.ifPresent(e -> {
            if (player.m_6047_()) {
                ItemStack oppositeHand = player.m_21205_();
                if (!oppositeHand.m_41619_()) {
                    e.insertItem(0, oppositeHand, false);
                }
            } else if (player.m_150109_().m_36062_() != -1) {
                player.m_150109_().m_36054_(e.extractItem(0, 64, false));
            }
        });
        return super.m_7203_(level, player, hand);
    }

    private CapabilityProvider.WalletItemHandler getHandler(ItemStack wallet) {
        IItemHandler handler;
        Optional LO = wallet.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (LO.isPresent() && (handler = (IItemHandler)LO.get()) instanceof CapabilityProvider.WalletItemHandler) {
            CapabilityProvider.WalletItemHandler walletItemHandler = (CapabilityProvider.WalletItemHandler)handler;
            return walletItemHandler;
        }
        return null;
    }

    public void extractCurrency(ItemStack wallet, Item item, int amount) {
        CapabilityProvider.WalletItemHandler handler = this.getHandler(wallet);
        if (handler == null) {
            return;
        }
        int slot = handler.getSlotByItem(item);
        if (slot == -1) {
            return;
        }
        handler.extractItem(slot, amount, false);
    }

    public int getCurrencyStored(ItemStack wallet, Item item) {
        CapabilityProvider.WalletItemHandler handler = this.getHandler(wallet);
        if (handler != null) {
            WalletSlot slot = handler.getWalletSlotByItem(item);
            if (slot == null) {
                return 0;
            }
            return slot.getAmount();
        }
        return 0;
    }

    public String getCurrencyName() {
        return this.getCurrencyItem().m_7968_().m_41611_().getString();
    }

    public Item getCurrencyItem() {
        return this.currencyItem.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237110_((String)"tooltips.wallet.shift.held", (Object[])new Object[]{this.getCurrencyName(), this.getCurrencyName()}).m_130940_(ChatFormatting.GREEN));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltips.wallet.hover.shift").m_130940_(ChatFormatting.BLUE));
        }
        if (Screen.m_96638_()) {
            LazyOptional handlerLazyOptional = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (handlerLazyOptional.isPresent()) {
                handlerLazyOptional.ifPresent(e -> {
                    if (e.getSlots() > 0) {
                        components.add((Component)Component.m_237113_((String)"This wallet contains:").m_130940_(ChatFormatting.GREEN));
                        if (e instanceof CapabilityProvider.WalletItemHandler) {
                            CapabilityProvider.WalletItemHandler walletItemHandler = (CapabilityProvider.WalletItemHandler)e;
                            for (int i = 0; i < walletItemHandler.getSlots(); ++i) {
                                components.add((Component)Component.m_237113_((String)"%s %s".formatted(walletItemHandler.getWalletSlot(i).getAmount(), walletItemHandler.getWalletSlot(i).getItem().m_7968_().m_41611_().getString())).m_130940_(ChatFormatting.GREEN));
                            }
                        }
                    } else {
                        components.add((Component)Component.m_237113_((String)"This Wallet Is Empty").m_130940_(ChatFormatting.RED));
                    }
                });
            } else {
                components.add((Component)Component.m_237113_((String)"This Wallet Is Empty").m_130940_(ChatFormatting.RED));
            }
        } else {
            components.add((Component)Component.m_237115_((String)"tooltips.home_stone.hover.alt").m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(stack, level, components, flag);
    }

    public static class CapabilityProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final WalletItemHandler handler;
        private final LazyOptional<IItemHandler> ITEMLO;

        public CapabilityProvider(ItemStack stack) {
            this.handler = new WalletItemHandler(stack);
            this.ITEMLO = LazyOptional.of(() -> this.handler);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.ITEMLO.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("handler", (Tag)this.handler.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            if (nbt.m_128441_("handler")) {
                this.handler.deserializeNBT(nbt.m_128469_("handler"));
            }
        }

        public static class WalletItemHandler
        implements IItemHandler {
            final ItemStack stack;
            final ArrayList<WalletSlot> ITEMS = new ArrayList();

            private WalletItemHandler(ItemStack stack) {
                this.stack = stack;
            }

            public void setChanged() {
                CompoundTag tag = this.stack.m_41784_();
                tag.m_128379_("dirty", true);
                tag.m_128365_("data", (Tag)this.serializeNBT());
            }

            public void checkChanged() {
                CompoundTag tag = this.stack.m_41784_();
                if (tag.m_128441_("dirty") && tag.m_128471_("dirty") && tag.m_128441_("data")) {
                    this.deserializeNBT(tag.m_128469_("data"));
                    tag.m_128379_("dirty", false);
                }
            }

            public int getSlots() {
                this.checkChanged();
                return this.ITEMS.size();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return ItemStack.f_41583_;
            }

            public WalletSlot getWalletSlot(int slot) {
                return this.ITEMS.get(slot);
            }

            public int getSlotByItem(Item item) {
                return this.ITEMS.indexOf(this.getWalletSlotByItem(item));
            }

            public WalletSlot getWalletSlotByItem(Item item) {
                this.checkChanged();
                return this.ITEMS.stream().filter(e -> e.getItem() == item).findAny().orElse(null);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (stack.m_204117_(ModTags.Items.WALLET_ITEM)) {
                    WalletSlot walletSlot;
                    this.checkChanged();
                    Optional<WalletSlot> SLOT = this.ITEMS.stream().filter(e -> e.isSame(stack)).findAny();
                    if (SLOT.isPresent()) {
                        walletSlot = SLOT.get();
                    } else {
                        walletSlot = new WalletSlot(stack);
                        this.ITEMS.add(walletSlot);
                    }
                    if (simulate) {
                        return ItemStack.f_41583_;
                    }
                    walletSlot.setAmount(walletSlot.getAmount() + stack.m_41613_());
                    stack.m_41774_(stack.m_41613_());
                    this.setChanged();
                    return stack;
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int maxamount, boolean simulate) {
                this.checkChanged();
                int amount = maxamount;
                if (this.ITEMS.size() >= slot && !this.ITEMS.isEmpty()) {
                    WalletSlot walletSlot = this.ITEMS.get(slot);
                    if (walletSlot.getAmount() < amount) {
                        amount = walletSlot.getAmount();
                    }
                    if (walletSlot.getAmount() >= amount && walletSlot.getItem() != null) {
                        if (simulate) {
                            return new ItemStack((ItemLike)walletSlot.getItem(), amount);
                        }
                        ItemStack stack = new ItemStack((ItemLike)walletSlot.getItem(), amount);
                        walletSlot.setAmount(walletSlot.getAmount() - amount);
                        if (walletSlot.getAmount() <= 0) {
                            this.ITEMS.remove(walletSlot);
                        }
                        this.setChanged();
                        return stack;
                    }
                }
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                this.checkChanged();
                return this.ITEMS.size() + 1;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                CompoundTag list = new CompoundTag();
                AtomicInteger count = new AtomicInteger(0);
                this.ITEMS.forEach(slot -> {
                    CompoundTag slotTag = new CompoundTag();
                    slotTag.m_128359_("RL", slot.RL.toString());
                    slotTag.m_128405_("amount", slot.getAmount());
                    list.m_128365_("Item%s".formatted(count.getAndAdd(1)), (Tag)slotTag);
                });
                tag.m_128365_("list", (Tag)list);
                return tag;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.ITEMS.clear();
                CompoundTag list = nbt.m_128469_("list");
                list.m_128431_().forEach(e -> {
                    CompoundTag tag = list.m_128469_(e);
                    WalletSlot slot = new WalletSlot(new ResourceLocation(tag.m_128461_("RL")));
                    slot.setAmount(tag.m_128451_("amount"));
                    this.ITEMS.add(slot);
                });
            }
        }
    }

    public static class WalletSlot {
        private final ResourceLocation RL;
        private final AtomicInteger integer;

        public WalletSlot(ResourceLocation RL) {
            this.RL = RL;
            this.integer = new AtomicInteger();
        }

        public WalletSlot(ItemStack stack) {
            this(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }

        public int getAmount() {
            return this.integer.get();
        }

        public void setAmount(int amount) {
            this.integer.set(amount);
        }

        public boolean isSame(ItemStack stack) {
            return this.getItem() != null && stack.m_150930_(this.getItem());
        }

        public Item getItem() {
            return (Item)ForgeRegistries.ITEMS.getValue(this.RL);
        }
    }
}

