/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.recipe.SoakingTableRecipe;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SoakingTableRecipeCategory
implements IRecipeCategory<SoakingTableRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("opolisutilities", "soaking_table");
    public static final ResourceLocation TEXTURE = new ResourceLocation("opolisutilities", "textures/gui/jei_drying_table.png");
    static final RecipeType<SoakingTableRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"soaking_table", SoakingTableRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SoakingTableRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 120, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.DRYING_TABLE.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public RecipeType<SoakingTableRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.SOAKING_TABLE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Soaking Table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SoakingTableRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 4, 2).addItemStack(new ItemStack((ItemLike)ModItems.JEI_NULL_ITEM.get(), recipe.getCount()));
        assert (false);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 2).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }

    public void draw(SoakingTableRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        int duration = recipe.getDuration();
        guiGraphics.m_280430_(minecraft.f_91062_.self(), (Component)Component.m_237113_((String)(duration / 20 + "s")), 95, 6, Color.WHITE.getRGB());
    }
}

