/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.recipe.FluidGeneratorRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FluidGeneratorRecipeCategory
implements IRecipeCategory<FluidGeneratorRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("opolisutilities", "fluid_generator");
    public static final ResourceLocation TEXTURE = new ResourceLocation("opolisutilities", "textures/gui/jei_dynamic.png");
    static final RecipeType<FluidGeneratorRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"fluid_generator", FluidGeneratorRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;

    public FluidGeneratorRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 175, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.RESOURCE_GENERATOR_2.get()));
    }

    @NotNull
    public RecipeType<FluidGeneratorRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.FLUID_GENERATOR;
    }

    public boolean isHandled(FluidGeneratorRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237113_((String)"Fluid Generator");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidGeneratorRecipe recipe, @NotNull IFocusGroup focusGroup) {
        ++this.tabs_used;
        List recipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)FluidGeneratorRecipe.Type.INSTANCE);
        int numRows = (int)Math.ceil((double)recipes.size() / 9.0);
        int numCols = Math.min(9, recipes.size());
        int backgroundWidth = 4 + numCols * 19;
        int backgroundHeight = 2 + numRows * 19;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, backgroundWidth, backgroundHeight);
        for (int i = 0; i < recipes.size(); ++i) {
            int slotX = 4 + i % 9 * 19;
            int slotY = 2 + i / 9 * 19;
            String fluidAsString = ((FluidGeneratorRecipe)recipes.get(i)).getFluid();
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidAsString));
            assert (fluid != null);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, slotX, slotY).addFluidStack(fluid, (long)((FluidGeneratorRecipe)recipes.get(i)).getFluidAmount())).setFluidRenderer((long)((FluidGeneratorRecipe)recipes.get(i)).getFluidAmount(), true, 16, 16);
        }
    }
}

