/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.event;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.custom.EnderScramblerBlock;
import com.benbenlaw.opolisutilities.config.ConfigFile;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.item.custom.AnimalNetItem;
import com.benbenlaw.opolisutilities.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="opolisutilities")
public class ModEvents {
    public static Vec3 globalEntity;
    public static Level globalLevel;

    @SubscribeEvent
    public static void cancelEndermanTeleportation(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EnderMan) {
            BlockPos pos = entity.m_20097_();
            int maxRange = 8;
            for (int x = -maxRange; x <= maxRange; ++x) {
                for (int y = -maxRange; y <= maxRange; ++y) {
                    for (int z = -maxRange; z <= maxRange; ++z) {
                        BlockPos p = pos.m_7918_(x, y, z);
                        BlockState state = entity.m_9236_().m_8055_(p);
                        if (!state.m_60713_((Block)ModBlocks.ENDER_SCRAMBLER.get())) continue;
                        int r1 = (Integer)state.m_61143_((Property)EnderScramblerBlock.SCRAMBLER_RANGE);
                        for (int x1 = -r1; x1 <= r1; ++x1) {
                            for (int y1 = -r1; y1 <= r1; ++y1) {
                                for (int z1 = -r1; z1 <= r1; ++z1) {
                                    BlockPos p1 = pos.m_7918_(x1, y1, z1);
                                    BlockState state1 = entity.m_9236_().m_8055_(p1);
                                    if (!state1.m_60713_((Block)ModBlocks.ENDER_SCRAMBLER.get()) || !((Boolean)state1.m_61143_((Property)EnderScramblerBlock.POWERED)).equals(true)) continue;
                                    event.setCanceled(true);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void getPlayerDeathPoint(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            globalEntity = entity.m_20182_();
            globalLevel = entity.m_9236_();
        }
    }

    @SubscribeEvent
    public static void addDeathStoneOnPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        ItemStack deathStoneItem = new ItemStack((ItemLike)ModItems.DEATH_STONE.get());
        CompoundTag nbt = new CompoundTag();
        if (globalEntity != null && globalLevel != null) {
            nbt.m_128405_("Age", Short.MIN_VALUE);
            nbt.m_128347_("x", ModEvents.globalEntity.f_82479_);
            nbt.m_128347_("y", ModEvents.globalEntity.f_82480_);
            nbt.m_128347_("z", ModEvents.globalEntity.f_82481_);
            ResourceLocation dim = globalLevel.m_46472_().m_135782_();
            nbt.m_128359_("dimension", dim.m_135827_() + ":" + dim.m_135815_());
            nbt.m_128359_("namespace", dim.m_135827_());
            nbt.m_128359_("path", dim.m_135815_());
            deathStoneItem.m_41751_(nbt);
        }
        if (((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46133_)).m_46223_()) {
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), deathStoneItem));
        }
        if (!((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46133_)).m_46223_()) {
            player.m_36356_(deathStoneItem);
        }
    }

    @SubscribeEvent
    public static void addLootBoxesToEntities(LivingDeathEvent event) {
        Vec3 entityPos = event.getEntity().m_20182_();
        Level world = event.getEntity().m_9236_();
        LivingEntity e = event.getEntity();
        if (!(e instanceof ServerPlayer) && Math.random() > (Double)ConfigFile.basicLootBoxDropChance.get()) {
            world.m_7967_((Entity)new ItemEntity(world, entityPos.m_7096_(), entityPos.m_7098_(), entityPos.m_7094_(), new ItemStack((ItemLike)ModItems.BASIC_LOOT_BOX.get())));
        }
    }

    @SubscribeEvent
    public static void sheepFollowCrook(EntityJoinLevelEvent event) {
        Sheep sheep;
        int priority;
        Entity entity = event.getEntity();
        if (entity instanceof Sheep && (priority = ModEvents.getTemptGoalPriority((Mob)(sheep = (Sheep)entity))) >= 0) {
            sheep.f_21345_.m_25352_(priority, (Goal)new TemptGoal((PathfinderMob)sheep, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CROOK.get()}), false));
        }
    }

    public static int getTemptGoalPriority(Mob mob) {
        return mob.f_21345_.m_148105_().stream().filter(goal -> goal.m_26015_() instanceof TemptGoal).findFirst().map(WrappedGoal::m_26012_).orElse(-1);
    }

    @SubscribeEvent
    public static void onEntityRightClickEvent(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Entity livingEntity = event.getTarget();
        if (!level.m_5776_() && stack.m_41720_() instanceof AnimalNetItem && !stack.m_41783_().m_128441_("entity")) {
            boolean captureVillagers;
            ItemStack itemstack = player.m_21120_(hand);
            CompoundTag nbt = itemstack.m_41783_();
            boolean hostileMobs = (Boolean)ConfigFile.animalNetHostileMobs.get();
            boolean waterMobs = (Boolean)ConfigFile.animalNetWaterMobs.get();
            boolean animalMobs = (Boolean)ConfigFile.animalNetAnimalMobs.get();
            boolean villagerMobs = (Boolean)ConfigFile.animalNetVillagerMobs.get();
            boolean captureHostile = livingEntity instanceof Monster && hostileMobs;
            boolean captureWater = livingEntity instanceof WaterAnimal && waterMobs;
            boolean captureAnimal = livingEntity instanceof Animal && animalMobs;
            boolean bl = captureVillagers = livingEntity instanceof Villager && villagerMobs;
            if (!level.m_5776_()) {
                if (captureHostile || captureWater || captureAnimal || captureVillagers || livingEntity.m_7307_((Entity)player)) {
                    assert (nbt != null);
                    nbt.m_128359_("entity", EntityType.m_20613_((EntityType)livingEntity.m_6095_()).toString());
                    livingEntity.m_20240_(nbt);
                    stack.m_41751_(nbt);
                    livingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    player.m_213846_((Component)Component.m_237115_((String)"tooltips.animal_net.mob_caught").m_130940_(ChatFormatting.GREEN));
                    level.m_247517_(null, livingEntity.m_20183_(), SoundEvents.f_12019_, SoundSource.BLOCKS);
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"tooltips.animal_net.not_compatible_mob").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    @SubscribeEvent
    public static void doorBellSounds(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)ConfigFile.woodenButtonsMakeDoorbellSound.get()).booleanValue()) {
            Level level = event.getLevel();
            BlockState state = event.getLevel().m_8055_(event.getPos());
            if (!level.m_5776_() && state.m_204336_(BlockTags.f_13092_)) {
                level.m_5594_(null, event.getPos(), (SoundEvent)ModSounds.DOORBELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

