/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.event;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock;
import com.benbenlaw.opolisutilities.block.custom.BlockPlacerBlock;
import com.benbenlaw.opolisutilities.block.custom.CrafterBlock;
import com.benbenlaw.opolisutilities.block.custom.DryingTableBlock;
import com.benbenlaw.opolisutilities.block.custom.EnderScramblerBlock;
import com.benbenlaw.opolisutilities.block.custom.RedstoneClockBlock;
import com.benbenlaw.opolisutilities.block.custom.ResourceGenerator2Block;
import com.benbenlaw.opolisutilities.block.entity.custom.BlockBreakerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.BlockPlacerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.CrafterBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.DryingTableBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.EnderScramblerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.FluidGeneratorBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.ItemRepairerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.RedstoneClockBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.ResourceGenerator2BlockEntity;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="opolisutilities")
public class HoverInWorldEvents {
    @OnlyIn(value=Dist.CLIENT)
    public static void renderEnderScramblerInfo(GuiGraphics graphics, float partialTicks) {
        HitResult hitResult;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        assert (player != null);
        Level level = player.m_9236_();
        if ((player.m_21205_().m_150930_((Item)ModItems.OPOLIS_WRENCH.get()) || player.m_21206_().m_150930_((Item)ModItems.OPOLIS_WRENCH.get())) && minecraft.f_91080_ == null && (hitResult = minecraft.f_91077_) instanceof BlockHitResult) {
            BlockEntity entity;
            BlockHitResult hit = (BlockHitResult)hitResult;
            BlockPos blockPos = hit.m_82425_();
            BlockState blockState = minecraft.f_91073_.m_8055_(blockPos);
            Block block = blockState.m_60734_();
            ItemStack lookingAtBlock = block.m_7397_((BlockGetter)minecraft.f_91073_, blockPos, blockState);
            Window window = minecraft.m_91268_();
            int x = window.m_85445_() / 2 + 3;
            int y = window.m_85446_() / 2 + 3;
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.ENDER_SCRAMBLER.get()).m_5456_()) && (entity = (EnderScramblerBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getEnderScramblerInformation((EnderScramblerBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.BLOCK_BREAKER.get()).m_5456_()) && (entity = (BlockBreakerBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getBlockBreakerInformation((BlockBreakerBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.BLOCK_PLACER.get()).m_5456_()) && (entity = (BlockPlacerBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getBlockPlacerInformation((BlockPlacerBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.ITEM_REPAIRER.get()).m_5456_()) && (entity = (ItemRepairerBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getItemRepairerInformation((ItemRepairerBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.DRYING_TABLE.get()).m_5456_()) && (entity = (DryingTableBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getDryingTableInformation((DryingTableBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.REDSTONE_CLOCK.get()).m_5456_()) && (entity = (RedstoneClockBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getRedstoneClockInformation((RedstoneClockBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.FLUID_GENERATOR.get()).m_5456_()) && (entity = (FluidGeneratorBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getFluidGenInformation((FluidGeneratorBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.RESOURCE_GENERATOR_2.get()).m_5456_()) && (entity = (ResourceGenerator2BlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getResourceGen2Information((ResourceGenerator2BlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            if (lookingAtBlock.m_150930_(((Block)ModBlocks.CRAFTER.get()).m_5456_()) && (entity = (CrafterBlockEntity)level.m_7702_(blockPos)) != null) {
                graphics.m_280677_(minecraft.f_91062_, HoverInWorldEvents.getCrafterInformation((CrafterBlockEntity)entity), Optional.empty(), window.m_85447_() + 2, window.m_85448_() + 2);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
        }
    }

    public static List<Component> getRedstoneClockInformation(RedstoneClockBlockEntity entity) {
        MutableComponent informationTitle = Component.m_237113_((String)"Redstone Clock Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        MutableComponent currentTick = Component.m_237113_((String)("Current Tick: " + entity.m_58900_().m_61143_((Property)RedstoneClockBlock.CLOCK_TIMER)));
        MutableComponent increaseBy10 = Component.m_237113_((String)"Right Click: Increase by 10");
        MutableComponent increaseBy50 = Component.m_237113_((String)"Ctrl Right Click: Increase by 50");
        MutableComponent decreaseBy10 = Component.m_237113_((String)"Shift Right Click: Decrease by 10");
        MutableComponent decreaseBy50 = Component.m_237113_((String)"Shift Ctrl Right Click: Decrease by 50");
        return List.of(informationTitle, empty, currentTick, increaseBy10, increaseBy50, decreaseBy10, decreaseBy50);
    }

    public static List<Component> getBlockBreakerInformation(BlockBreakerBlockEntity entity) {
        boolean isWhiteList = !entity.getItemStackHandler().getStackInSlot(1).m_41619_();
        Item whiteListItem = entity.getItemStackHandler().getStackInSlot(1).m_41720_();
        String translatedWhiteListItem = whiteListItem.m_7626_(whiteListItem.m_7968_()).getString();
        boolean isBlackList = !entity.getItemStackHandler().getStackInSlot(2).m_41619_();
        Item blackListItem = entity.getItemStackHandler().getStackInSlot(2).m_41720_();
        String translatedBlackListItem = blackListItem.m_7626_(blackListItem.m_7968_()).getString();
        Item currentTool = entity.getItemStackHandler().getStackInSlot(0).m_41720_();
        String translatedTool = currentTool.m_7626_(currentTool.m_7968_()).getString();
        int toolDurabilityTaken = entity.getItemStackHandler().getStackInSlot(0).m_41773_();
        int toolDurabilityRemaining = entity.getItemStackHandler().getStackInSlot(0).m_41776_() - toolDurabilityTaken;
        MutableComponent currentToolTooltip = Component.m_237113_((String)"NULL").m_130940_(ChatFormatting.RED);
        MutableComponent currentItemTooltip = Component.m_237113_((String)"No Filter!").m_130940_(ChatFormatting.RED);
        if (!translatedTool.equals("Air")) {
            currentToolTooltip = Component.m_237113_((String)("Current Tool: " + translatedTool + " with " + toolDurabilityRemaining + " durability"));
        }
        if (translatedTool.equals("Air")) {
            currentToolTooltip = Component.m_237113_((String)"Current Tool: No Tool");
        }
        if (isWhiteList) {
            currentItemTooltip = Component.m_237113_((String)("Will only break " + translatedWhiteListItem));
        }
        if (isBlackList) {
            currentItemTooltip = Component.m_237113_((String)("Will break any block except " + translatedBlackListItem));
        }
        MutableComponent informationTitle = Component.m_237113_((String)"Block Breaker Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        MutableComponent currentTickrate = Component.m_237113_((String)("Ticks Per Block Break: " + entity.m_58900_().m_61143_((Property)BlockBreakerBlock.TIMER)));
        MutableComponent increaseBy10 = Component.m_237113_((String)"Shift Right Click: Increase by 10").m_130940_(ChatFormatting.GREEN);
        MutableComponent decreaseBy10 = Component.m_237113_((String)"Shift Ctrl Right Click: Decrease by 10").m_130940_(ChatFormatting.RED);
        return List.of(informationTitle, empty, currentTickrate, increaseBy10, decreaseBy10, currentToolTooltip, currentItemTooltip);
    }

    public static List<Component> getBlockPlacerInformation(BlockPlacerBlockEntity entity) {
        Item itemPlaced = entity.getItemStackHandler().getStackInSlot(0).m_41720_();
        String translatedPlaced = itemPlaced.m_7626_(itemPlaced.m_7968_()).getString();
        MutableComponent placing = Component.m_237113_((String)"Placing Nothing!").m_130940_(ChatFormatting.RED);
        if (!translatedPlaced.equals("Air")) {
            placing = Component.m_237113_((String)("Placing: " + translatedPlaced));
        }
        MutableComponent informationTitle = Component.m_237113_((String)"Block Placer Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        MutableComponent currentTickrate = Component.m_237113_((String)("Ticks Per Block Place: " + entity.m_58900_().m_61143_((Property)BlockPlacerBlock.TIMER)));
        MutableComponent increaseBy10 = Component.m_237113_((String)"Shift Right Click: Increase by 10").m_130940_(ChatFormatting.GREEN);
        MutableComponent decreaseBy10 = Component.m_237113_((String)"Shift Ctrl Right Click: Decrease by 10").m_130940_(ChatFormatting.RED);
        return List.of(informationTitle, empty, currentTickrate, increaseBy10, decreaseBy10, placing);
    }

    public static List<Component> getFluidGenInformation(FluidGeneratorBlockEntity entity) {
        Block fluid = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entity.getResource()));
        assert (fluid != null);
        String name = fluid.m_49954_().getString();
        MutableComponent collecting = Component.m_237113_((String)"Generating Nothing!").m_130940_(ChatFormatting.RED);
        if (!name.equals("Air")) {
            collecting = Component.m_237113_((String)("Generating: " + name + " at " + entity.getFluidAmount() + "mb per " + entity.getTickrate() + " ticks"));
        }
        MutableComponent informationTitle = Component.m_237113_((String)"Fluid Generator Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        return List.of(informationTitle, empty, collecting);
    }

    public static List<Component> getResourceGen2Information(ResourceGenerator2BlockEntity entity) {
        Block block = Objects.requireNonNull(entity.m_58904_()).m_8055_(entity.m_58899_().m_7494_()).m_60734_();
        String name = block.m_49954_().getString();
        MutableComponent collecting = Component.m_237113_((String)"Generating Nothing!").m_130940_(ChatFormatting.RED);
        if (!name.equals("Air") && ((Boolean)entity.m_58900_().m_61143_((Property)ResourceGenerator2Block.LIT)).booleanValue()) {
            collecting = Component.m_237113_((String)("Generating: " + name + " every " + entity.getTickrate() + " ticks"));
        }
        System.out.println("ResourceGen2Information: " + block);
        MutableComponent informationTitle = Component.m_237113_((String)"Resource Generator 2 Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        return List.of(informationTitle, empty, collecting);
    }

    public static List<Component> getDryingTableInformation(DryingTableBlockEntity entity) {
        MutableComponent informationTitle = Component.m_237113_((String)"Drying Table Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        if (((Boolean)entity.m_58900_().m_61143_((Property)DryingTableBlock.WATERLOGGED)).booleanValue()) {
            informationTitle = Component.m_237113_((String)"Soaking Table Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        }
        MutableComponent waterlogged = Component.m_237113_((String)"").m_130940_(ChatFormatting.RED);
        if (!((Boolean)entity.m_58900_().m_61143_((Property)DryingTableBlock.WATERLOGGED)).booleanValue()) {
            waterlogged = Component.m_237113_((String)"Waterlog to create a Drying Table");
        }
        MutableComponent empty = Component.m_237113_((String)"");
        if (!((Boolean)entity.m_58900_().m_61143_((Property)DryingTableBlock.WATERLOGGED)).booleanValue()) {
            return List.of(informationTitle, empty, waterlogged);
        }
        return List.of(informationTitle, empty);
    }

    public static List<Component> getItemRepairerInformation(ItemRepairerBlockEntity entity) {
        Item itemBeingRepaired = entity.getItemStackHandler().getStackInSlot(0).m_41720_();
        String translatedWhiteListItem = itemBeingRepaired.m_7626_(itemBeingRepaired.m_7968_()).getString();
        Item itemRepaired = entity.getItemStackHandler().getStackInSlot(1).m_41720_();
        String translatedRepaired = itemRepaired.m_7626_(itemRepaired.m_7968_()).getString();
        int toolDurabilityTaken = entity.getItemStackHandler().getStackInSlot(0).m_41773_();
        MutableComponent repairer = Component.m_237113_((String)"Repairing Nothing!").m_130940_(ChatFormatting.RED);
        if (!translatedWhiteListItem.equals("Air")) {
            repairer = Component.m_237113_((String)("Repairing: " + translatedWhiteListItem + " " + toolDurabilityTaken + " to go "));
        }
        MutableComponent stats = Component.m_237113_((String)"No Items repaired");
        if (!translatedRepaired.equals("Air")) {
            stats = Component.m_237113_((String)("Repaired: " + translatedRepaired));
        }
        MutableComponent informationTitle = Component.m_237113_((String)"Item Repairer Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        return List.of(informationTitle, empty, repairer, stats);
    }

    public static List<Component> getEnderScramblerInformation(EnderScramblerBlockEntity entity) {
        int currentRange = (Integer)entity.m_58900_().m_61143_((Property)EnderScramblerBlock.SCRAMBLER_RANGE);
        boolean isRunning = (Boolean)entity.m_58900_().m_61143_((Property)EnderScramblerBlock.POWERED);
        MutableComponent running = Component.m_237113_((String)("Range: " + currentRange));
        MutableComponent allowed = Component.m_237113_((String)"Teleporting Allowed!");
        if (isRunning) {
            allowed = Component.m_237113_((String)"Teleporting Not Allowed!").m_130940_(ChatFormatting.RED);
        }
        MutableComponent informationTitle = Component.m_237113_((String)"Ender Scrambler Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        MutableComponent instructions1 = Component.m_237113_((String)"Right Click: Increase Range").m_130940_(ChatFormatting.GREEN);
        MutableComponent instructions2 = Component.m_237113_((String)"Shift Right Click: Decrease Range").m_130940_(ChatFormatting.RED);
        MutableComponent instructions3 = Component.m_237113_((String)"Offhand Right Click to Enable/Disable");
        return List.of(informationTitle, empty, running, instructions1, instructions2, instructions3, allowed);
    }

    public static List<Component> getCrafterInformation(CrafterBlockEntity entity) {
        boolean isRunning = (Boolean)entity.m_58900_().m_61143_((Property)CrafterBlock.POWERED);
        Item itemCrafted = entity.craftingItem.m_41720_();
        String itemCraftedTranslated = itemCrafted.m_7626_(itemCrafted.m_7968_()).getString();
        MutableComponent instructions1 = Component.m_237113_((String)"Crafting: Nothing (Turn on by Shift Right Clicking with the wrench)").m_130940_(ChatFormatting.RED);
        if (isRunning) {
            instructions1 = Component.m_237113_((String)("Crafting: " + itemCraftedTranslated)).m_130940_(ChatFormatting.GREEN);
        }
        MutableComponent informationTitle = Component.m_237113_((String)"Crafter Information").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        MutableComponent empty = Component.m_237113_((String)"");
        MutableComponent currentTickrate = Component.m_237113_((String)("Ticks Per Craft: " + entity.m_58900_().m_61143_((Property)CrafterBlock.TIMER)));
        MutableComponent increaseBy10 = Component.m_237113_((String)"Shift Right Click in Off Hand: Increase by 10").m_130940_(ChatFormatting.GREEN);
        MutableComponent decreaseBy10 = Component.m_237113_((String)"Shift Ctrl Right Click in Off Hand: Decrease by 10").m_130940_(ChatFormatting.RED);
        return List.of(informationTitle, empty, currentTickrate, increaseBy10, decreaseBy10, instructions1);
    }
}

