/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.capabillties;

import com.benbenlaw.opolisutilities.capabillties.handlers.BlockDataHandler;
import com.benbenlaw.opolisutilities.capabillties.handlers.SidedDataHandler;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class CapabillitySyncronizer {
    private static final HashMap<Capability<?>, ResourceLocation> CAPS = new HashMap();
    private static final HashMap<ResourceLocation, Capability<?>> REVERSE_CAPS = new HashMap();
    private static final HashMap<ResourceLocation, SidedDataHandler> DATA_HANDLERS = new HashMap();

    public static void register(ResourceLocation resourceLocation, Capability<?> capability) {
        CAPS.put(capability, resourceLocation);
        REVERSE_CAPS.put(resourceLocation, capability);
    }

    public static void registerDataHandler(ResourceLocation ID, SidedDataHandler handler) {
        if (DATA_HANDLERS.containsKey(ID)) {
            throw new IllegalStateException("ID: %s already exists".formatted(ID));
        }
        DATA_HANDLERS.put(ID, handler);
    }

    public static Optional<SidedDataHandler> getDataHandler(ResourceLocation ID) {
        return DATA_HANDLERS.containsKey(ID) ? Optional.of(DATA_HANDLERS.get(ID)) : Optional.empty();
    }

    public static ResourceLocation get(Capability<?> capability) {
        return CAPS.getOrDefault(capability, new ResourceLocation("empty"));
    }

    public static Capability<?> get(ResourceLocation location) {
        return REVERSE_CAPS.getOrDefault(location, null);
    }

    static {
        CapabillitySyncronizer.register(new ResourceLocation("forge", "item"), ForgeCapabilities.ITEM_HANDLER);
        CapabillitySyncronizer.register(new ResourceLocation("forge", "fluid"), ForgeCapabilities.FLUID_HANDLER);
        CapabillitySyncronizer.register(new ResourceLocation("forge", "energy"), ForgeCapabilities.ENERGY);
        CapabillitySyncronizer.register(new ResourceLocation("forge", "fluid_item"), ForgeCapabilities.FLUID_HANDLER_ITEM);
        CapabillitySyncronizer.registerDataHandler(Types.BLOCKS, Types.BLOCK_DATA_HANDLER);
    }

    public static class Types {
        public static final ResourceLocation BLOCKS = new ResourceLocation("opolisutilities", "blocks");
        public static final ResourceLocation ITEMS = new ResourceLocation("opolisutilities", "items");
        public static final SidedDataHandler BLOCK_DATA_HANDLER = SidedDataHandler.create(new BlockDataHandler.Server(), new BlockDataHandler.Client());
    }
}

