/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.recipe.ResourceGeneratorRecipe;
import com.benbenlaw.opolisutilities.screen.ResourceGeneratorMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.benbenlaw.opolisutilities.util.inventory.WrappedHandler;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceGeneratorBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            ResourceGeneratorBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 1, (i, s) -> false)), Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 1, (i, s) -> false)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 1, (i, s) -> false)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 1, (i, s) -> false)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 1, (i, s) -> false)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 1, (i, s) -> false)));
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ResourceGeneratorBlockEntity.this.progress;
                case 1 -> ResourceGeneratorBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ResourceGeneratorBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ResourceGeneratorBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 220;

    public ResourceGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.RESOURCE_GENERATOR_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Resource Generator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new ResourceGeneratorMenu(containerID, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.directionWrappedHandlerMap.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (Direction dir : Direction.values()) {
            if (!this.directionWrappedHandlerMap.containsKey(dir)) continue;
            this.directionWrappedHandlerMap.get(dir).invalidate();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("resource_generator.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("resource_generator.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick() {
        Level pLevel = this.f_58857_;
        BlockPos pPos = this.f_58858_;
        assert (pLevel != null);
        BlockState pState = pLevel.m_8055_(pPos);
        ResourceGeneratorBlockEntity pBlockEntity = this;
        if (this.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            ResourceGeneratorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                this.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            ResourceGeneratorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private boolean hasRecipe(ResourceGeneratorBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        Optional match = level.m_7465_().m_44015_((RecipeType)ResourceGeneratorRecipe.Type.INSTANCE, (Container)inventory, level);
        match.ifPresent(recipe -> {
            this.maxProgress = recipe.getDuration();
        });
        if (match.isEmpty() || !this.canInsertAmountIntoOutputSlot(inventory)) {
            return false;
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        return this.canInsertItemIntoOutputSlot(inventory, ((ResourceGeneratorRecipe)match.get()).m_8043_(Objects.requireNonNull(this.m_58904_()).m_9598_())) && this.hasDuration((ResourceGeneratorRecipe)match.get());
    }

    private void craftItem(ResourceGeneratorBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        Optional match = level.m_7465_().m_44015_((RecipeType)ResourceGeneratorRecipe.Type.INSTANCE, (Container)inventory, level);
        if (match.isPresent()) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            ItemStack resultItem = new ItemStack((ItemLike)((ResourceGeneratorRecipe)match.get()).m_8043_(Objects.requireNonNull(this.m_58904_()).m_9598_()).m_41720_(), entity.itemHandler.getStackInSlot(1).m_41613_() + 1);
            CompoundTag resultItemNBT = ((ResourceGeneratorRecipe)match.get()).m_8043_(Objects.requireNonNull(this.m_58904_()).m_9598_()).m_41783_();
            if (resultItemNBT != null) {
                resultItem.m_41751_(resultItemNBT);
            }
            entity.itemHandler.setStackInSlot(1, resultItem);
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasDuration(ResourceGeneratorRecipe recipe) {
        return 0 <= recipe.getDuration();
    }

    private boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack output) {
        return inventory.m_8020_(1).m_41720_() == output.m_41720_() || inventory.m_8020_(1).m_41619_();
    }

    private boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(1).m_41741_() > inventory.m_8020_(1).m_41613_();
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        this.copyHandlerContents(handler);
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    private void copyHandlerContents(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public boolean inputItemHasCorrectNBT(SimpleContainer inventory, ResourceGeneratorRecipe recipe) {
        return ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41783_() == inventory.m_8020_(0).m_41783_();
    }
}

