/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.custom.FluidGeneratorBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.recipe.FluidGeneratorRecipe;
import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.RG2SpeedBlocksRecipe;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FluidGeneratorBlockEntity
extends BlockEntity {
    private int progress = 0;
    private int maxProgress = 220;
    private int fluidAmount;
    public String resource;
    private boolean isValidStructure = false;

    public FluidGeneratorBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FLUID_GENERATOR_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public void tick() {
        Level pLevel = this.f_58857_;
        BlockPos blockPos = this.f_58858_;
        assert (pLevel != null);
        FluidGeneratorBlockEntity entity = this;
        ++entity.progress;
        if (!this.f_58857_.m_8055_(blockPos.m_6630_(2)).m_60713_(Blocks.f_50016_)) {
            for (RG2SpeedBlocksRecipe match : this.f_58857_.m_7465_().m_44056_((RecipeType)RG2SpeedBlocksRecipe.Type.INSTANCE, (Container)NoInventoryRecipe.INSTANCE, this.f_58857_)) {
                String blockName = match.getBlock();
                Block speedBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
                TagKey speedBlockTag = BlockTags.create((ResourceLocation)new ResourceLocation(blockName));
                if (!this.f_58857_.m_8055_(blockPos.m_6630_(2)).m_222976_().containsTag(speedBlockTag) && !this.f_58857_.m_8055_(blockPos.m_6630_(2)).m_60713_(Objects.requireNonNull(speedBlock))) continue;
                this.maxProgress = match.getTickRate();
            }
        }
        if (this.f_58857_.m_8055_(blockPos.m_6630_(2)).m_60713_(Blocks.f_50016_)) {
            this.maxProgress = 220;
        }
        if (entity.progress % 5 == 0) {
            for (FluidGeneratorRecipe fluidBlocks : this.f_58857_.m_7465_().m_44056_((RecipeType)FluidGeneratorRecipe.Type.INSTANCE, (Container)NoInventoryRecipe.INSTANCE, this.f_58857_)) {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidBlocks.getFluid()));
                if (this.f_58857_.m_6425_(blockPos.m_6630_(1)).m_192917_(fluid)) {
                    this.isValidStructure = this.f_58857_.m_6425_(blockPos.m_6630_(1)).m_192917_(fluid);
                    this.f_58857_.m_46597_(blockPos, (BlockState)this.f_58857_.m_8055_(blockPos).m_61124_((Property)FluidGeneratorBlock.LIT, (Comparable)Boolean.valueOf(true)));
                    this.fluidAmount = fluidBlocks.getFluidAmount();
                    assert (fluid != null);
                    this.resource = fluid.getFluidType().toString();
                    FluidGeneratorBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)blockPos, (BlockState)this.m_58900_());
                    break;
                }
                this.isValidStructure = false;
                this.resource = "";
                FluidGeneratorBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)blockPos, (BlockState)this.m_58900_());
            }
        }
        if (this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.FLUID_GENERATOR.get()) && !this.isValidStructure) {
            this.f_58857_.m_46597_(blockPos, (BlockState)this.f_58857_.m_8055_(blockPos).m_61124_((Property)FluidGeneratorBlock.LIT, (Comparable)Boolean.valueOf(false)));
            FluidGeneratorBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)blockPos, (BlockState)this.m_58900_());
        }
        if (this.progress >= this.maxProgress && this.isValidStructure) {
            this.progress = 0;
            FluidGeneratorBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)blockPos, (BlockState)this.m_58900_());
            if (this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.FLUID_GENERATOR.get()) && this.f_58857_.m_7702_(blockPos.m_7495_()) != null) {
                BlockEntity ent = this.f_58857_.m_7702_(blockPos.m_7495_());
                FluidState fluidState = this.f_58857_.m_6425_(blockPos.m_7494_());
                assert (ent != null);
                int finalFluidAmount = this.fluidAmount;
                ent.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).ifPresent(iFluidHandler -> {
                    FluidStack fluid = new FluidStack(fluidState.m_76152_(), finalFluidAmount);
                    iFluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                });
            }
        }
    }

    public String getResource() {
        return this.resource;
    }

    public Integer getTickrate() {
        return this.maxProgress;
    }

    public Integer getFluidAmount() {
        return this.fluidAmount;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_("fluid_generator.progress", this.progress);
        tag.m_128405_("fluid_generator.maxProgress", this.maxProgress);
        tag.m_128359_("resource", this.resource);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("fluid_generator.progress");
        this.maxProgress = nbt.m_128451_("fluid_generator.maxProgress");
        this.resource = nbt.m_128461_("resource");
    }
}

