/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.CrafterBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.networking.ModMessages;
import com.benbenlaw.opolisutilities.networking.packets.PacketSyncItemStackToClient;
import com.benbenlaw.opolisutilities.screen.CrafterMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.benbenlaw.opolisutilities.util.inventory.WrappedHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrafterBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            CrafterBlockEntity.this.m_6596_();
            assert (CrafterBlockEntity.this.f_58857_ != null);
            if (!CrafterBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new PacketSyncItemStackToClient(this, CrafterBlockEntity.this.f_58858_));
            }
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot <= 8) {
                return 2;
            }
            return super.getStackLimit(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 9, (i, s) -> false)), Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 0 && i <= 8, (index, stack) -> {
        ItemStack slotStack;
        return index >= 0 && index <= 8 && this.itemHandler.isItemValid(index.intValue(), stack) && !(slotStack = this.itemHandler.getStackInSlot(index.intValue())).m_41619_() && ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack) && slotStack.m_41613_() < 2;
    })), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 0 && i <= 8, (index, stack) -> {
        ItemStack slotStack;
        return index >= 0 && index <= 8 && this.itemHandler.isItemValid(index.intValue(), stack) && !(slotStack = this.itemHandler.getStackInSlot(index.intValue())).m_41619_() && ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack) && slotStack.m_41613_() < 2;
    })), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 0 && i <= 8, (index, stack) -> {
        ItemStack slotStack;
        return index >= 0 && index <= 8 && this.itemHandler.isItemValid(index.intValue(), stack) && !(slotStack = this.itemHandler.getStackInSlot(index.intValue())).m_41619_() && ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack) && slotStack.m_41613_() < 2;
    })), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 0 && i <= 8, (index, stack) -> {
        ItemStack slotStack;
        return index >= 0 && index <= 8 && this.itemHandler.isItemValid(index.intValue(), stack) && !(slotStack = this.itemHandler.getStackInSlot(index.intValue())).m_41619_() && ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack) && slotStack.m_41613_() < 2;
    })), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 0 && i <= 8, (index, stack) -> {
        ItemStack slotStack;
        return index >= 0 && index <= 8 && this.itemHandler.isItemValid(index.intValue(), stack) && !(slotStack = this.itemHandler.getStackInSlot(index.intValue())).m_41619_() && ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack) && slotStack.m_41613_() < 2;
    })));
    public final ContainerData data;
    private int recipeChecker = 0;
    private int progress = 0;
    private int maxProgress = 80;
    public ItemStack craftingItem = ItemStack.f_41583_;
    private NonNullList<Ingredient> craftingIngredients;

    @Override
    public void setHandler(ItemStackHandler handler) {
        this.copyHandlerContents(handler);
    }

    private void copyHandlerContents(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public CrafterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CRAFTER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> CrafterBlockEntity.this.progress;
                    case 1 -> CrafterBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        CrafterBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        CrafterBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Crafter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new CrafterMenu(containerID, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.directionWrappedHandlerMap.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (Direction dir : Direction.values()) {
            if (!this.directionWrappedHandlerMap.containsKey(dir)) continue;
            this.directionWrappedHandlerMap.get(dir).invalidate();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("crafter.progress", this.progress);
        tag.m_128405_("crafter.maxProgress", this.maxProgress);
        tag.m_128405_("crafter.recipeChecker", this.recipeChecker);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("crafter.progress");
        this.maxProgress = nbt.m_128451_("crafter.maxProgress");
        this.recipeChecker = nbt.m_128451_("crafter.recipeChecker");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick() {
        ++this.recipeChecker;
        Level pLevel = this.f_58857_;
        BlockPos pPos = this.f_58858_;
        assert (pLevel != null);
        BlockState pState = pLevel.m_8055_(pPos);
        CrafterBlockEntity pBlockEntity = this;
        if (this.recipeChecker >= 20) {
            this.recipeChecker = 0;
            this.updateRecipe();
        }
        this.maxProgress = (Integer)this.m_58900_().m_61143_((Property)CrafterBlock.TIMER);
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (((Boolean)pState.m_61143_((Property)CrafterBlock.POWERED)).booleanValue()) {
            if (!pBlockEntity.craftingItem.m_41619_() && pBlockEntity.canCraft() && pBlockEntity.hasMaterial()) {
                ++pBlockEntity.progress;
                if (pBlockEntity.progress >= this.maxProgress) {
                    this.resetProgress();
                    pBlockEntity.craft();
                    CrafterBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                }
            }
        } else {
            this.resetProgress();
            CrafterBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public boolean canCraft() {
        ItemStack stack = this.itemHandler.getStackInSlot(9);
        int count = stack.m_41613_();
        boolean same = stack.m_41720_() == this.craftingItem.m_41720_();
        boolean fits = count + this.craftingItem.m_41613_() <= this.craftingItem.m_41741_();
        return stack.m_41619_() || same && fits;
    }

    public void updateRecipe() {
        CraftingContainer container = new CraftingContainer(){

            public int m_39347_() {
                return 3;
            }

            public int m_39346_() {
                return 3;
            }

            public List<ItemStack> m_280657_() {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < 9; ++i) {
                    list.add(Optional.of(CrafterBlockEntity.this.itemHandler.getStackInSlot(i)).orElse(ItemStack.f_41583_));
                }
                return list;
            }

            public int m_6643_() {
                return this.m_39347_() * this.m_39346_();
            }

            public boolean m_7983_() {
                return false;
            }

            public ItemStack m_8020_(int pSlot) {
                return this.m_280657_().get(pSlot);
            }

            public ItemStack m_7407_(int pSlot, int pAmount) {
                return ItemStack.f_41583_;
            }

            public ItemStack m_8016_(int pSlot) {
                return ItemStack.f_41583_;
            }

            public void m_6836_(int pSlot, ItemStack pStack) {
            }

            public void m_6596_() {
            }

            public boolean m_6542_(Player pPlayer) {
                return true;
            }

            public void m_6211_() {
            }

            public void m_5809_(StackedContents pHelper) {
            }
        };
        Optional recipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)container, this.f_58857_);
        if (recipe.isPresent()) {
            CraftingRecipe r = (CraftingRecipe)recipe.get();
            this.craftingItem = r.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
            this.craftingIngredients = r.m_7527_();
        } else {
            this.craftingItem = ItemStack.f_41583_.m_41777_();
        }
    }

    public void craft() {
        this.extractIngredients();
        this.itemHandler.insertItem(9, this.craftingItem.m_41777_(), false);
    }

    public void extractIngredients() {
        HashMap<Item, Integer> itemCount = this.countIngredients(this.craftingIngredients);
        for (Map.Entry<Item, Integer> entry : itemCount.entrySet()) {
            Item item = entry.getKey();
            int needs = entry.getValue();
            for (int i = 0; i < 9 && needs > 0; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_() || stack.m_41720_() != item) continue;
                ItemStack extractedStack = this.itemHandler.extractItem(i, 1, false);
                --needs;
                if (extractedStack.m_41619_() || extractedStack.getCraftingRemainingItem().m_41619_() || this.tryInserting(extractedStack.getCraftingRemainingItem())) continue;
                Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)extractedStack.getCraftingRemainingItem());
            }
        }
    }

    private boolean tryInserting(ItemStack stack) {
        for (int i = 0; i < 8; ++i) {
            if (!this.itemHandler.insertItem(i, stack, true).m_41619_()) continue;
            this.itemHandler.insertItem(i, stack, false);
            return true;
        }
        return false;
    }

    public boolean hasMaterial() {
        return this.hasIngredientsForRecipe();
    }

    private boolean checkContents(HashMap<Item, Integer> itemCount) {
        for (int i = 0; i < 8 && itemCount.size() > 0; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!itemCount.containsKey(stack.m_41720_())) continue;
            int remaining = itemCount.get(stack.m_41720_()) - stack.m_41613_();
            if (remaining > 0) {
                itemCount.put(stack.m_41720_(), remaining);
                continue;
            }
            itemCount.remove(stack.m_41720_());
        }
        return itemCount.size() == 0;
    }

    private HashMap<Item, Integer> countIngredients(NonNullList<Ingredient> ingredients) {
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.m_43908_()) {
                map.put(stack.m_41720_(), map.getOrDefault(stack.m_41720_(), 0) + stack.m_41613_());
            }
        }
        return map;
    }

    private boolean hasIngredientsForRecipe() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_() || stackInSlot.m_41613_() >= 2) continue;
            return false;
        }
        return true;
    }
}

