/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock;
import com.benbenlaw.opolisutilities.block.custom.BlockPlacerBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.networking.ModMessages;
import com.benbenlaw.opolisutilities.networking.packets.PacketSyncItemStackToClient;
import com.benbenlaw.opolisutilities.screen.BlockPlacerMenu;
import com.benbenlaw.opolisutilities.util.ModTags;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.benbenlaw.opolisutilities.util.inventory.WrappedHandler;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPlacerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BlockPlacerBlockEntity.this.m_6596_();
            assert (BlockPlacerBlockEntity.this.f_58857_ != null);
            if (!BlockPlacerBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new PacketSyncItemStackToClient(this, BlockPlacerBlockEntity.this.f_58858_));
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_BLOCK_PLACER))), Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_BLOCK_PLACER))), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_BLOCK_PLACER))), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_BLOCK_PLACER))), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_BLOCK_PLACER))), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_BLOCK_PLACER))));
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BlockPlacerBlockEntity.this.progress;
                case 1 -> BlockPlacerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BlockPlacerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    BlockPlacerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private int progress = 0;
    private int maxProgress = 80;

    @Override
    public void setHandler(ItemStackHandler handler) {
        this.copyHandlerContents(handler);
    }

    private void copyHandlerContents(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public BlockPlacerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BLOCK_PLACER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Block Placer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, @NotNull Inventory inventory, @NotNull Player player) {
        return new BlockPlacerMenu(containerID, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.directionWrappedHandlerMap.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (Direction dir : Direction.values()) {
            if (!this.directionWrappedHandlerMap.containsKey(dir)) continue;
            this.directionWrappedHandlerMap.get(dir).invalidate();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("block_placer.progress", this.progress);
        tag.m_128405_("block_placer.maxProgress", this.maxProgress);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("block_placer.progress");
        this.maxProgress = nbt.m_128451_("block_placer.maxProgress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick() {
        Level pLevel = this.f_58857_;
        BlockPos pPos = this.f_58858_;
        assert (pLevel != null);
        BlockPlacerBlockEntity pBlockEntity = this;
        BlockState blockState = pLevel.m_8055_(pPos);
        this.maxProgress = (Integer)this.m_58900_().m_61143_((Property)BlockPlacerBlock.TIMER);
        if (!blockState.m_60795_() && !blockState.m_60713_(Blocks.f_50626_) && pLevel instanceof ServerLevel && ((Boolean)blockState.m_61143_((Property)BlockBreakerBlock.POWERED)).booleanValue()) {
            ItemStack itemStackInSlot = pBlockEntity.getItemStackHandler().getStackInSlot(0);
            Direction direction = (Direction)pLevel.m_8055_(pPos).m_61143_((Property)BlockPlacerBlock.FACING);
            BlockPos placeHere = pPos.m_121945_(direction);
            if (!itemStackInSlot.m_41619_() && blockState.m_61138_((Property)BlockBreakerBlock.FACING) && this.f_58857_.m_8055_(placeHere).m_60795_()) {
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.progress = 0;
                    Item item = itemStackInSlot.m_41720_();
                    if (item instanceof BlockItem) {
                        BlockState itemToBlockState = ((BlockItem)itemStackInSlot.m_41720_().m_5456_()).m_40614_().m_49966_();
                        SoundType blockSounds = itemToBlockState.m_60734_().getSoundType(itemToBlockState.m_60734_().m_49966_(), (LevelReader)this.f_58857_, pPos, null);
                        if (!itemToBlockState.m_60795_()) {
                            if (itemToBlockState.m_60734_() instanceof BushBlock || itemToBlockState.m_60734_() instanceof SaplingBlock || itemToBlockState.m_60734_() instanceof RedStoneWireBlock || itemToBlockState.m_60734_().m_49966_().m_204336_(ModTags.Blocks.BANNED_IN_BLOCK_PLACER)) {
                                if (this.f_58857_.m_8055_(placeHere.m_7495_()).m_204336_(BlockTags.f_144274_)) {
                                    this.itemHandler.getStackInSlot(0).m_41774_(1);
                                    this.f_58857_.m_46597_(placeHere, itemToBlockState);
                                }
                            } else {
                                this.itemHandler.getStackInSlot(0).m_41774_(1);
                                pLevel.m_5594_(null, pPos, blockSounds.m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                this.f_58857_.m_46597_(placeHere, itemToBlockState);
                            }
                        }
                    }
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            ModMessages.sendToClients(new PacketSyncItemStackToClient(this.itemHandler, this.f_58858_));
        }
    }
}

