/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.forge;

import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.cristellib.CristelLib;
import net.cristellib.CristelLibRegistry;
import net.cristellib.StructureConfig;
import net.cristellib.api.CristelLibAPI;
import net.cristellib.data.ReadData;
import net.cristellib.forge.ModLoadingUtilImpl;
import net.cristellib.forge.extraapiutil.APIFinder;
import net.cristellib.util.Platform;
import net.cristellib.util.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PathPackResources;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class CristelLibExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static PackResources registerBuiltinResourcePack(ResourceLocation id, Component displayName, String modid) {
        Path path = CristelLibExpectPlatformImpl.getResourceDirectory(modid, id.m_135815_());
        if (path != null) {
            return new PathPackResources(displayName.getString(), path, true);
        }
        return null;
    }

    @Nullable
    public static Path getResourceDirectory(String modId, String subPath) {
        ModFile file;
        ModList modList = ModList.get();
        if (modList == null) {
            ModInfo info = ModLoadingUtilImpl.getPreLoadedModInfo(modId);
            if (info == null) {
                CristelLib.LOGGER.warn("Mod info for modId:" + modId + " is null");
                return null;
            }
            file = info.getOwningFile().getFile();
        } else {
            ModContainer container = modList.getModContainerById(modId).orElse(null);
            if (container == null) {
                CristelLib.LOGGER.warn("Mod container for modId:" + modId + " is null");
                return null;
            }
            file = container.getModInfo().getOwningFile().getFile();
        }
        Path path = file.findResource(new String[]{subPath});
        if (path == null) {
            CristelLib.LOGGER.warn("Path for subPath: " + subPath + " in modId: " + modId + " is null");
        }
        return path;
    }

    public static Map<String, Set<StructureConfig>> getConfigs(CristelLibRegistry registry) {
        HashMap<String, Set<StructureConfig>> configs = new HashMap<String, Set<StructureConfig>>();
        List<Pair<List<String>, CristelLibAPI>> apis = APIFinder.scanForAPIs();
        for (Pair<List<String>, CristelLibAPI> apiPair : apis) {
            CristelLibAPI api = (CristelLibAPI)apiPair.getSecond();
            List modIds = (List)apiPair.getFirst();
            HashSet<StructureConfig> set = new HashSet<StructureConfig>();
            api.registerConfigs(set);
            configs.put((String)modIds.get(0), set);
            api.registerStructureSets(registry);
        }
        Util.addAll(configs, CristelLibExpectPlatformImpl.data(registry));
        return configs;
    }

    public static Map<String, Set<StructureConfig>> data(CristelLibRegistry registry) {
        HashMap<String, Set<StructureConfig>> modidAndConfigs = new HashMap<String, Set<StructureConfig>>();
        for (String modid : CristelLibExpectPlatformImpl.getModIds()) {
            ReadData.getBuiltInPacks(modid);
            ReadData.copyFile(modid);
            ReadData.getStructureConfigs(modid, modidAndConfigs, registry);
        }
        return modidAndConfigs;
    }

    public static List<String> getModIds() {
        ModList modList = ModList.get();
        ArrayList<String> modIds = new ArrayList<String>();
        if (modList != null) {
            for (IModInfo modInfo : modList.getMods()) {
                modIds.add(modInfo.getModId());
            }
        } else {
            for (IModInfo modInfo : LoadingModList.get().getMods()) {
                modIds.add(modInfo.getModId());
            }
        }
        return modIds;
    }

    public static List<Path> getRootPaths(String modId) {
        ModFile file;
        ModList modList = ModList.get();
        ArrayList<Path> paths = new ArrayList<Path>();
        if (modList == null) {
            ModInfo info = ModLoadingUtilImpl.getPreLoadedModInfo(modId);
            if (info == null) {
                return paths;
            }
            file = info.getOwningFile().getFile();
        } else {
            ModContainer container = modList.getModContainerById(modId).orElse(null);
            if (container == null) {
                return paths;
            }
            file = container.getModInfo().getOwningFile().getFile();
        }
        return Collections.singletonList(file.getSecureJar().getRootPath());
    }

    public static Platform getPlatform() {
        return Platform.FORGE;
    }
}

