/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.player;

import de.markusbordihn.adaptiveperformancetweakscore.CoreConstants;
import de.markusbordihn.adaptiveperformancetweakscore.message.WarnMessages;
import de.markusbordihn.adaptiveperformancetweaksplayer.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaksplayer.player.PlayerValidation;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerProtection {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Player)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static Set<PlayerValidation> playerValidationList = ConcurrentHashMap.newKeySet();
    private static short ticker = 0;

    protected PlayerProtection() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        playerValidationList = ConcurrentHashMap.newKeySet();
        if (CoreConstants.LOGIN_PROTECTION_LOADED) {
            log.warn(() -> WarnMessages.conflictingFeaturesModWarning((String)"Login Protection", (String)"protects the user during the login"));
        }
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(ServerStartingEvent event) {
        if (Boolean.TRUE.equals(PlayerProtection.COMMON.protectPlayerDuringLogin.get())) {
            log.info("Player will be protected during login for max. of {} secs.", PlayerProtection.COMMON.playerLoginValidationTimeout.get());
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (Boolean.FALSE.equals(PlayerProtection.COMMON.protectPlayerDuringLogin.get())) {
            return;
        }
        String username = event.getEntity().m_7755_().getString();
        if (!username.isEmpty()) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(username);
            if (player == null) {
                log.warn("Unable to match username {} to server player!", (Object)username);
                return;
            }
            if (Boolean.TRUE.equals(PlayerProtection.COMMON.protectPlayerDuringLoginLogging.get())) {
                log.info("Player {} {} logged in and will be protected for {} secs.", (Object)username, (Object)event.getEntity(), PlayerProtection.COMMON.playerLoginValidationTimeout.get());
                player.m_6842_(true);
                player.m_20331_(true);
                player.m_5634_(1.0f);
            } else {
                log.debug("Player {} {} logged in.", (Object)username, (Object)event.getEntity());
            }
            if (Boolean.TRUE.equals(PlayerProtection.COMMON.enableChildPlayerProtection.get()) && ((List)PlayerProtection.COMMON.childPlayerProtectionList.get()).contains(username)) {
                log.info("Child Player {} logged-in and game settings adjusted for a better player experience.", (Object)username);
                if (player.f_36078_ < 50) {
                    player.m_9174_(++player.f_36078_);
                }
                player.m_5634_(10.0f);
                player.m_6842_(true);
                player.m_20331_(true);
            }
            playerValidationList.add(new PlayerValidation(player));
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (Boolean.FALSE.equals(PlayerProtection.COMMON.protectPlayerDuringLogin.get())) {
            return;
        }
        String username = event.getEntity().m_7755_().getString();
        if (!username.isEmpty()) {
            log.debug("Player {} logged out.", (Object)event.getEntity());
            PlayerProtection.removePlayer(username);
        }
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        block9: {
            block8: {
                if (event.phase == TickEvent.Phase.END) break block8;
                short s = ticker;
                ticker = (short)(s + 1);
                if (s >= 40) break block9;
            }
            return;
        }
        if (!playerValidationList.isEmpty()) {
            try {
                for (PlayerValidation playerValidation : playerValidationList) {
                    String username = playerValidation.getUsername();
                    if (playerValidation.hasPlayerMoved()) {
                        long validationTimeInSecs = TimeUnit.MILLISECONDS.toSeconds(playerValidation.getValidationTimeElapsed());
                        log.info("{} {} was successful validated after {} secs.", (Object)(Boolean.TRUE.equals(PlayerProtection.COMMON.protectPlayerDuringLoginLogging.get()) ? "Protected Player" : "Player"), (Object)username, (Object)validationTimeInSecs);
                        PlayerProtection.addPlayer(username);
                        continue;
                    }
                    if (playerValidation.getValidationTimeElapsed() < TimeUnit.SECONDS.toMillis(((Integer)PlayerProtection.COMMON.playerLoginValidationTimeout.get()).intValue())) continue;
                    log.warn("User validation for {} timed out after {} secs.", (Object)username, PlayerProtection.COMMON.playerLoginValidationTimeout.get());
                    PlayerProtection.addPlayer(username);
                }
            }
            catch (ConcurrentModificationException error) {
                log.error("Unexpected error during user validation. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues", (Object)error);
            }
        }
        ticker = 0;
    }

    private static void addPlayer(String username) {
        try {
            for (PlayerValidation playerValidation : playerValidationList) {
                if (!username.equals(playerValidation.getUsername())) continue;
                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(username);
                if (player == null) {
                    log.warn("Unable to match username {} to server player!", (Object)username);
                    return;
                }
                log.debug("Found player {} with player validation {}", (Object)player, (Object)playerValidation);
                if (Boolean.TRUE.equals(PlayerProtection.COMMON.protectPlayerDuringLogin.get()) && (player.m_20145_() || player.m_20147_())) {
                    if (Boolean.TRUE.equals(PlayerProtection.COMMON.enableChildPlayerProtection.get()) && ((List)PlayerProtection.COMMON.childPlayerProtectionList.get()).contains(username)) {
                        if (player.m_20145_() && Boolean.FALSE.equals(PlayerProtection.COMMON.childPlayerInvisible.get())) {
                            log.info("Removing player protection invisible from child player {}!", (Object)username);
                            player.m_6842_(false);
                        }
                        if (player.m_20147_() && Boolean.FALSE.equals(PlayerProtection.COMMON.childPlayerInvulnerable.get())) {
                            log.info("Removing player protection invulnerable from child player {}!", (Object)username);
                            player.m_20331_(false);
                        }
                    } else {
                        if (player.m_20145_()) {
                            log.info("Removing player protection invisible from player {}!", (Object)username);
                            player.m_6842_(false);
                        }
                        if (player.m_20147_()) {
                            log.info("Removing player protection invulnerable from player {}!", (Object)username);
                            player.m_20331_(false);
                        }
                    }
                }
                playerValidationList.remove(playerValidation);
                break;
            }
        }
        catch (ConcurrentModificationException error) {
            log.error("Unexpected error during adding player. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues", (Object)error);
        }
        log.debug("Added player {}", (Object)username);
    }

    private static void removePlayer(String username) {
        try {
            for (PlayerValidation playerValidation : playerValidationList) {
                if (!username.equals(playerValidation.getUsername())) continue;
                playerValidationList.remove(playerValidation);
                break;
            }
        }
        catch (ConcurrentModificationException error) {
            log.error("Unexpected error during removing player. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues", (Object)error);
        }
        log.debug("Remove player {}", (Object)username);
    }
}

