/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.player;

import de.markusbordihn.adaptiveperformancetweaksplayer.config.CommonConfig;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerDamageManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Player)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;

    protected PlayerDamageManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if ((Integer)PlayerDamageManager.COMMON.childPlayerHurtDamageReduction.get() > 0) {
            log.info("Child player hurt damage will be reduced by {}% for {}", PlayerDamageManager.COMMON.childPlayerHurtDamageReduction.get(), PlayerDamageManager.COMMON.childPlayerProtectionList.get());
        } else {
            log.warn("Child player hurt damage will not be reduced!");
        }
        if ((Integer)PlayerDamageManager.COMMON.childPlayerAttackDamageIncrease.get() > 0) {
            log.info("Child player attack damage will be increased by {}% for {}", PlayerDamageManager.COMMON.childPlayerAttackDamageIncrease.get(), PlayerDamageManager.COMMON.childPlayerProtectionList.get());
        } else {
            log.warn("Child player attack damage will not be increased!");
        }
    }

    @SubscribeEvent
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if ((Integer)PlayerDamageManager.COMMON.childPlayerHurtDamageReduction.get() > 0 && !((List)PlayerDamageManager.COMMON.childPlayerProtectionList.get()).isEmpty() && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (((List)PlayerDamageManager.COMMON.childPlayerProtectionList.get()).contains(serverPlayer.m_7755_().getString())) {
                float hurtDamage = event.getAmount();
                if ((Integer)PlayerDamageManager.COMMON.childPlayerHurtDamageReduction.get() == 100) {
                    log.debug("Ignore {} hurt damage for {}", (Object)Float.valueOf(hurtDamage), (Object)serverPlayer);
                    event.setCanceled(true);
                } else {
                    float reducedHurtDamage = hurtDamage - hurtDamage / (100.0f / (float)((Integer)PlayerDamageManager.COMMON.childPlayerHurtDamageReduction.get()).intValue());
                    log.debug("Reduce hurt damage for {} from {} to {}", (Object)serverPlayer, (Object)Float.valueOf(hurtDamage), (Object)Float.valueOf(reducedHurtDamage));
                    event.setAmount(reducedHurtDamage);
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingDamageEvent(LivingDamageEvent event) {
        Entity entity;
        if ((Integer)PlayerDamageManager.COMMON.childPlayerAttackDamageIncrease.get() > 0 && !((List)PlayerDamageManager.COMMON.childPlayerProtectionList.get()).isEmpty() && event.getSource() != null && (entity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (((List)PlayerDamageManager.COMMON.childPlayerProtectionList.get()).contains(serverPlayer.m_7755_().getString())) {
                float attackDamage = event.getAmount();
                float increasedAttackDamage = attackDamage + attackDamage / (100.0f / (float)((Integer)PlayerDamageManager.COMMON.childPlayerAttackDamageIncrease.get()).intValue());
                log.debug("Increase attack damage for {} from {} to {}", (Object)serverPlayer, (Object)Float.valueOf(attackDamage), (Object)Float.valueOf(increasedAttackDamage));
                event.setAmount(increasedAttackDamage);
            }
        }
    }
}

