/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.config;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private CommonConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Player)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} common config ...", (Object)"Adaptive Performance Tweaks: Player");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks/player.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue optimizePlayerLogin;
        public final ForgeConfigSpec.IntValue playerLoginValidationTimeout;
        public final ForgeConfigSpec.BooleanValue protectPlayerDuringLogin;
        public final ForgeConfigSpec.BooleanValue protectPlayerDuringLoginLogging;
        public final ForgeConfigSpec.BooleanValue enableChildPlayerProtection;
        public final ForgeConfigSpec.ConfigValue<List<String>> childPlayerProtectionList;
        public final ForgeConfigSpec.BooleanValue childPlayerInvisible;
        public final ForgeConfigSpec.BooleanValue childPlayerInvulnerable;
        public final ForgeConfigSpec.IntValue childPlayerHurtDamageReduction;
        public final ForgeConfigSpec.IntValue childPlayerAttackDamageIncrease;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Player");
            builder.push("Player Login");
            this.optimizePlayerLogin = builder.comment("Enable/Disable optimization which are happening during player login.").define("optimizePlayerLogin", true);
            this.playerLoginValidationTimeout = builder.comment("Timeout in seconds for the player validation.").defineInRange("playerLoginValidationTimeout", 90, 16, 300);
            builder.pop();
            builder.push("Player Protection");
            this.protectPlayerDuringLogin = builder.comment("Protect player during login within the validation timeout.").define("protectPlayerDuringLogin", true);
            this.protectPlayerDuringLoginLogging = builder.comment("Enable/Disable player protection logging with login time.").define("protectPlayerDuringLoginLogging", true);
            builder.pop();
            builder.push("Child Player Protection");
            this.enableChildPlayerProtection = builder.comment("Protect child player and give them a more enjoyable play experience.").define("enableChildPlayerProtection", true);
            this.childPlayerProtectionList = builder.comment("List of child player username for the child player protection.").define("childPlayerProtectionList", new ArrayList<String>(List.of("")));
            this.childPlayerInvisible = builder.comment("Sets the child player to invisible.").define("childPlayerInvisible", true);
            this.childPlayerInvulnerable = builder.comment("Sets the child player to invulnerable.").define("childPlayerInvulnerable", false);
            this.childPlayerHurtDamageReduction = builder.comment("Reduces the hurt damage to a child player by the amount of % (0 = disabled).").defineInRange("childPlayerHurtDamageReduction", 50, 0, 100);
            this.childPlayerAttackDamageIncrease = builder.comment("Increase the attack damage of a child player by the amount of % (0 = disabled).").defineInRange("childPlayerAttackDamageIncrease", 50, 0, 1000);
            builder.pop();
        }
    }
}

