/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant;

import com.google.common.base.Preconditions;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.world.level.block.state.BlockBehaviour;

public enum ReactorVariant implements IMultiblockReactorVariant
{
    Basic(Builder.create(5).setTranslationKey("variant.bigreactors.reactor.basic").setBlockPropertiesFixer(bp -> bp.m_60913_(3.0f, 6.0f)).setPartEnergyCapacity(10000).setEnergyGenerationEfficiency(0.8f).setMaxEnergyExtractionRate(50000.0).setMaxChargerRate(250.0).setRadiationAttenuation(0.9f).setResidualRadiationAttenuation(0.1f).setSolidFuelConversionEfficiency(1.0f)),
    Reinforced(Builder.create(1000).setTranslationKey("variant.bigreactors.reactor.reinforced").setBlockPropertiesFixer(bp -> bp.m_60913_(6.0f, 6.0f)).setPartEnergyCapacity(30000).setEnergyGenerationEfficiency(1.0f).setMaxEnergyExtractionRate(5.0E7).setMaxChargerRate(25000.0).setRadiationAttenuation(0.75f).setResidualRadiationAttenuation(0.15f).setPartFluidCapacity(1000).setMaxFluidCapacity(200000).setVaporGenerationEfficiency(0.85f).setSolidFuelConversionEfficiency(1.0f).setFluidFuelConversionEfficiency(1.0f));

    private final String _translationKey;
    private final int _maxX;
    private final int _maxY;
    private final int _maxZ;
    private final int _minParts;
    private final int _partEnergyCapacity;
    private final float _energyGenerationEfficiency;
    private final WideAmount _maxEnergyExtractionRate;
    private final double _maxChargerRate;
    private final int _partFluidCapacity;
    private final int _maxFluidCapacity;
    private final float _vaporGenerationEfficiency;
    private final float _radiationAttenuation;
    private final float _residualRadiationAttenuation;
    private final float _solidFuelConversionEfficiency;
    private final float _fluidFuelConversionEfficiency;
    private final Function<BlockBehaviour.Properties, BlockBehaviour.Properties> _blockPropertiesFixer;

    public int getId() {
        return this.ordinal();
    }

    public String getName() {
        return CodeHelper.neutralLowercase((String)this.name());
    }

    public String getTranslationKey() {
        return this._translationKey;
    }

    public BlockBehaviour.Properties getBlockProperties() {
        return this._blockPropertiesFixer.apply(this.getDefaultBlockProperties());
    }

    public int getMaximumXSize() {
        return Math.min((Integer)Config.COMMON.reactor.maxReactorSize.get(), this._maxX);
    }

    public int getMaximumZSize() {
        return Math.min((Integer)Config.COMMON.reactor.maxReactorSize.get(), this._maxZ);
    }

    public int getMaximumYSize() {
        return Math.min((Integer)Config.COMMON.reactor.maxReactorHeight.get(), this._maxY);
    }

    public int getMinimumPartsCount() {
        return this._minParts;
    }

    @Override
    public int getPartEnergyCapacity() {
        return this._partEnergyCapacity;
    }

    @Override
    public float getEnergyGenerationEfficiency() {
        return this._energyGenerationEfficiency;
    }

    @Override
    public WideAmount getMaxEnergyExtractionRate() {
        return this._maxEnergyExtractionRate;
    }

    @Override
    public double getChargerMaxRate() {
        return this._maxChargerRate;
    }

    @Override
    public float getRadiationAttenuation() {
        return this._radiationAttenuation;
    }

    @Override
    public float getResidualRadiationAttenuation() {
        return this._residualRadiationAttenuation;
    }

    @Override
    public float getSolidFuelConversionEfficiency() {
        return this._solidFuelConversionEfficiency;
    }

    @Override
    public float getFluidFuelConversionEfficiency() {
        return this._fluidFuelConversionEfficiency;
    }

    @Override
    public int getPartFluidCapacity() {
        return this._partFluidCapacity;
    }

    @Override
    public int getMaxFluidCapacity() {
        return this._maxFluidCapacity;
    }

    @Override
    public float getVaporGenerationEfficiency() {
        return this._vaporGenerationEfficiency;
    }

    private ReactorVariant(Builder builder) {
        this._translationKey = builder._translationKey;
        this._blockPropertiesFixer = null != builder._blockPropertiesFixer ? builder._blockPropertiesFixer : bp -> bp;
        this._maxX = builder._maxX;
        this._maxY = builder._maxY;
        this._maxZ = builder._maxZ;
        this._minParts = builder._minParts;
        this._partEnergyCapacity = builder._partEnergyCapacity;
        this._energyGenerationEfficiency = builder._energyGenerationEfficiency;
        this._maxEnergyExtractionRate = WideAmount.asImmutable((double)builder._maxEnergyExtractionRate);
        this._maxChargerRate = builder._maxChargerRate;
        this._radiationAttenuation = builder._radiationAttenuation;
        this._residualRadiationAttenuation = builder._residualRadiationAttenuation;
        this._solidFuelConversionEfficiency = builder._solidFuelConversionEfficiency;
        this._fluidFuelConversionEfficiency = builder._fluidFuelConversionEfficiency;
        this._partFluidCapacity = builder._partFluidCapacity;
        this._maxFluidCapacity = builder._maxFluidCapacity;
        this._vaporGenerationEfficiency = builder._vaporGenerationEfficiency;
    }

    private static final class Builder {
        private String _translationKey = "";
        private final int _maxX;
        private final int _maxY;
        private final int _maxZ;
        private int _minParts;
        private int _partEnergyCapacity;
        private float _energyGenerationEfficiency;
        private double _maxEnergyExtractionRate;
        private double _maxChargerRate;
        private int _partFluidCapacity;
        private int _maxFluidCapacity;
        private float _vaporGenerationEfficiency;
        private float _radiationAttenuation;
        private float _residualRadiationAttenuation;
        private float _solidFuelConversionEfficiency;
        private float _fluidFuelConversionEfficiency;
        private Function<BlockBehaviour.Properties, BlockBehaviour.Properties> _blockPropertiesFixer;

        public static Builder create(int maxSize) {
            return new Builder(maxSize, maxSize, maxSize);
        }

        public static Builder create(int maxWidth, int maxHeight) {
            return new Builder(maxWidth, maxHeight, maxWidth);
        }

        public static Builder create(int maxX, int maxY, int maxZ) {
            return new Builder(maxX, maxY, maxZ);
        }

        public Builder setTranslationKey(String key) {
            this._translationKey = Objects.requireNonNull(key);
            return this;
        }

        public Builder setMinimumPartsCount(int count) {
            Preconditions.checkArgument((count >= 26 ? 1 : 0) != 0);
            this._minParts = count;
            return this;
        }

        public Builder setPartEnergyCapacity(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0);
            this._partEnergyCapacity = capacity;
            return this;
        }

        public Builder setEnergyGenerationEfficiency(float efficiency) {
            Preconditions.checkArgument((efficiency > 0.0f && efficiency <= 1.0f ? 1 : 0) != 0);
            this._energyGenerationEfficiency = efficiency;
            return this;
        }

        public Builder setMaxEnergyExtractionRate(double rate) {
            Preconditions.checkArgument((rate > 0.0 ? 1 : 0) != 0);
            this._maxEnergyExtractionRate = rate;
            return this;
        }

        public Builder setMaxChargerRate(double rate) {
            Preconditions.checkArgument((rate > 0.0 ? 1 : 0) != 0);
            this._maxChargerRate = rate;
            return this;
        }

        public Builder setRadiationAttenuation(float attenuation) {
            Preconditions.checkArgument((attenuation > 0.0f && attenuation < 1.0f ? 1 : 0) != 0);
            this._radiationAttenuation = attenuation;
            return this;
        }

        public Builder setResidualRadiationAttenuation(float attenuation) {
            Preconditions.checkArgument((attenuation > 0.0f && attenuation < 1.0f ? 1 : 0) != 0);
            this._residualRadiationAttenuation = attenuation;
            return this;
        }

        public Builder setSolidFuelConversionEfficiency(float efficiency) {
            Preconditions.checkArgument((efficiency > 0.0f && efficiency <= 1.0f ? 1 : 0) != 0);
            this._solidFuelConversionEfficiency = efficiency;
            return this;
        }

        public Builder setFluidFuelConversionEfficiency(float efficiency) {
            Preconditions.checkArgument((efficiency > 0.0f && efficiency <= 1.0f ? 1 : 0) != 0);
            this._fluidFuelConversionEfficiency = efficiency;
            return this;
        }

        public Builder setPartFluidCapacity(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0);
            this._partFluidCapacity = capacity;
            return this;
        }

        public Builder setMaxFluidCapacity(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0);
            this._maxFluidCapacity = capacity;
            return this;
        }

        public Builder setVaporGenerationEfficiency(float efficiency) {
            Preconditions.checkArgument((efficiency > 0.0f && efficiency < 1.0f ? 1 : 0) != 0);
            this._vaporGenerationEfficiency = efficiency;
            return this;
        }

        public Builder setBlockPropertiesFixer(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> fixer) {
            this._blockPropertiesFixer = fixer;
            return this;
        }

        private Builder(int maxX, int maxY, int maxZ) {
            this._maxX = maxX;
            this._maxY = maxY;
            this._maxZ = maxZ;
            this._minParts = 27;
            this._blockPropertiesFixer = null;
        }
    }
}

