/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.variant;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.variant.IMultiblockEnergizerVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import net.minecraft.world.level.block.state.BlockBehaviour;

public enum EnergizerVariant implements IMultiblockEnergizerVariant
{
    INSTANCE;

    public static final int MULTIBLOCK_MAX_SIZE = 32;
    private static final WideAmount CAPACITY_PER_BLOCK;

    @Override
    public WideAmount getStorageCapacityPerBlock() {
        return CAPACITY_PER_BLOCK;
    }

    @Override
    public int getPartEnergyCapacity() {
        return 0;
    }

    @Override
    public float getEnergyGenerationEfficiency() {
        return 1.0f;
    }

    @Override
    public WideAmount getMaxEnergyExtractionRate() {
        return WideAmount.MAX_VALUE;
    }

    @Override
    public double getChargerMaxRate() {
        return this.getMaxEnergyExtractionRate().doubleValue();
    }

    public int getMaximumXSize() {
        return Math.min((Integer)Config.COMMON.energizer.maxEnergizerSize.get(), 32);
    }

    public int getMaximumZSize() {
        return this.getMaximumXSize();
    }

    public int getMaximumYSize() {
        return Math.min((Integer)Config.COMMON.energizer.maxEnergizerHeight.get(), 32);
    }

    public int getMinimumPartsCount() {
        return 26;
    }

    public int getId() {
        return this.ordinal();
    }

    public String getName() {
        return CodeHelper.neutralLowercase((String)this.name());
    }

    public String getTranslationKey() {
        return "variant.bigreactors.energizer";
    }

    public BlockBehaviour.Properties getBlockProperties() {
        return this.getDefaultBlockProperties();
    }

    static {
        CAPACITY_PER_BLOCK = WideAmount.MAX_VALUE.divide(27000L).toImmutable();
    }
}

