/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.client;

import it.zerono.mods.extremereactors.datagen.client.AbstractMultiblockModelsDataProvider;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ParentModel;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ReactorModelsDataProvider
extends AbstractMultiblockModelsDataProvider {
    public ReactorModelsDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ResourceLocationBuilder modLocationRoot) {
        super("Extreme Reactors 2 Reactor block states and models", output, lookupProvider, modLocationRoot);
    }

    public void provideData() {
        String variant = "reactor/basic";
        this.assembledPlatingModel(variant);
        this.multiblockFrame((Supplier)Content.Blocks.REACTOR_CASING_BASIC, "casing", variant);
        this.multiblockGlass((Supplier)Content.Blocks.REACTOR_GLASS_BASIC, "glass", variant);
        this.controller(Content.Blocks.REACTOR_CONTROLLER_BASIC, variant);
        this.controlRod((Supplier)Content.Blocks.REACTOR_CONTROLROD_BASIC, variant);
        this.fuelRod((Supplier)Content.Blocks.REACTOR_FUELROD_BASIC, variant);
        this.accessPort((Supplier)Content.Blocks.REACTOR_SOLID_ACCESSPORT_BASIC, "solid", variant);
        this.redstonePort(Content.Blocks.REACTOR_REDSTONEPORT_BASIC, variant);
        this.genericPart(Content.Blocks.REACTOR_POWERTAP_FE_ACTIVE_BASIC, "powertap_fe_active", variant, new String[0]);
        this.genericPart(Content.Blocks.REACTOR_POWERTAP_FE_PASSIVE_BASIC, "powertap_fe_passive", variant, new String[0]);
        this.genericPart(Content.Blocks.REACTOR_CHARGINGPORT_FE_BASIC, "charging", variant, new String[0]);
        variant = "reactor/reinforced";
        this.assembledPlatingModel(variant);
        this.multiblockFrame((Supplier)Content.Blocks.REACTOR_CASING_REINFORCED, "casing", variant);
        this.multiblockGlass((Supplier)Content.Blocks.REACTOR_GLASS_REINFORCED, "glass", variant);
        this.controller(Content.Blocks.REACTOR_CONTROLLER_REINFORCED, variant);
        this.controlRod((Supplier)Content.Blocks.REACTOR_CONTROLROD_REINFORCED, variant);
        this.fuelRod((Supplier)Content.Blocks.REACTOR_FUELROD_REINFORCED, variant);
        this.accessPort((Supplier)Content.Blocks.REACTOR_SOLID_ACCESSPORT_REINFORCED, "solid", variant);
        this.accessPort((Supplier)Content.Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED, "fluid", variant);
        this.redstonePort(Content.Blocks.REACTOR_REDSTONEPORT_REINFORCED, variant);
        this.genericPart(Content.Blocks.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, "powertap_fe_active", variant, new String[0]);
        this.genericPart(Content.Blocks.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED, "powertap_fe_passive", variant, new String[0]);
        this.fluidPort(Content.Blocks.REACTOR_FLUIDTPORT_FORGE_ACTIVE_REINFORCED, "fluidport_forge_active", variant);
        this.fluidPort(Content.Blocks.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED, "fluidport_forge_passive", variant);
        this.fluidPort(Content.Blocks.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED, "fluidport_mekanism_passive", variant);
        this.genericPart(Content.Blocks.REACTOR_CREATIVE_WATER_GENERATOR_REINFORCED, "creative_water_generator", variant, new String[0]);
        this.computerPort((Supplier<? extends Block>)Content.Blocks.REACTOR_COMPUTERPORT_REINFORCED, variant);
        this.genericPart(Content.Blocks.REACTOR_CHARGINGPORT_FE_REINFORCED, "charging", variant, new String[0]);
    }

    private <B extends Block> void controlRod(Supplier<B> block, String subFolder) {
        this.genericPart(block, "controlrod", subFolder, new String[0]);
    }

    private <B extends Block> void fuelRod(Supplier<B> block, String subFolder) {
        ResourceLocationBuilder idBuilder = this.blocksRoot().appendPath(new String[]{subFolder}).append("fuelrod");
        ParentModel parent = ParentModel.of((ResourceLocation)this.reactorRoot().buildWithSuffix("fuel_rod"), (String[])new String[]{"cap", "side", "particle"});
        ResourceLocation model = this.models().model(idBuilder.build()).delegateFor(block).parent(parent).texture("cap", idBuilder.buildWithSuffix("_cap")).texture("side", idBuilder.buildWithSuffix("_vertical")).texture("particle", idBuilder.buildWithSuffix("_vertical")).build();
        this.axisAligned(block, model);
    }

    private <B extends Block> void accessPort(Supplier<B> block, String subType, String subFolder) {
        String name = "accessport_" + subType;
        this.genericPart(block, name + "_in", subFolder, new String[0]);
        this.genericPartModel(name + "_in_connected", subFolder);
        this.genericPartModel(name + "_out", subFolder);
        this.genericPartModel(name + "_out_connected", subFolder);
    }
}

