/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import mekanism.common.config.value.CachedValue;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekanismPickaxe
extends PickaxeItem
implements IHasRepairType,
IAttributeRefresher {
    private final MaterialCreator material;
    private final AttributeCache attributeCache;

    public ItemMekanismPickaxe(MaterialCreator material, Item.Properties properties) {
        super((Tier)material, (int)material.getPickaxeDamage(), material.getPickaxeAtkSpeed(), properties);
        this.material = material;
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.attackDamage, material.pickaxeDamage, material.pickaxeAtkSpeed});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    public float m_41008_() {
        return this.material.getPickaxeDamage() + this.m_43314_().m_6631_();
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        return super.m_8102_(stack, state) == 1.0f ? 1.0f : this.m_43314_().m_6624_();
    }

    @Override
    @NotNull
    public Ingredient getRepairMaterial() {
        return this.m_43314_().m_6282_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.m_43314_().m_6609_();
    }

    public boolean m_41465_() {
        return this.m_43314_().m_6609_() > 0;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? (Multimap)this.attributeCache.get() : ImmutableMultimap.of();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.m_41008_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.material.getPickaxeAtkSpeed(), AttributeModifier.Operation.ADDITION));
    }
}

