/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;

public class BookLinkRenderer
implements LinkRenderer {
    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (BookLink.isBookLink(link.getDestination())) {
            TextColor currentColor = context.getCurrentStyle().m_131135_();
            BookErrorManager.get().setContext("Link: {}, \n{}", link.getDestination(), BookErrorManager.get().getContextHelper());
            try {
                BookLink bookLink = BookLink.from(context.getBook(), link.getDestination());
                Book book = BookDataManager.get().getBook(bookLink.bookId);
                MutableComponent goToText = Component.m_237115_((String)book.getName());
                if (bookLink.categoryId != null) {
                    BookCategory category = book.getCategory(bookLink.categoryId);
                    goToText = Component.m_237115_((String)category.getName());
                }
                if (bookLink.entryId != null) {
                    BookEntry entry = book.getEntry(bookLink.entryId);
                    goToText = Component.m_237115_((String)entry.getName());
                }
                MutableComponent hoverComponent = Component.m_237110_((String)"modonomicon.gui.hover.book_link", (Object[])new Object[]{goToText});
                context.setCurrentStyle(context.getCurrentStyle().m_131148_(currentColor == null ? context.getLinkColor() : currentColor).m_131142_(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, link.getDestination())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverComponent)));
                visitChildren.accept((Node)link);
                context.setCurrentStyle(context.getCurrentStyle().m_131148_(currentColor).m_131142_(null).m_131144_(null));
            }
            catch (Exception e) {
                if (context.getBook().allowOpenBooksWithInvalidLinks()) {
                    Modonomicon.LOG.error("Failed to parse book link. allowOpenBooksWithInvalidLinks = true, so book parsing continues. Original error:", (Throwable)e);
                    MutableComponent hoverComponent = Component.m_237110_((String)"modonomicon.gui.hover.book_link.error", (Object[])new Object[]{link.getDestination()}).m_130940_(ChatFormatting.RED);
                    context.setCurrentStyle(context.getCurrentStyle().m_131140_(ChatFormatting.RED).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverComponent)));
                    visitChildren.accept((Node)link);
                    context.setCurrentStyle(context.getCurrentStyle().m_131148_(currentColor).m_131142_(null).m_131144_(null));
                }
                throw e;
            }
            BookErrorManager.get().setContext(null, new Object[0]);
            return true;
        }
        return false;
    }
}

