/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class CategoryLinkBookEntry
extends BookEntry {
    protected ResourceLocation categoryToOpenId;
    protected BookCategory categoryToOpen;

    public CategoryLinkBookEntry(ResourceLocation id, BookEntry.BookEntryData data, ResourceLocation commandToRunOnFirstReadId, ResourceLocation categoryToOpenId) {
        super(id, data, commandToRunOnFirstReadId);
        this.categoryToOpenId = categoryToOpenId;
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.EntryType.CATEGORY_LINK;
    }

    public static CategoryLinkBookEntry fromJson(ResourceLocation id, JsonObject json, boolean autoAddReadConditions) {
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(json, autoAddReadConditions);
        ResourceLocation commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        ResourceLocation categoryToOpenId = null;
        if (json.has("category_to_open")) {
            categoryToOpenId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"category_to_open"));
        }
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpenId);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        this.data.toNetwork(buffer);
        buffer.m_236821_((Object)this.commandToRunOnFirstReadId, FriendlyByteBuf::m_130085_);
        buffer.m_236821_((Object)this.categoryToOpenId, FriendlyByteBuf::m_130085_);
    }

    public static CategoryLinkBookEntry fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        ResourceLocation commandToRunOnFirstReadId = (ResourceLocation)buffer.m_236868_(FriendlyByteBuf::m_130281_);
        ResourceLocation categoryToOpen = (ResourceLocation)buffer.m_236868_(FriendlyByteBuf::m_130281_);
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpen);
    }

    @Override
    public void build(Level level, BookCategory category) {
        super.build(level, category);
        if (this.categoryToOpenId != null) {
            this.categoryToOpen = this.getBook().getCategory(this.categoryToOpenId);
            if (this.categoryToOpen == null) {
                BookErrorManager.get().error("Category to open \"" + String.valueOf(this.categoryToOpenId) + "\" does not exist in this book. Set to null.");
                this.categoryToOpenId = null;
            }
        }
    }

    public BookCategory getCategoryToOpen() {
        return this.categoryToOpen;
    }

    @Override
    public BookContentScreen openEntry(BookCategoryScreen categoryScreen) {
        categoryScreen.getBookOverviewScreen().changeCategory(this.getCategoryToOpen());
        return null;
    }
}

