/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.LaserDrillConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LaserDrillTile
extends IndustrialAreaWorkingTile<LaserDrillTile> {
    @Save
    private BlockPos target = BlockPos.f_121853_;

    public LaserDrillTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.LASER_DRILL, RangeManager.RangeType.BEHIND, false, LaserDrillConfig.powerPerOperation, blockPos, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextScreenAddon(ChatFormatting.DARK_GRAY + Component.m_237115_((String)"text.industrialforegoing.target").getString(), 44, 26, false));
        this.addGuiAddonFactory(() -> new TextScreenAddon("Target: ", 44, 36, false){

            public String getText() {
                if (LaserDrillTile.this.target.equals((Object)BlockPos.f_121853_) || LaserDrillTile.this.target == null) {
                    return ChatFormatting.DARK_GRAY + Component.m_237115_((String)"text.industrialforegoing.target_not_found").getString();
                }
                return ChatFormatting.DARK_GRAY + "X: " + LaserDrillTile.this.target.m_123341_() + " Y: " + LaserDrillTile.this.target.m_123342_() + " Z: " + LaserDrillTile.this.target.m_123343_();
            }
        });
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (!this.target.equals((Object)BlockPos.f_121853_) && !this.isValidTarget(this.target)) {
            this.target = BlockPos.f_121853_;
            this.markForUpdate();
        }
        if (this.target.equals((Object)BlockPos.f_121853_)) {
            this.findTarget();
        }
        if (!this.target.equals((Object)BlockPos.f_121853_) && this.hasEnergy(LaserDrillConfig.powerPerOperation) && this.f_58857_.m_7702_(this.target) instanceof ILaserBase) {
            ILaserBase laserBase = (ILaserBase)this.f_58857_.m_7702_(this.target);
            laserBase.getBar().setProgress(laserBase.getBar().getProgress() + 1);
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, LaserDrillConfig.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public VoxelShape getWorkingArea() {
        Vec3i vector = this.getFacingDirection().m_122424_().m_122436_();
        return Shapes.m_83048_((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).m_83216_((double)(this.f_58858_.m_123341_() + vector.m_123341_() * 2), (double)(this.f_58858_.m_123342_() + vector.m_123342_() * 2 - 1), (double)(this.f_58858_.m_123343_() + vector.m_123343_() * 2));
    }

    public void findTarget() {
        for (BlockPos blockPos : BlockUtils.getBlockPosInAABB(this.getWorkingArea().m_83215_())) {
            if (!this.isValidTarget(blockPos)) continue;
            this.target = blockPos;
            this.markForUpdate();
            return;
        }
    }

    public boolean isValidTarget(BlockPos pos) {
        if (pos.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        return this.f_58857_.m_7702_(pos) instanceof ILaserBase;
    }

    public LaserDrillTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<LaserDrillTile> createEnergyStorage() {
        return new EnergyStorageComponent(LaserDrillConfig.maxStoredPower, 10, 20);
    }

    public BlockPos getTarget() {
        return this.target;
    }

    @Override
    public int getMaxProgress() {
        return LaserDrillConfig.maxProgress;
    }
}

