/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.thedragonlib.util;

import com.sofodev.thedragonlib.util.LogHelper;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class InfoHelper {
    public static final int GUI_TITLE = 65535;

    public static void addLore(ItemStack stack, List<String> list, boolean addLeadingLine) {
        String[] lore = InfoHelper.getLore(stack);
        if (addLeadingLine) {
            list.add("");
        }
        if (lore == null) {
            list.add(ChatFormatting.ITALIC + ChatFormatting.DARK_PURPLE + "Invalid lore localization! (something is broken)");
            return;
        }
        Arrays.stream(lore).map(s -> ChatFormatting.ITALIC + ChatFormatting.DARK_PURPLE + s).forEachOrdered(list::add);
    }

    public static void addLore(ItemStack stack, List<String> list) {
        InfoHelper.addLore(stack, list, true);
    }

    public static void addEnergyAndLore(ItemStack stack, List<String> list) {
        if (!InfoHelper.isShiftKeyDown()) {
            list.add(MessageFormat.format("{0} {1}{2}{3}{4} {5}{6}", I18n.m_118938_((String)"info.sm.hold.txt", (Object[])new Object[0]), ChatFormatting.AQUA, ChatFormatting.ITALIC, I18n.m_118938_((String)"info.sm.shift.txt", (Object[])new Object[0]), ChatFormatting.RESET, ChatFormatting.GRAY, I18n.m_118938_((String)"info.sm.forDetails.txt", (Object[])new Object[0])));
        } else {
            InfoHelper.addLore(stack, list);
        }
    }

    public static String[] getLore(ItemStack stack) {
        String unlocalizeLore = stack.m_41720_().m_5524_() + ".lore";
        String rawLore = I18n.m_118938_((String)unlocalizeLore, (Object[])new Object[0]);
        if (rawLore.contains(unlocalizeLore)) {
            return new String[0];
        }
        String lineCountS = rawLore.substring(0, 1);
        rawLore = rawLore.substring(1);
        int lineCount = 0;
        try {
            lineCount = Integer.parseInt(lineCountS);
        }
        catch (NumberFormatException e) {
            LogHelper.error("Invalid Lore Format! Lore myst start with the number of lines \"3Line 1\\nLine 2\\nLine 3\"");
        }
        String[] loreLines = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            String string = loreLines[i] = rawLore.contains("\\n") ? rawLore.substring(0, rawLore.indexOf("\\n")) : rawLore;
            if (!rawLore.contains("\\n")) continue;
            rawLore = rawLore.substring(rawLore.indexOf("\\n") + 2);
        }
        return loreLines;
    }

    public static boolean isShiftKeyDown() {
        return 1 == GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || 1 == GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
    }

    public static boolean isCtrlKeyDown() {
        return 1 == GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) || 1 == GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)345);
    }

    public static boolean holdShiftForDetails(List<String> list, boolean inverted) {
        if (InfoHelper.isShiftKeyDown() == inverted) {
            list.add(I18n.m_118938_((String)"info.sc.holdShiftForDetails.txt", (Object[])new Object[]{"" + ChatFormatting.AQUA + ChatFormatting.ITALIC, "" + ChatFormatting.RESET + ChatFormatting.GRAY}));
        }
        return InfoHelper.isShiftKeyDown();
    }

    public static boolean holdShiftForDetails(List<String> list) {
        return InfoHelper.holdShiftForDetails(list, false);
    }

    public static String ITC() {
        return "" + ChatFormatting.RESET + ChatFormatting.DARK_AQUA;
    }

    public static String HITC() {
        return "" + ChatFormatting.RESET + ChatFormatting.ITALIC + ChatFormatting.GOLD;
    }
}

