/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.thedragonlib.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.sofodev.thedragonlib.util.LogHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GLStateHelper {
    private static int lastBlendState = -1;
    private static int lastAlphaState = -1;
    private static int lastDepthState = -1;

    public static void pushBlend(boolean enable) {
        if (lastBlendState != -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to push twice", new Object[0]);
        } else {
            lastBlendState = GlStateManager._getInteger((int)3042);
            if (enable) {
                GlStateManager._enableBlend();
            } else {
                GlStateManager._disableBlend();
            }
        }
    }

    public static void popBlend() {
        switch (lastBlendState) {
            case -1: {
                LogHelper.bigError("[GLStateHelper] Attempt to pop before pushing", new Object[0]);
                break;
            }
            default: {
                if (lastBlendState == 1) {
                    GlStateManager._enableBlend();
                } else {
                    GlStateManager._disableBlend();
                }
                lastBlendState = -1;
            }
        }
    }

    public static void pushAlpha(boolean enable) {
        if (lastAlphaState != -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to push twice", new Object[0]);
        } else {
            lastAlphaState = GlStateManager._getInteger((int)6406);
            if (enable) {
                GlStateManager._enableDepthTest();
            } else {
                GlStateManager._disableDepthTest();
            }
        }
    }

    public static void popAlpha() {
        if (lastAlphaState == -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to pop before pushing", new Object[0]);
        } else {
            if (lastAlphaState == 1) {
                GlStateManager._enableDepthTest();
            } else {
                GlStateManager._disableDepthTest();
            }
            lastAlphaState = -1;
        }
    }

    public static void pushDepth(boolean enable) {
        if (lastDepthState != -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to push twice", new Object[0]);
        } else {
            lastDepthState = GlStateManager._getInteger((int)6145);
            if (enable) {
                GlStateManager._enableDepthTest();
            } else {
                GlStateManager._disableDepthTest();
            }
        }
    }

    public static void popDepth() {
        if (lastDepthState == -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to pop before pushing", new Object[0]);
        } else {
            if (lastDepthState == 1) {
                GlStateManager._enableDepthTest();
            } else {
                GlStateManager._disableDepthTest();
            }
            lastDepthState = -1;
        }
    }
}

