/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import de.markusbordihn.adaptiveperformancetweakscore.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoadEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerLevelLoad {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int timeBetweenUpdates = 10000;
    private static long lastUpdateTime = System.currentTimeMillis();
    private static Map<ServerLevel, Double> levelLoad = new ConcurrentHashMap<ServerLevel, Double>();
    private static Map<ServerLevel, ServerLevelLoadLevel> levelLoadLevel = new ConcurrentHashMap<ServerLevel, ServerLevelLoadLevel>();
    private static Map<String, ServerLevelLoadLevel> levelNameLoadLevel = new ConcurrentHashMap<String, ServerLevelLoadLevel>();

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        levelLoad = new ConcurrentHashMap<ServerLevel, Double>();
        levelLoadLevel = new ConcurrentHashMap<ServerLevel, ServerLevelLoadLevel>();
        levelNameLoadLevel = new ConcurrentHashMap<String, ServerLevelLoadLevel>();
        timeBetweenUpdates = (Integer)ServerLevelLoad.COMMON.timeBetweenUpdates.get() * 1000;
    }

    public static void measureLoadAndPost(Dist dist) {
        long currentTime = System.currentTimeMillis();
        for (ServerLevel serverLevel : ServerManager.getAllLevels()) {
            double lastAvgTickTime;
            double avgTickTime = ServerManager.getAverageTickTime(serverLevel);
            ServerManager.getMinecraftServer().m_129903_();
            if (avgTickTime <= 0.0 || (lastAvgTickTime = levelLoad.getOrDefault(serverLevel, 45.0).doubleValue()) >= avgTickTime && currentTime - lastUpdateTime < (long)timeBetweenUpdates) continue;
            levelLoad.put(serverLevel, avgTickTime);
            String serverLevelName = serverLevel.m_46472_().m_135782_().toString();
            ServerLevelLoadLevel lastLoadLevel = levelLoadLevel.getOrDefault(serverLevel, ServerLevelLoadLevel.NORMAL);
            ServerLevelLoadLevel loadLevel = ServerLevelLoad.getServerLevelLoadLevelFromTickTime(avgTickTime);
            levelLoadLevel.put(serverLevel, loadLevel);
            levelNameLoadLevel.put(serverLevelName, loadLevel);
            if (loadLevel != lastLoadLevel && Boolean.TRUE.equals(ServerLevelLoad.COMMON.logServerLevelLoad.get())) {
                String loadIndicator = lastAvgTickTime > avgTickTime ? "\u2193" : "\u2191";
                log.info("{} {} Level load for {} changed from {} (avg. {}) to {} (avg. {})", (Object)"[APTweaks:Core]", (Object)loadIndicator, (Object)serverLevelName, (Object)lastLoadLevel, (Object)lastAvgTickTime, (Object)loadLevel, (Object)avgTickTime);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ServerLevelLoadEvent(serverLevel, loadLevel, lastLoadLevel, avgTickTime, lastAvgTickTime, dist));
        }
        lastUpdateTime = System.currentTimeMillis();
    }

    public static ServerLevelLoadLevel getServerLevelLoadLevelFromTickTime(double tickTime) {
        if (tickTime <= 15.0) {
            return ServerLevelLoadLevel.VERY_LOW;
        }
        if (tickTime <= 35.0) {
            return ServerLevelLoadLevel.LOW;
        }
        if (tickTime <= 41.0) {
            return ServerLevelLoadLevel.NORMAL;
        }
        if (tickTime <= 46.0) {
            return ServerLevelLoadLevel.MEDIUM;
        }
        if (tickTime <= 50.0) {
            return ServerLevelLoadLevel.HIGH;
        }
        if (tickTime > 50.0) {
            return ServerLevelLoadLevel.VERY_HIGH;
        }
        return ServerLevelLoadLevel.NORMAL;
    }

    public static Map<ServerLevel, Double> getLevelLoad() {
        return levelLoad;
    }

    public static Map<String, ServerLevelLoadLevel> getLevelNameLoadLevel() {
        return levelNameLoadLevel;
    }

    public static boolean hasHighLevelLoad(ServerLevelLoadLevel serverLevelLoadLevel) {
        if (serverLevelLoadLevel == null) {
            return false;
        }
        return switch (serverLevelLoadLevel) {
            case ServerLevelLoadLevel.MEDIUM, ServerLevelLoadLevel.HIGH, ServerLevelLoadLevel.VERY_HIGH -> true;
            default -> false;
        };
    }

    public static enum ServerLevelLoadLevel {
        VERY_LOW,
        LOW,
        NORMAL,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }
}

