/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.player;

import de.markusbordihn.adaptiveperformancetweakscore.viewarea.ViewArea;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class PlayerPosition {
    private static final String NETHER = "minecraft:the_nether";
    private static final String THE_END = "minecraft:the_end";
    private static final int CHUNK_SIZE = 16;
    private final ViewArea viewArea;
    private final String playerName;
    private final UUID playerUUID;
    private String levelName;

    public PlayerPosition(ServerPlayer player, int viewDistance, int simulationDistance) {
        this.playerName = player.m_7755_().getString();
        this.playerUUID = player.m_20148_();
        this.levelName = player.m_9236_().m_46472_().m_135782_().toString();
        int viewAreaDistance = PlayerPosition.getViewAreaDistance(player, this.levelName, viewDistance, simulationDistance);
        this.viewArea = new ViewArea(player, viewAreaDistance);
    }

    public static int getViewAreaDistance(ServerPlayer serverPlayer, String levelName, int viewDistance, int simulationDistance) {
        boolean isUnderWater;
        boolean isNether = levelName.equals(NETHER);
        boolean isTheEnd = levelName.equals(THE_END);
        boolean canSeeSky = !isNether && serverPlayer.m_9236_().m_45527_(serverPlayer.m_20183_());
        boolean bl = isUnderWater = !isNether && serverPlayer.m_5842_();
        if (!isNether && !isTheEnd && !canSeeSky || isUnderWater) {
            return Math.min(simulationDistance, viewDistance - 1) * 16;
        }
        return viewDistance * 16;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean update(ServerPlayer serverPlayer, String levelName, int viewDistance, int simulationDistance) {
        this.levelName = levelName;
        int viewAreaDistance = PlayerPosition.getViewAreaDistance(serverPlayer, levelName, viewDistance, simulationDistance);
        return this.viewArea.update(serverPlayer, viewAreaDistance, levelName);
    }

    public boolean isInsidePlayerViewArea(String levelName) {
        return this.levelName.equals(levelName);
    }

    public boolean isInsidePlayerViewArea(String levelName, int x, int y, int z) {
        return this.levelName.equals(levelName) && this.viewArea.isInside(x, y, z);
    }

    public boolean isInsidePlayerViewArea(Entity entity, String levelName) {
        return this.viewArea.isInside(entity, levelName);
    }

    public String toString() {
        int viewDistance = 8;
        int simulationDistance = 4;
        return "PlayerPosition[player='" + this.playerName + "', uuid=" + String.valueOf(this.playerUUID) + ", level='" + this.levelName + "', viewDistance=" + viewDistance + ", simulationDistance=" + simulationDistance + ", viewArea=" + this.viewArea.toString() + "]";
    }
}

