/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPosition;
import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPositionManager;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class PlayerPositionCommand
extends CustomCommand {
    private static final PlayerPositionCommand command = new PlayerPositionCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"playerPositions").requires(cs -> cs.m_6761_(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Map<String, PlayerPosition> playerPositionMap = PlayerPositionManager.getPlayerPositionMap();
        if (playerPositionMap.isEmpty()) {
            PlayerPositionCommand.sendFeedback(context, "Unable to find any player position!?");
        } else {
            PlayerPositionCommand.sendFeedback(context, String.format("Player Positions (%s online)\n===", playerPositionMap.size()));
            for (Map.Entry<String, PlayerPosition> player : playerPositionMap.entrySet()) {
                PlayerPosition playerPosition = player.getValue();
                PlayerPositionCommand.sendFeedback(context, String.format("\u221f %s %s", playerPosition.getPlayerName(), playerPosition));
            }
        }
        return 0;
    }
}

